/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class FileInputFormat<K, V>
implements InputFormat<K, V> {
    public static final Log LOG = LogFactory.getLog(FileInputFormat.class);
    public static final String NUM_INPUT_FILES = "mapreduce.input.fileinputformat.numinputfiles";
    private static final double SPLIT_SLOP = 1.1;
    private long minSplitSize = 1L;
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    protected void setMinSplitSize(long minSplitSize) {
        this.minSplitSize = minSplitSize;
    }

    protected boolean isSplitable(FileSystem fs, Path filename) {
        return true;
    }

    @Override
    public abstract RecordReader<K, V> getRecordReader(InputSplit var1, JobConf var2, Reporter var3) throws IOException;

    public static void setInputPathFilter(JobConf conf, Class<? extends PathFilter> filter) {
        conf.setClass("mapreduce.input.pathFilter.class", filter, PathFilter.class);
    }

    public static PathFilter getInputPathFilter(JobConf conf) {
        Class filterClass = conf.getClass("mapreduce.input.pathFilter.class", null, PathFilter.class);
        return filterClass != null ? (PathFilter)ReflectionUtils.newInstance((Class)filterClass, (Configuration)conf) : null;
    }

    protected void addInputPathRecursively(List<FileStatus> result, FileSystem fs, Path path, PathFilter inputFilter) throws IOException {
        for (FileStatus stat : fs.listStatus(path, inputFilter)) {
            if (stat.isDirectory()) {
                this.addInputPathRecursively(result, fs, stat.getPath(), inputFilter);
                continue;
            }
            result.add(stat);
        }
    }

    protected FileStatus[] listStatus(JobConf job) throws IOException {
        Path[] dirs = FileInputFormat.getInputPaths(job);
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        TokenCache.obtainTokensForNamenodes(job.getCredentials(), dirs, job);
        boolean recursive = job.getBoolean("mapred.input.dir.recursive", false);
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        ArrayList<IOException> errors = new ArrayList<IOException>();
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
        filters.add(hiddenFileFilter);
        PathFilter jobFilter = FileInputFormat.getInputPathFilter(job);
        if (jobFilter != null) {
            filters.add(jobFilter);
        }
        MultiPathFilter inputFilter = new MultiPathFilter(filters);
        for (Path p : dirs) {
            FileSystem fs = p.getFileSystem((Configuration)job);
            FileStatus[] matches = fs.globStatus(p, (PathFilter)inputFilter);
            if (matches == null) {
                errors.add(new IOException("Input path does not exist: " + p));
                continue;
            }
            if (matches.length == 0) {
                errors.add(new IOException("Input Pattern " + p + " matches 0 files"));
                continue;
            }
            for (FileStatus globStat : matches) {
                if (globStat.isDirectory()) {
                    for (FileStatus stat : fs.listStatus(globStat.getPath(), (PathFilter)inputFilter)) {
                        if (recursive && stat.isDirectory()) {
                            this.addInputPathRecursively(result, fs, stat.getPath(), inputFilter);
                            continue;
                        }
                        result.add(stat);
                    }
                    continue;
                }
                result.add(globStat);
            }
        }
        if (!errors.isEmpty()) {
            throw new InvalidInputException(errors);
        }
        LOG.info((Object)("Total input paths to process : " + result.size()));
        return result.toArray(new FileStatus[result.size()]);
    }

    protected FileSplit makeSplit(Path file, long start, long length, String[] hosts) {
        return new FileSplit(file, start, length, hosts);
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        FileStatus[] files = this.listStatus(job);
        job.setLong(NUM_INPUT_FILES, files.length);
        long totalSize = 0L;
        for (FileStatus file : files) {
            if (file.isDirectory()) {
                throw new IOException("Not a file: " + file.getPath());
            }
            totalSize += file.getLen();
        }
        long goalSize = totalSize / (long)(numSplits == 0 ? 1 : numSplits);
        long minSize = Math.max(job.getLong("mapreduce.input.fileinputformat.split.minsize", 1L), this.minSplitSize);
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>(numSplits);
        NetworkTopology clusterMap = new NetworkTopology();
        for (FileStatus file : files) {
            Path path = file.getPath();
            FileSystem fs = path.getFileSystem((Configuration)job);
            long length = file.getLen();
            BlockLocation[] blkLocations = fs.getFileBlockLocations(file, 0L, length);
            if (length != 0L && this.isSplitable(fs, path)) {
                long blockSize = file.getBlockSize();
                long splitSize = this.computeSplitSize(goalSize, minSize, blockSize);
                long bytesRemaining = length;
                while ((double)bytesRemaining / (double)splitSize > 1.1) {
                    String[] splitHosts = this.getSplitHosts(blkLocations, length - bytesRemaining, splitSize, clusterMap);
                    splits.add(this.makeSplit(path, length - bytesRemaining, splitSize, splitHosts));
                    bytesRemaining -= splitSize;
                }
                if (bytesRemaining == 0L) continue;
                splits.add(this.makeSplit(path, length - bytesRemaining, bytesRemaining, blkLocations[blkLocations.length - 1].getHosts()));
                continue;
            }
            if (length != 0L) {
                String[] splitHosts = this.getSplitHosts(blkLocations, 0L, length, clusterMap);
                splits.add(this.makeSplit(path, 0L, length, splitHosts));
                continue;
            }
            splits.add(this.makeSplit(path, 0L, length, new String[0]));
        }
        LOG.debug((Object)("Total # of splits: " + splits.size()));
        return splits.toArray(new FileSplit[splits.size()]);
    }

    protected long computeSplitSize(long goalSize, long minSize, long blockSize) {
        return Math.max(minSize, Math.min(goalSize, blockSize));
    }

    protected int getBlockIndex(BlockLocation[] blkLocations, long offset) {
        for (int i = 0; i < blkLocations.length; ++i) {
            if (blkLocations[i].getOffset() > offset || offset >= blkLocations[i].getOffset() + blkLocations[i].getLength()) continue;
            return i;
        }
        BlockLocation last = blkLocations[blkLocations.length - 1];
        long fileLength = last.getOffset() + last.getLength() - 1L;
        throw new IllegalArgumentException("Offset " + offset + " is outside of file (0.." + fileLength + ")");
    }

    public static void setInputPaths(JobConf conf, String commaSeparatedPaths) {
        FileInputFormat.setInputPaths(conf, StringUtils.stringToPath((String[])FileInputFormat.getPathStrings(commaSeparatedPaths)));
    }

    public static void addInputPaths(JobConf conf, String commaSeparatedPaths) {
        for (String str : FileInputFormat.getPathStrings(commaSeparatedPaths)) {
            FileInputFormat.addInputPath(conf, new Path(str));
        }
    }

    public static void setInputPaths(JobConf conf, Path ... inputPaths) {
        Path path = new Path(conf.getWorkingDirectory(), inputPaths[0]);
        StringBuffer str = new StringBuffer(StringUtils.escapeString((String)path.toString()));
        for (int i = 1; i < inputPaths.length; ++i) {
            str.append(",");
            path = new Path(conf.getWorkingDirectory(), inputPaths[i]);
            str.append(StringUtils.escapeString((String)path.toString()));
        }
        conf.set("mapreduce.input.fileinputformat.inputdir", str.toString());
    }

    public static void addInputPath(JobConf conf, Path path) {
        path = new Path(conf.getWorkingDirectory(), path);
        String dirStr = StringUtils.escapeString((String)path.toString());
        String dirs = conf.get("mapreduce.input.fileinputformat.inputdir");
        conf.set("mapreduce.input.fileinputformat.inputdir", dirs == null ? dirStr : dirs + "," + dirStr);
    }

    private static String[] getPathStrings(String commaSeparatedPaths) {
        int length = commaSeparatedPaths.length();
        int curlyOpen = 0;
        int pathStart = 0;
        boolean globPattern = false;
        ArrayList<String> pathStrings = new ArrayList<String>();
        block5: for (int i = 0; i < length; ++i) {
            char ch = commaSeparatedPaths.charAt(i);
            switch (ch) {
                case '{': {
                    ++curlyOpen;
                    if (globPattern) continue block5;
                    globPattern = true;
                    continue block5;
                }
                case '}': {
                    if (--curlyOpen != 0 || !globPattern) continue block5;
                    globPattern = false;
                    continue block5;
                }
                case ',': {
                    if (globPattern) continue block5;
                    pathStrings.add(commaSeparatedPaths.substring(pathStart, i));
                    pathStart = i + 1;
                }
            }
        }
        pathStrings.add(commaSeparatedPaths.substring(pathStart, length));
        return pathStrings.toArray(new String[0]);
    }

    public static Path[] getInputPaths(JobConf conf) {
        String dirs = conf.get("mapreduce.input.fileinputformat.inputdir", "");
        String[] list = StringUtils.split((String)dirs);
        Path[] result = new Path[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new Path(StringUtils.unEscapeString((String)list[i]));
        }
        return result;
    }

    private void sortInDescendingOrder(List<NodeInfo> mylist) {
        Collections.sort(mylist, new Comparator<NodeInfo>(){

            @Override
            public int compare(NodeInfo obj1, NodeInfo obj2) {
                if (obj1 == null || obj2 == null) {
                    return -1;
                }
                if (obj1.getValue() == obj2.getValue()) {
                    return 0;
                }
                return obj1.getValue() < obj2.getValue() ? 1 : -1;
            }
        });
    }

    protected String[] getSplitHosts(BlockLocation[] blkLocations, long offset, long splitSize, NetworkTopology clusterMap) throws IOException {
        int startIndex = this.getBlockIndex(blkLocations, offset);
        long bytesInThisBlock = blkLocations[startIndex].getOffset() + blkLocations[startIndex].getLength() - offset;
        if (bytesInThisBlock >= splitSize) {
            return blkLocations[startIndex].getHosts();
        }
        long bytesInFirstBlock = bytesInThisBlock;
        int index = startIndex + 1;
        splitSize -= bytesInThisBlock;
        while (splitSize > 0L) {
            bytesInThisBlock = Math.min(splitSize, blkLocations[index++].getLength());
            splitSize -= bytesInThisBlock;
        }
        long bytesInLastBlock = bytesInThisBlock;
        int endIndex = index - 1;
        IdentityHashMap<Node, NodeInfo> hostsMap = new IdentityHashMap<Node, NodeInfo>();
        IdentityHashMap<Node, NodeInfo> racksMap = new IdentityHashMap<Node, NodeInfo>();
        String[] allTopos = new String[]{};
        for (index = startIndex; index <= endIndex; ++index) {
            bytesInThisBlock = index == startIndex ? bytesInFirstBlock : (index == endIndex ? bytesInLastBlock : blkLocations[index].getLength());
            allTopos = blkLocations[index].getTopologyPaths();
            if (allTopos.length == 0) {
                allTopos = this.fakeRacks(blkLocations, index);
            }
            for (String topo : allTopos) {
                NodeInfo parentNodeInfo;
                Node parentNode;
                NodeInfo nodeInfo;
                Node node = clusterMap.getNode(topo);
                if (node == null) {
                    node = new NodeBase(topo);
                    clusterMap.add(node);
                }
                if ((nodeInfo = (NodeInfo)hostsMap.get(node)) == null) {
                    nodeInfo = new NodeInfo(node);
                    hostsMap.put(node, nodeInfo);
                    parentNode = node.getParent();
                    parentNodeInfo = (NodeInfo)racksMap.get(parentNode);
                    if (parentNodeInfo == null) {
                        parentNodeInfo = new NodeInfo(parentNode);
                        racksMap.put(parentNode, parentNodeInfo);
                    }
                    parentNodeInfo.addLeaf(nodeInfo);
                } else {
                    nodeInfo = (NodeInfo)hostsMap.get(node);
                    parentNode = node.getParent();
                    parentNodeInfo = (NodeInfo)racksMap.get(parentNode);
                }
                nodeInfo.addValue(index, bytesInThisBlock);
                parentNodeInfo.addValue(index, bytesInThisBlock);
            }
        }
        return this.identifyHosts(allTopos.length, racksMap);
    }

    private String[] identifyHosts(int replicationFactor, Map<Node, NodeInfo> racksMap) {
        String[] retVal = new String[replicationFactor];
        LinkedList<NodeInfo> rackList = new LinkedList<NodeInfo>();
        rackList.addAll(racksMap.values());
        this.sortInDescendingOrder(rackList);
        boolean done = false;
        int index = 0;
        for (NodeInfo ni : rackList) {
            Set<NodeInfo> hostSet = ni.getLeaves();
            LinkedList<NodeInfo> hostList = new LinkedList<NodeInfo>();
            hostList.addAll(hostSet);
            this.sortInDescendingOrder(hostList);
            for (NodeInfo host : hostList) {
                retVal[index++] = host.node.getName().split(":")[0];
                if (index != replicationFactor) continue;
                done = true;
                break;
            }
            if (!done) continue;
            break;
        }
        return retVal;
    }

    private String[] fakeRacks(BlockLocation[] blkLocations, int index) throws IOException {
        String[] allHosts = blkLocations[index].getHosts();
        String[] allTopos = new String[allHosts.length];
        for (int i = 0; i < allHosts.length; ++i) {
            allTopos[i] = "/default-rack/" + allHosts[i];
        }
        return allTopos;
    }

    private static class NodeInfo {
        final Node node;
        final Set<Integer> blockIds;
        final Set<NodeInfo> leaves;
        private long value;

        NodeInfo(Node node) {
            this.node = node;
            this.blockIds = new HashSet<Integer>();
            this.leaves = new HashSet<NodeInfo>();
        }

        long getValue() {
            return this.value;
        }

        void addValue(int blockIndex, long value) {
            if (this.blockIds.add(blockIndex)) {
                this.value += value;
            }
        }

        Set<NodeInfo> getLeaves() {
            return this.leaves;
        }

        void addLeaf(NodeInfo nodeInfo) {
            this.leaves.add(nodeInfo);
        }
    }

    private static class MultiPathFilter
    implements PathFilter {
        private List<PathFilter> filters;

        public MultiPathFilter(List<PathFilter> filters) {
            this.filters = filters;
        }

        public boolean accept(Path path) {
            for (PathFilter filter : this.filters) {
                if (filter.accept(path)) continue;
                return false;
            }
            return true;
        }
    }
}

