/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.util.List;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskTrackerInstrumentation;

class CompositeTaskTrackerInstrumentation
extends TaskTrackerInstrumentation {
    private List<TaskTrackerInstrumentation> instrumentations;

    public CompositeTaskTrackerInstrumentation(TaskTracker tt, List<TaskTrackerInstrumentation> instrumentations) {
        super(tt);
        this.instrumentations = instrumentations;
    }

    List<TaskTrackerInstrumentation> getInstrumentations() {
        return this.instrumentations;
    }

    @Override
    public void completeTask(TaskAttemptID t) {
        for (TaskTrackerInstrumentation tti : this.instrumentations) {
            tti.completeTask(t);
        }
    }

    @Override
    public void timedoutTask(TaskAttemptID t) {
        for (TaskTrackerInstrumentation tti : this.instrumentations) {
            tti.timedoutTask(t);
        }
    }

    @Override
    public void taskFailedPing(TaskAttemptID t) {
        for (TaskTrackerInstrumentation tti : this.instrumentations) {
            tti.taskFailedPing(t);
        }
    }

    @Override
    public void reportTaskLaunch(TaskAttemptID t, File stdout, File stderr) {
        for (TaskTrackerInstrumentation tti : this.instrumentations) {
            tti.reportTaskLaunch(t, stdout, stderr);
        }
    }

    @Override
    public void reportTaskEnd(TaskAttemptID t) {
        for (TaskTrackerInstrumentation tti : this.instrumentations) {
            tti.reportTaskEnd(t);
        }
    }

    @Override
    public void statusUpdate(Task task, TaskStatus taskStatus) {
        for (TaskTrackerInstrumentation tti : this.instrumentations) {
            tti.statusUpdate(task, taskStatus);
        }
    }
}

