/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.AuditLogger;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.Operation;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;

@InterfaceAudience.Private
class ACLsManager {
    static Log LOG = LogFactory.getLog(ACLsManager.class);
    private final UserGroupInformation mrOwner = UserGroupInformation.getCurrentUser();
    private final AccessControlList adminAcl;
    private final JobACLsManager jobACLsManager;
    private final QueueManager queueManager;
    private final boolean aclsEnabled;

    ACLsManager(Configuration conf, JobACLsManager jobACLsManager, QueueManager queueManager) throws IOException {
        this.adminAcl = new AccessControlList(conf.get("mapreduce.cluster.administrators", " "));
        this.adminAcl.addUser(this.mrOwner.getShortUserName());
        String deprecatedSuperGroup = conf.get("mapreduce.cluster.permissions.supergroup");
        if (deprecatedSuperGroup != null) {
            LOG.warn((Object)"mapreduce.cluster.permissions.supergroup is deprecated. Use mapreduce.cluster.administrators instead");
            this.adminAcl.addGroup(deprecatedSuperGroup);
        }
        this.aclsEnabled = conf.getBoolean("mapreduce.cluster.acls.enabled", false);
        this.jobACLsManager = jobACLsManager;
        this.queueManager = queueManager;
    }

    UserGroupInformation getMROwner() {
        return this.mrOwner;
    }

    AccessControlList getAdminsAcl() {
        return this.adminAcl;
    }

    JobACLsManager getJobACLsManager() {
        return this.jobACLsManager;
    }

    boolean isMRAdmin(UserGroupInformation callerUGI) {
        return this.adminAcl.isUserAllowed(callerUGI);
    }

    void checkAccess(JobInProgress job, UserGroupInformation callerUGI, Operation operation) throws AccessControlException {
        String queue = job.getProfile().getQueueName();
        String jobId = job.getJobID().toString();
        JobStatus jobStatus = job.getStatus();
        String jobOwner = jobStatus.getUsername();
        AccessControlList jobAcl = jobStatus.getJobACLs().get((Object)operation.jobACLNeeded);
        this.checkAccess(jobId, callerUGI, queue, operation, jobOwner, jobAcl);
    }

    void checkAccess(JobStatus jobStatus, UserGroupInformation callerUGI, String queue, Operation operation) throws AccessControlException {
        String jobId = jobStatus.getJobID().toString();
        String jobOwner = jobStatus.getUsername();
        AccessControlList jobAcl = jobStatus.getJobACLs().get((Object)operation.jobACLNeeded);
        this.checkAccess(jobId, callerUGI, queue, operation, jobOwner, jobAcl);
    }

    void checkAccess(String jobId, UserGroupInformation callerUGI, String queue, Operation operation, String jobOwner, AccessControlList jobAcl) throws AccessControlException {
        String user = callerUGI.getShortUserName();
        String targetResource = jobId + " in queue " + queue;
        if (!this.aclsEnabled) {
            AuditLogger.logSuccess(user, operation.name(), targetResource);
            return;
        }
        if (this.isMRAdmin(callerUGI)) {
            AuditLogger.logSuccess(user, operation.name(), targetResource);
            return;
        }
        if (operation == Operation.SUBMIT_JOB) {
            if (!this.queueManager.hasAccess(queue, operation.qACLNeeded, callerUGI)) {
                AuditLogger.logFailure(user, operation.name(), this.queueManager.getQueueACL(queue, operation.qACLNeeded).toString(), targetResource, "Unauthorized user");
                throw new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform " + "operation " + operation.name() + " on queue " + queue + ".\n Please run \"hadoop queue -showacls\" " + "command to find the queues you have access to .");
            }
            AuditLogger.logSuccess(user, operation.name(), targetResource);
            return;
        }
        if (operation == Operation.VIEW_TASK_LOGS) {
            if (this.jobACLsManager.checkAccess(callerUGI, operation.jobACLNeeded, jobOwner, jobAcl)) {
                AuditLogger.logSuccess(user, operation.name(), targetResource);
                return;
            }
        } else if (this.queueManager.hasAccess(queue, operation.qACLNeeded, callerUGI) || this.jobACLsManager.checkAccess(callerUGI, operation.jobACLNeeded, jobOwner, jobAcl)) {
            AuditLogger.logSuccess(user, operation.name(), targetResource);
            return;
        }
        AuditLogger.logFailure(user, operation.name(), jobAcl.toString(), targetResource, "Unauthorized user");
        throw new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + operation.name() + " on " + jobId + " that is in the queue " + queue);
    }
}

