/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.web.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsCreateModes;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.ParamFilter;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.hdfs.web.resources.AccessTimeParam;
import org.apache.hadoop.hdfs.web.resources.AclPermissionParam;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.ConcatSourcesParam;
import org.apache.hadoop.hdfs.web.resources.CreateFlagParam;
import org.apache.hadoop.hdfs.web.resources.CreateParentParam;
import org.apache.hadoop.hdfs.web.resources.DelegationParam;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.DestinationParam;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.ExcludeDatanodesParam;
import org.apache.hadoop.hdfs.web.resources.FsActionParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.GroupParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.ModificationTimeParam;
import org.apache.hadoop.hdfs.web.resources.NamenodeAddressParam;
import org.apache.hadoop.hdfs.web.resources.NewLengthParam;
import org.apache.hadoop.hdfs.web.resources.NoRedirectParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OldSnapshotNameParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.OwnerParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RecursiveParam;
import org.apache.hadoop.hdfs.web.resources.RenameOptionSetParam;
import org.apache.hadoop.hdfs.web.resources.RenewerParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.SnapshotNameParam;
import org.apache.hadoop.hdfs.web.resources.StartAfterParam;
import org.apache.hadoop.hdfs.web.resources.StoragePolicyParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.hdfs.web.resources.TokenKindParam;
import org.apache.hadoop.hdfs.web.resources.TokenServiceParam;
import org.apache.hadoop.hdfs.web.resources.UnmaskedPermissionParam;
import org.apache.hadoop.hdfs.web.resources.UriFsPathParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.hdfs.web.resources.XAttrEncodingParam;
import org.apache.hadoop.hdfs.web.resources.XAttrNameParam;
import org.apache.hadoop.hdfs.web.resources.XAttrSetFlagParam;
import org.apache.hadoop.hdfs.web.resources.XAttrValueParam;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ExternalCall;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;

@Path(value="")
@ResourceFilters(value={ParamFilter.class})
public class NamenodeWebHdfsMethods {
    public static final Log LOG = LogFactory.getLog(NamenodeWebHdfsMethods.class);
    private static final UriFsPathParam ROOT = new UriFsPathParam("");
    private volatile Boolean useIpcCallq;
    private String scheme;
    private Principal userPrincipal;
    private String remoteAddr;
    @Context
    private ServletContext context;
    @Context
    private HttpServletResponse response;

    public NamenodeWebHdfsMethods(@Context HttpServletRequest request) {
        this.scheme = request.getScheme();
        this.userPrincipal = request.getUserPrincipal();
        this.remoteAddr = JspHelper.getRemoteAddr(request);
    }

    private void init(UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, UriFsPathParam path, HttpOpParam<?> op, Param<?, ?> ... parameters) {
        if (this.useIpcCallq == null) {
            Configuration conf = (Configuration)this.context.getAttribute("current.conf");
            this.useIpcCallq = conf.getBoolean("dfs.webhdfs.use.ipc.callq", true);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("HTTP " + ((HttpOpParam.Op)((Enum)op.getValue())).getType() + ": " + op + ", " + (Object)((Object)path) + ", ugi=" + ugi + ", " + username + ", " + doAsUser + Param.toSortedString((String)", ", parameters)));
        }
        this.response.setContentType(null);
    }

    private static NamenodeProtocols getRPCServer(NameNode namenode) throws IOException {
        NamenodeProtocols np = namenode.getRpcServer();
        if (np == null) {
            throw new RetriableException("Namenode is in startup mode");
        }
        return np;
    }

    private <T> T doAs(UserGroupInformation ugi, PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
        return (T)(this.useIpcCallq != false ? this.doAsExternalCall(ugi, action) : ugi.doAs(action));
    }

    private <T> T doAsExternalCall(final UserGroupInformation ugi, PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
        ExternalCall call = new ExternalCall<T>(action){

            public UserGroupInformation getRemoteUser() {
                return ugi;
            }

            public String getProtocol() {
                return "webhdfs";
            }

            public String getHostAddress() {
                return NamenodeWebHdfsMethods.this.remoteAddr;
            }

            public InetAddress getHostInetAddress() {
                try {
                    return InetAddress.getByName(this.getHostAddress());
                }
                catch (UnknownHostException e) {
                    return null;
                }
            }
        };
        NameNode namenode = (NameNode)this.context.getAttribute("name.node");
        namenode.queueExternalCall(call);
        Object result = null;
        try {
            result = call.get();
        }
        catch (ExecutionException ee) {
            Throwable t = ee.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
        return (T)result;
    }

    @VisibleForTesting
    static DatanodeInfo chooseDatanode(NameNode namenode, String path, HttpOpParam.Op op, long openOffset, long blocksize, String excludeDatanodes, String remoteAddr) throws IOException {
        FSNamesystem fsn = namenode.getNamesystem();
        if (fsn == null) {
            throw new IOException("Namesystem has not been intialized yet.");
        }
        BlockManager bm = fsn.getBlockManager();
        HashSet<Node> excludes = new HashSet<Node>();
        if (excludeDatanodes != null) {
            for (String host : StringUtils.getTrimmedStringCollection((String)excludeDatanodes)) {
                int idx = host.indexOf(":");
                if (idx != -1) {
                    excludes.add((Node)bm.getDatanodeManager().getDatanodeByXferAddr(host.substring(0, idx), Integer.parseInt(host.substring(idx + 1))));
                    continue;
                }
                excludes.add((Node)bm.getDatanodeManager().getDatanodeByHost(host));
            }
        }
        if (op == PutOpParam.Op.CREATE) {
            DatanodeStorageInfo[] storages;
            DatanodeDescriptor clientNode = bm.getDatanodeManager().getDatanodeByHost(remoteAddr);
            if (clientNode != null && (storages = bm.chooseTarget4WebHDFS(path, clientNode, excludes, blocksize)).length > 0) {
                return storages[0].getDatanodeDescriptor();
            }
        } else if (op == GetOpParam.Op.OPEN || op == GetOpParam.Op.GETFILECHECKSUM || op == PostOpParam.Op.APPEND) {
            long offset;
            LocatedBlocks locations;
            int count;
            NamenodeProtocols np = NamenodeWebHdfsMethods.getRPCServer(namenode);
            HdfsFileStatus status = np.getFileInfo(path);
            if (status == null) {
                throw new FileNotFoundException("File " + path + " not found.");
            }
            long len = status.getLen();
            if (op == GetOpParam.Op.OPEN && (openOffset < 0L || openOffset >= len && len > 0L)) {
                throw new IOException("Offset=" + openOffset + " out of the range [0, " + len + "); " + op + ", path=" + path);
            }
            if (len > 0L && (count = (locations = np.getBlockLocations(path, offset = op == GetOpParam.Op.OPEN ? openOffset : len - 1L, 1L)).locatedBlockCount()) > 0) {
                return NamenodeWebHdfsMethods.bestNode(locations.get(0).getLocations(), excludes);
            }
        }
        return (DatanodeDescriptor)bm.getDatanodeManager().getNetworkTopology().chooseRandom("", excludes);
    }

    private static DatanodeInfo bestNode(DatanodeInfo[] nodes, HashSet<Node> excludes) throws IOException {
        for (DatanodeInfo dn : nodes) {
            if (dn.isDecommissioned() || excludes.contains(dn)) continue;
            return dn;
        }
        throw new IOException("No active nodes contain this block");
    }

    private Token<? extends TokenIdentifier> generateDelegationToken(NameNode namenode, UserGroupInformation ugi, String renewer) throws IOException {
        Credentials c = DelegationTokenSecretManager.createCredentials(namenode, ugi, renewer != null ? renewer : ugi.getShortUserName());
        if (c == null) {
            return null;
        }
        Token t = (Token)c.getAllTokens().iterator().next();
        Text kind = this.scheme.equals("http") ? WebHdfsConstants.WEBHDFS_TOKEN_KIND : WebHdfsConstants.SWEBHDFS_TOKEN_KIND;
        t.setKind(kind);
        return t;
    }

    private URI redirectURI(NameNode namenode, UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, String path, HttpOpParam.Op op, long openOffset, long blocksize, String excludeDatanodes, Param<?, ?> ... parameters) throws URISyntaxException, IOException {
        String delegationQuery;
        DatanodeInfo dn = NamenodeWebHdfsMethods.chooseDatanode(namenode, path, op, openOffset, blocksize, excludeDatanodes, this.remoteAddr);
        if (dn == null) {
            throw new IOException("Failed to find datanode, suggest to check cluster health. excludeDatanodes=" + excludeDatanodes);
        }
        if (!UserGroupInformation.isSecurityEnabled()) {
            delegationQuery = Param.toSortedString((String)"&", (Param[])new Param[]{doAsUser, username});
        } else if (delegation.getValue() != null) {
            delegationQuery = "&" + delegation;
        } else {
            Token<? extends TokenIdentifier> t = this.generateDelegationToken(namenode, ugi, null);
            delegationQuery = "&" + new DelegationParam(t.encodeToUrlString());
        }
        String query = op.toQueryString() + delegationQuery + "&" + (Object)((Object)new NamenodeAddressParam(namenode)) + Param.toSortedString((String)"&", parameters);
        String uripath = "/webhdfs/v1" + path;
        int port = "http".equals(this.scheme) ? dn.getInfoPort() : dn.getInfoSecurePort();
        URI uri = new URI(this.scheme, null, dn.getHostName(), port, uripath, query, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("redirectURI=" + uri));
        }
        return uri;
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream; charset=utf-8", "application/json; charset=utf-8"})
    public Response putRoot(@Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, @QueryParam(value="op") @DefaultValue(value="null") PutOpParam op, @QueryParam(value="destination") @DefaultValue(value="") DestinationParam destination, @QueryParam(value="owner") @DefaultValue(value="") OwnerParam owner, @QueryParam(value="group") @DefaultValue(value="") GroupParam group, @QueryParam(value="permission") @DefaultValue(value="null") PermissionParam permission, @QueryParam(value="unmaskedpermission") @DefaultValue(value="null") UnmaskedPermissionParam unmaskedPermission, @QueryParam(value="overwrite") @DefaultValue(value="false") OverwriteParam overwrite, @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, @QueryParam(value="replication") @DefaultValue(value="null") ReplicationParam replication, @QueryParam(value="blocksize") @DefaultValue(value="null") BlockSizeParam blockSize, @QueryParam(value="modificationtime") @DefaultValue(value="-1") ModificationTimeParam modificationTime, @QueryParam(value="accesstime") @DefaultValue(value="-1") AccessTimeParam accessTime, @QueryParam(value="renameoptions") @DefaultValue(value="") RenameOptionSetParam renameOptions, @QueryParam(value="createparent") @DefaultValue(value="true") CreateParentParam createParent, @QueryParam(value="token") @DefaultValue(value="") TokenArgumentParam delegationTokenArgument, @QueryParam(value="aclspec") @DefaultValue(value="") AclPermissionParam aclPermission, @QueryParam(value="xattr.name") @DefaultValue(value="") XAttrNameParam xattrName, @QueryParam(value="xattr.value") @DefaultValue(value="") XAttrValueParam xattrValue, @QueryParam(value="flag") @DefaultValue(value="") XAttrSetFlagParam xattrSetFlag, @QueryParam(value="snapshotname") @DefaultValue(value="") SnapshotNameParam snapshotName, @QueryParam(value="oldsnapshotname") @DefaultValue(value="") OldSnapshotNameParam oldSnapshotName, @QueryParam(value="excludedatanodes") @DefaultValue(value="") ExcludeDatanodesParam excludeDatanodes, @QueryParam(value="createflag") @DefaultValue(value="") CreateFlagParam createFlagParam, @QueryParam(value="noredirect") @DefaultValue(value="false") NoRedirectParam noredirect, @QueryParam(value="storagepolicy") @DefaultValue(value="") StoragePolicyParam policyName) throws IOException, InterruptedException {
        return this.put(ugi, delegation, username, doAsUser, ROOT, op, destination, owner, group, permission, unmaskedPermission, overwrite, bufferSize, replication, blockSize, modificationTime, accessTime, renameOptions, createParent, delegationTokenArgument, aclPermission, xattrName, xattrValue, xattrSetFlag, snapshotName, oldSnapshotName, excludeDatanodes, createFlagParam, noredirect, policyName);
    }

    private void validateOpParams(HttpOpParam<?> op, Param ... params) {
        for (Param param : params) {
            if (param.getValue() != null && param.getValueString() != null && !param.getValueString().isEmpty()) continue;
            throw new IllegalArgumentException("Required param " + param.getName() + " for op: " + op.getValueString() + " is null or empty");
        }
    }

    @PUT
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream; charset=utf-8", "application/json; charset=utf-8"})
    public Response put(final @Context UserGroupInformation ugi, final @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, final @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, final @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") PutOpParam op, final @QueryParam(value="destination") @DefaultValue(value="") DestinationParam destination, final @QueryParam(value="owner") @DefaultValue(value="") OwnerParam owner, final @QueryParam(value="group") @DefaultValue(value="") GroupParam group, final @QueryParam(value="permission") @DefaultValue(value="null") PermissionParam permission, final @QueryParam(value="unmaskedpermission") @DefaultValue(value="null") UnmaskedPermissionParam unmaskedPermission, final @QueryParam(value="overwrite") @DefaultValue(value="false") OverwriteParam overwrite, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, final @QueryParam(value="replication") @DefaultValue(value="null") ReplicationParam replication, final @QueryParam(value="blocksize") @DefaultValue(value="null") BlockSizeParam blockSize, final @QueryParam(value="modificationtime") @DefaultValue(value="-1") ModificationTimeParam modificationTime, final @QueryParam(value="accesstime") @DefaultValue(value="-1") AccessTimeParam accessTime, final @QueryParam(value="renameoptions") @DefaultValue(value="") RenameOptionSetParam renameOptions, final @QueryParam(value="createparent") @DefaultValue(value="true") CreateParentParam createParent, final @QueryParam(value="token") @DefaultValue(value="") TokenArgumentParam delegationTokenArgument, final @QueryParam(value="aclspec") @DefaultValue(value="") AclPermissionParam aclPermission, final @QueryParam(value="xattr.name") @DefaultValue(value="") XAttrNameParam xattrName, final @QueryParam(value="xattr.value") @DefaultValue(value="") XAttrValueParam xattrValue, final @QueryParam(value="flag") @DefaultValue(value="") XAttrSetFlagParam xattrSetFlag, final @QueryParam(value="snapshotname") @DefaultValue(value="") SnapshotNameParam snapshotName, final @QueryParam(value="oldsnapshotname") @DefaultValue(value="") OldSnapshotNameParam oldSnapshotName, final @QueryParam(value="excludedatanodes") @DefaultValue(value="") ExcludeDatanodesParam excludeDatanodes, final @QueryParam(value="createflag") @DefaultValue(value="") CreateFlagParam createFlagParam, final @QueryParam(value="noredirect") @DefaultValue(value="false") NoRedirectParam noredirect, final @QueryParam(value="storagepolicy") @DefaultValue(value="") StoragePolicyParam policyName) throws IOException, InterruptedException {
        this.init(ugi, delegation, username, doAsUser, path, (HttpOpParam<?>)op, (Param<?, ?>[])new Param[]{destination, owner, group, permission, unmaskedPermission, overwrite, bufferSize, replication, blockSize, modificationTime, accessTime, renameOptions, delegationTokenArgument, aclPermission, xattrName, xattrValue, xattrSetFlag, snapshotName, oldSnapshotName, excludeDatanodes, createFlagParam, noredirect, policyName});
        return this.doAs(ugi, new PrivilegedExceptionAction<Response>(){

            @Override
            public Response run() throws IOException, URISyntaxException {
                return NamenodeWebHdfsMethods.this.put(ugi, delegation, username, doAsUser, path.getAbsolutePath(), op, destination, owner, group, permission, unmaskedPermission, overwrite, bufferSize, replication, blockSize, modificationTime, accessTime, renameOptions, createParent, delegationTokenArgument, aclPermission, xattrName, xattrValue, xattrSetFlag, snapshotName, oldSnapshotName, excludeDatanodes, createFlagParam, noredirect, policyName);
            }
        });
    }

    private Response put(UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, String fullpath, PutOpParam op, DestinationParam destination, OwnerParam owner, GroupParam group, PermissionParam permission, UnmaskedPermissionParam unmaskedPermission, OverwriteParam overwrite, BufferSizeParam bufferSize, ReplicationParam replication, BlockSizeParam blockSize, ModificationTimeParam modificationTime, AccessTimeParam accessTime, RenameOptionSetParam renameOptions, CreateParentParam createParent, TokenArgumentParam delegationTokenArgument, AclPermissionParam aclPermission, XAttrNameParam xattrName, XAttrValueParam xattrValue, XAttrSetFlagParam xattrSetFlag, SnapshotNameParam snapshotName, OldSnapshotNameParam oldSnapshotName, ExcludeDatanodesParam exclDatanodes, CreateFlagParam createFlagParam, NoRedirectParam noredirectParam, StoragePolicyParam policyName) throws IOException, URISyntaxException {
        Configuration conf = (Configuration)this.context.getAttribute("current.conf");
        NameNode namenode = (NameNode)this.context.getAttribute("name.node");
        NamenodeProtocols np = NamenodeWebHdfsMethods.getRPCServer(namenode);
        switch ((PutOpParam.Op)op.getValue()) {
            case CREATE: {
                URI uri = this.redirectURI(namenode, ugi, delegation, username, doAsUser, fullpath, (HttpOpParam.Op)op.getValue(), -1L, blockSize.getValue(conf), (String)exclDatanodes.getValue(), new Param[]{permission, unmaskedPermission, overwrite, bufferSize, replication, blockSize, createParent, createFlagParam});
                if (!((Boolean)noredirectParam.getValue()).booleanValue()) {
                    return Response.temporaryRedirect((URI)uri).type("application/octet-stream").build();
                }
                String js = JsonUtil.toJsonString("Location", (Object)uri);
                return Response.ok((Object)js).type("application/json").build();
            }
            case MKDIRS: {
                FsPermission masked = unmaskedPermission.getValue() == null ? permission.getDirFsPermission() : FsCreateModes.create((FsPermission)permission.getDirFsPermission(), (FsPermission)unmaskedPermission.getDirFsPermission());
                boolean b = np.mkdirs(fullpath, masked, true);
                String js = JsonUtil.toJsonString("boolean", (Object)b);
                return Response.ok((Object)js).type("application/json").build();
            }
            case CREATESYMLINK: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{destination});
                np.createSymlink((String)destination.getValue(), fullpath, PermissionParam.getDefaultSymLinkFsPermission(), (Boolean)createParent.getValue());
                return Response.ok().type("application/octet-stream").build();
            }
            case RENAME: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{destination});
                EnumSet s = (EnumSet)renameOptions.getValue();
                if (s.isEmpty()) {
                    boolean b = np.rename(fullpath, (String)destination.getValue());
                    String js = JsonUtil.toJsonString("boolean", (Object)b);
                    return Response.ok((Object)js).type("application/json").build();
                }
                np.rename2(fullpath, (String)destination.getValue(), s.toArray(new Options.Rename[s.size()]));
                return Response.ok().type("application/octet-stream").build();
            }
            case SETREPLICATION: {
                boolean b = np.setReplication(fullpath, replication.getValue(conf));
                String js = JsonUtil.toJsonString("boolean", (Object)b);
                return Response.ok((Object)js).type("application/json").build();
            }
            case SETOWNER: {
                if (owner.getValue() == null && group.getValue() == null) {
                    throw new IllegalArgumentException("Both owner and group are empty.");
                }
                np.setOwner(fullpath, (String)owner.getValue(), (String)group.getValue());
                return Response.ok().type("application/octet-stream").build();
            }
            case SETPERMISSION: {
                np.setPermission(fullpath, permission.getDirFsPermission());
                return Response.ok().type("application/octet-stream").build();
            }
            case SETTIMES: {
                np.setTimes(fullpath, (Long)modificationTime.getValue(), (Long)accessTime.getValue());
                return Response.ok().type("application/octet-stream").build();
            }
            case RENEWDELEGATIONTOKEN: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{delegationTokenArgument});
                Token token = new Token();
                token.decodeFromUrlString((String)delegationTokenArgument.getValue());
                long expiryTime = np.renewDelegationToken(token);
                String js = JsonUtil.toJsonString("long", (Object)expiryTime);
                return Response.ok((Object)js).type("application/json").build();
            }
            case CANCELDELEGATIONTOKEN: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{delegationTokenArgument});
                Token token = new Token();
                token.decodeFromUrlString((String)delegationTokenArgument.getValue());
                np.cancelDelegationToken(token);
                return Response.ok().type("application/octet-stream").build();
            }
            case MODIFYACLENTRIES: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{aclPermission});
                np.modifyAclEntries(fullpath, aclPermission.getAclPermission(true));
                return Response.ok().type("application/octet-stream").build();
            }
            case REMOVEACLENTRIES: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{aclPermission});
                np.removeAclEntries(fullpath, aclPermission.getAclPermission(false));
                return Response.ok().type("application/octet-stream").build();
            }
            case REMOVEDEFAULTACL: {
                np.removeDefaultAcl(fullpath);
                return Response.ok().type("application/octet-stream").build();
            }
            case REMOVEACL: {
                np.removeAcl(fullpath);
                return Response.ok().type("application/octet-stream").build();
            }
            case SETACL: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{aclPermission});
                np.setAcl(fullpath, aclPermission.getAclPermission(true));
                return Response.ok().type("application/octet-stream").build();
            }
            case SETXATTR: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{xattrName, xattrSetFlag});
                np.setXAttr(fullpath, XAttrHelper.buildXAttr((String)xattrName.getXAttrName(), (byte[])xattrValue.getXAttrValue()), xattrSetFlag.getFlag());
                return Response.ok().type("application/octet-stream").build();
            }
            case REMOVEXATTR: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{xattrName});
                np.removeXAttr(fullpath, XAttrHelper.buildXAttr((String)xattrName.getXAttrName()));
                return Response.ok().type("application/octet-stream").build();
            }
            case ALLOWSNAPSHOT: {
                np.allowSnapshot(fullpath);
                return Response.ok().type("application/octet-stream").build();
            }
            case CREATESNAPSHOT: {
                String snapshotPath = np.createSnapshot(fullpath, (String)snapshotName.getValue());
                String js = JsonUtil.toJsonString(org.apache.hadoop.fs.Path.class.getSimpleName(), (Object)snapshotPath);
                return Response.ok((Object)js).type("application/json").build();
            }
            case RENAMESNAPSHOT: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{oldSnapshotName, snapshotName});
                np.renameSnapshot(fullpath, (String)oldSnapshotName.getValue(), (String)snapshotName.getValue());
                return Response.ok().type("application/octet-stream").build();
            }
            case DISALLOWSNAPSHOT: {
                np.disallowSnapshot(fullpath);
                return Response.ok().type("application/octet-stream").build();
            }
            case SETSTORAGEPOLICY: {
                if (policyName.getValue() == null) {
                    throw new IllegalArgumentException("Storage policy name is empty.");
                }
                np.setStoragePolicy(fullpath, (String)policyName.getValue());
                return Response.ok().type("application/octet-stream").build();
            }
        }
        throw new UnsupportedOperationException(op + " is not supported");
    }

    @POST
    @Path(value="/")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream; charset=utf-8", "application/json; charset=utf-8"})
    public Response postRoot(@Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, @QueryParam(value="op") @DefaultValue(value="null") PostOpParam op, @QueryParam(value="sources") @DefaultValue(value="") ConcatSourcesParam concatSrcs, @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, @QueryParam(value="excludedatanodes") @DefaultValue(value="") ExcludeDatanodesParam excludeDatanodes, @QueryParam(value="newlength") @DefaultValue(value="null") NewLengthParam newLength, @QueryParam(value="noredirect") @DefaultValue(value="false") NoRedirectParam noredirect) throws IOException, InterruptedException {
        return this.post(ugi, delegation, username, doAsUser, ROOT, op, concatSrcs, bufferSize, excludeDatanodes, newLength, noredirect);
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream; charset=utf-8", "application/json; charset=utf-8"})
    public Response post(final @Context UserGroupInformation ugi, final @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, final @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, final @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") PostOpParam op, final @QueryParam(value="sources") @DefaultValue(value="") ConcatSourcesParam concatSrcs, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, final @QueryParam(value="excludedatanodes") @DefaultValue(value="") ExcludeDatanodesParam excludeDatanodes, final @QueryParam(value="newlength") @DefaultValue(value="null") NewLengthParam newLength, final @QueryParam(value="noredirect") @DefaultValue(value="false") NoRedirectParam noredirect) throws IOException, InterruptedException {
        this.init(ugi, delegation, username, doAsUser, path, (HttpOpParam<?>)op, (Param<?, ?>[])new Param[]{concatSrcs, bufferSize, excludeDatanodes, newLength});
        return this.doAs(ugi, new PrivilegedExceptionAction<Response>(){

            @Override
            public Response run() throws IOException, URISyntaxException {
                return NamenodeWebHdfsMethods.this.post(ugi, delegation, username, doAsUser, path.getAbsolutePath(), op, concatSrcs, bufferSize, excludeDatanodes, newLength, noredirect);
            }
        });
    }

    private Response post(UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, String fullpath, PostOpParam op, ConcatSourcesParam concatSrcs, BufferSizeParam bufferSize, ExcludeDatanodesParam excludeDatanodes, NewLengthParam newLength, NoRedirectParam noredirectParam) throws IOException, URISyntaxException {
        NameNode namenode = (NameNode)this.context.getAttribute("name.node");
        NamenodeProtocols np = NamenodeWebHdfsMethods.getRPCServer(namenode);
        switch ((PostOpParam.Op)op.getValue()) {
            case APPEND: {
                URI uri = this.redirectURI(namenode, ugi, delegation, username, doAsUser, fullpath, (HttpOpParam.Op)op.getValue(), -1L, -1L, (String)excludeDatanodes.getValue(), new Param[]{bufferSize});
                if (!((Boolean)noredirectParam.getValue()).booleanValue()) {
                    return Response.temporaryRedirect((URI)uri).type("application/octet-stream").build();
                }
                String js = JsonUtil.toJsonString("Location", (Object)uri);
                return Response.ok((Object)js).type("application/json").build();
            }
            case CONCAT: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{concatSrcs});
                np.concat(fullpath, concatSrcs.getAbsolutePaths());
                return Response.ok().build();
            }
            case TRUNCATE: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{newLength});
                boolean b = np.truncate(fullpath, (Long)newLength.getValue(), "DFSClient_" + DFSUtil.getSecureRandom().nextLong());
                String js = JsonUtil.toJsonString("boolean", (Object)b);
                return Response.ok((Object)js).type("application/json").build();
            }
            case UNSETSTORAGEPOLICY: {
                np.unsetStoragePolicy(fullpath);
                return Response.ok().build();
            }
        }
        throw new UnsupportedOperationException(op + " is not supported");
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/octet-stream; charset=utf-8", "application/json; charset=utf-8"})
    public Response getRoot(@Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, @QueryParam(value="op") @DefaultValue(value="null") GetOpParam op, @QueryParam(value="offset") @DefaultValue(value="0") OffsetParam offset, @QueryParam(value="length") @DefaultValue(value="null") LengthParam length, @QueryParam(value="renewer") @DefaultValue(value="null") RenewerParam renewer, @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, @QueryParam(value="xattr.name") @DefaultValue(value="") List<XAttrNameParam> xattrNames, @QueryParam(value="encoding") @DefaultValue(value="") XAttrEncodingParam xattrEncoding, @QueryParam(value="excludedatanodes") @DefaultValue(value="") ExcludeDatanodesParam excludeDatanodes, @QueryParam(value="fsaction") @DefaultValue(value="null") FsActionParam fsAction, @QueryParam(value="kind") @DefaultValue(value="null") TokenKindParam tokenKind, @QueryParam(value="service") @DefaultValue(value="null") TokenServiceParam tokenService, @QueryParam(value="noredirect") @DefaultValue(value="false") NoRedirectParam noredirect, @QueryParam(value="startafter") @DefaultValue(value="") StartAfterParam startAfter) throws IOException, InterruptedException {
        return this.get(ugi, delegation, username, doAsUser, ROOT, op, offset, length, renewer, bufferSize, xattrNames, xattrEncoding, excludeDatanodes, fsAction, tokenKind, tokenService, noredirect, startAfter);
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/octet-stream; charset=utf-8", "application/json; charset=utf-8"})
    public Response get(final @Context UserGroupInformation ugi, final @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, final @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, final @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") GetOpParam op, final @QueryParam(value="offset") @DefaultValue(value="0") OffsetParam offset, final @QueryParam(value="length") @DefaultValue(value="null") LengthParam length, final @QueryParam(value="renewer") @DefaultValue(value="null") RenewerParam renewer, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, final @QueryParam(value="xattr.name") @DefaultValue(value="") List<XAttrNameParam> xattrNames, final @QueryParam(value="encoding") @DefaultValue(value="") XAttrEncodingParam xattrEncoding, final @QueryParam(value="excludedatanodes") @DefaultValue(value="") ExcludeDatanodesParam excludeDatanodes, final @QueryParam(value="fsaction") @DefaultValue(value="null") FsActionParam fsAction, final @QueryParam(value="kind") @DefaultValue(value="null") TokenKindParam tokenKind, final @QueryParam(value="service") @DefaultValue(value="null") TokenServiceParam tokenService, final @QueryParam(value="noredirect") @DefaultValue(value="false") NoRedirectParam noredirect, final @QueryParam(value="startafter") @DefaultValue(value="") StartAfterParam startAfter) throws IOException, InterruptedException {
        this.init(ugi, delegation, username, doAsUser, path, (HttpOpParam<?>)op, (Param<?, ?>[])new Param[]{offset, length, renewer, bufferSize, xattrEncoding, excludeDatanodes, fsAction, tokenKind, tokenService, startAfter});
        return this.doAs(ugi, new PrivilegedExceptionAction<Response>(){

            @Override
            public Response run() throws IOException, URISyntaxException {
                return NamenodeWebHdfsMethods.this.get(ugi, delegation, username, doAsUser, path.getAbsolutePath(), op, offset, length, renewer, bufferSize, (List<XAttrNameParam>)xattrNames, xattrEncoding, excludeDatanodes, fsAction, tokenKind, tokenService, noredirect, startAfter);
            }
        });
    }

    private Response get(UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, String fullpath, GetOpParam op, OffsetParam offset, LengthParam length, RenewerParam renewer, BufferSizeParam bufferSize, List<XAttrNameParam> xattrNames, XAttrEncodingParam xattrEncoding, ExcludeDatanodesParam excludeDatanodes, FsActionParam fsAction, TokenKindParam tokenKind, TokenServiceParam tokenService, NoRedirectParam noredirectParam, StartAfterParam startAfter) throws IOException, URISyntaxException {
        NameNode namenode = (NameNode)this.context.getAttribute("name.node");
        Configuration conf = (Configuration)this.context.getAttribute("current.conf");
        NamenodeProtocols np = NamenodeWebHdfsMethods.getRPCServer(namenode);
        switch ((GetOpParam.Op)op.getValue()) {
            case OPEN: {
                URI uri = this.redirectURI(namenode, ugi, delegation, username, doAsUser, fullpath, (HttpOpParam.Op)op.getValue(), (Long)offset.getValue(), -1L, (String)excludeDatanodes.getValue(), new Param[]{offset, length, bufferSize});
                if (!((Boolean)noredirectParam.getValue()).booleanValue()) {
                    return Response.temporaryRedirect((URI)uri).type("application/octet-stream").build();
                }
                String js = JsonUtil.toJsonString("Location", (Object)uri);
                return Response.ok((Object)js).type("application/json").build();
            }
            case GETFILEBLOCKLOCATIONS: {
                long offsetValue = (Long)offset.getValue();
                Long lengthValue = (Long)length.getValue();
                FileSystem fs = FileSystem.get((Configuration)(conf != null ? conf : new Configuration()));
                BlockLocation[] locations = fs.getFileBlockLocations(new org.apache.hadoop.fs.Path(fullpath), offsetValue, lengthValue != null ? lengthValue : Long.MAX_VALUE);
                String js = JsonUtil.toJsonString("BlockLocations", JsonUtil.toJsonMap(locations));
                return Response.ok((Object)js).type("application/json").build();
            }
            case GET_BLOCK_LOCATIONS: {
                long offsetValue = (Long)offset.getValue();
                Long lengthValue = (Long)length.getValue();
                LocatedBlocks locatedblocks = np.getBlockLocations(fullpath, offsetValue, lengthValue != null ? lengthValue : Long.MAX_VALUE);
                String js = JsonUtil.toJsonString(locatedblocks);
                return Response.ok((Object)js).type("application/json").build();
            }
            case GETFILESTATUS: {
                HdfsFileStatus status = np.getFileInfo(fullpath);
                if (status == null) {
                    throw new FileNotFoundException("File does not exist: " + fullpath);
                }
                String js = JsonUtil.toJsonString(status, true);
                return Response.ok((Object)js).type("application/json").build();
            }
            case LISTSTATUS: {
                StreamingOutput streaming = NamenodeWebHdfsMethods.getListingStream(np, fullpath);
                return Response.ok((Object)streaming).type("application/json").build();
            }
            case GETCONTENTSUMMARY: {
                ContentSummary contentsummary = np.getContentSummary(fullpath);
                String js = JsonUtil.toJsonString(contentsummary);
                return Response.ok((Object)js).type("application/json").build();
            }
            case GETFILECHECKSUM: {
                URI uri = this.redirectURI(namenode, ugi, delegation, username, doAsUser, fullpath, (HttpOpParam.Op)op.getValue(), -1L, -1L, null, new Param[0]);
                if (!((Boolean)noredirectParam.getValue()).booleanValue()) {
                    return Response.temporaryRedirect((URI)uri).type("application/octet-stream").build();
                }
                String js = JsonUtil.toJsonString("Location", (Object)uri);
                return Response.ok((Object)js).type("application/json").build();
            }
            case GETDELEGATIONTOKEN: {
                if (delegation.getValue() != null) {
                    throw new IllegalArgumentException(delegation.getName() + " parameter is not null.");
                }
                Token<? extends TokenIdentifier> token = this.generateDelegationToken(namenode, ugi, (String)renewer.getValue());
                String setServiceName = (String)tokenService.getValue();
                String setKind = (String)tokenKind.getValue();
                if (setServiceName != null) {
                    token.setService(new Text(setServiceName));
                }
                if (setKind != null) {
                    token.setKind(new Text(setKind));
                }
                String js = JsonUtil.toJsonString(token);
                return Response.ok((Object)js).type("application/json").build();
            }
            case GETHOMEDIRECTORY: {
                String js = JsonUtil.toJsonString("Path", (Object)FileSystem.get((Configuration)(conf != null ? conf : new Configuration())).getHomeDirectory().toUri().getPath());
                return Response.ok((Object)js).type("application/json").build();
            }
            case GETACLSTATUS: {
                AclStatus status = np.getAclStatus(fullpath);
                if (status == null) {
                    throw new FileNotFoundException("File does not exist: " + fullpath);
                }
                String js = JsonUtil.toJsonString(status);
                return Response.ok((Object)js).type("application/json").build();
            }
            case GETXATTRS: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{xattrEncoding});
                ArrayList names = null;
                if (xattrNames != null) {
                    names = Lists.newArrayListWithCapacity((int)xattrNames.size());
                    for (XAttrNameParam xattrName : xattrNames) {
                        if (xattrName.getXAttrName() == null) continue;
                        names.add(xattrName.getXAttrName());
                    }
                }
                List xAttrs = np.getXAttrs(fullpath, names != null && !names.isEmpty() ? XAttrHelper.buildXAttrs((List)names) : null);
                String js = JsonUtil.toJsonString(xAttrs, xattrEncoding.getEncoding());
                return Response.ok((Object)js).type("application/json").build();
            }
            case LISTXATTRS: {
                List xAttrs = np.listXAttrs(fullpath);
                String js = JsonUtil.toJsonString(xAttrs);
                return Response.ok((Object)js).type("application/json").build();
            }
            case CHECKACCESS: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{fsAction});
                np.checkAccess(fullpath, FsAction.getFsAction((String)((String)fsAction.getValue())));
                return Response.ok().build();
            }
            case GETTRASHROOT: {
                String trashPath = NamenodeWebHdfsMethods.getTrashRoot(fullpath, conf);
                String jsonStr = JsonUtil.toJsonString("Path", (Object)trashPath);
                return Response.ok((Object)jsonStr).type("application/json").build();
            }
            case LISTSTATUS_BATCH: {
                byte[] start = HdfsFileStatus.EMPTY_NAME;
                if (startAfter != null && startAfter.getValue() != null) {
                    start = ((String)startAfter.getValue()).getBytes(Charsets.UTF_8);
                }
                DirectoryListing listing = NamenodeWebHdfsMethods.getDirectoryListing(np, fullpath, start);
                String js = JsonUtil.toJsonString(listing);
                return Response.ok((Object)js).type("application/json").build();
            }
            case GETALLSTORAGEPOLICY: {
                BlockStoragePolicy[] storagePolicies = np.getStoragePolicies();
                String js = JsonUtil.toJsonString(storagePolicies);
                return Response.ok((Object)js).type("application/json").build();
            }
            case GETSTORAGEPOLICY: {
                BlockStoragePolicy storagePolicy = np.getStoragePolicy(fullpath);
                String js = JsonUtil.toJsonString(storagePolicy);
                return Response.ok((Object)js).type("application/json").build();
            }
        }
        throw new UnsupportedOperationException(op + " is not supported");
    }

    private static String getTrashRoot(String fullPath, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)(conf != null ? conf : new Configuration()));
        return fs.getTrashRoot(new org.apache.hadoop.fs.Path(fullPath)).toUri().getPath();
    }

    private static DirectoryListing getDirectoryListing(NamenodeProtocols np, String p, byte[] startAfter) throws IOException {
        DirectoryListing listing = np.getListing(p, startAfter, false);
        if (listing == null) {
            throw new FileNotFoundException("File " + p + " does not exist.");
        }
        return listing;
    }

    private static StreamingOutput getListingStream(final NamenodeProtocols np, final String p) throws IOException {
        final DirectoryListing firstDirList = NamenodeWebHdfsMethods.getDirectoryListing(np, p, HdfsFileStatus.EMPTY_NAME);
        final UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        return new StreamingOutput(){

            public void write(OutputStream outstream) throws IOException {
                final PrintWriter out = new PrintWriter(new OutputStreamWriter(outstream, Charsets.UTF_8));
                out.println("{\"" + FileStatus.class.getSimpleName() + "es\":{\"" + FileStatus.class.getSimpleName() + "\":[");
                try {
                    ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            long n = 0L;
                            DirectoryListing dirList = firstDirList;
                            while (true) {
                                for (HdfsFileStatus s : dirList.getPartialListing()) {
                                    if (n++ > 0L) {
                                        out.println(',');
                                    }
                                    out.print(JsonUtil.toJsonString(s, false));
                                }
                                if (!dirList.hasMore()) break;
                                dirList = NamenodeWebHdfsMethods.getDirectoryListing(np, p, dirList.getLastName());
                            }
                            return null;
                        }
                    });
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                out.println();
                out.println("]}}");
                out.flush();
            }
        };
    }

    @DELETE
    @Path(value="/")
    @Produces(value={"application/json; charset=utf-8"})
    public Response deleteRoot(@Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, @QueryParam(value="op") @DefaultValue(value="null") DeleteOpParam op, @QueryParam(value="recursive") @DefaultValue(value="false") RecursiveParam recursive, @QueryParam(value="snapshotname") @DefaultValue(value="") SnapshotNameParam snapshotName) throws IOException, InterruptedException {
        return this.delete(ugi, delegation, username, doAsUser, ROOT, op, recursive, snapshotName);
    }

    @DELETE
    @Path(value="{path:.*}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response delete(final @Context UserGroupInformation ugi, final @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, final @QueryParam(value="user.name") @DefaultValue(value="") UserParam username, final @QueryParam(value="doas") @DefaultValue(value="") DoAsParam doAsUser, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") DeleteOpParam op, final @QueryParam(value="recursive") @DefaultValue(value="false") RecursiveParam recursive, final @QueryParam(value="snapshotname") @DefaultValue(value="") SnapshotNameParam snapshotName) throws IOException, InterruptedException {
        this.init(ugi, delegation, username, doAsUser, path, (HttpOpParam<?>)op, (Param<?, ?>[])new Param[]{recursive, snapshotName});
        return this.doAs(ugi, new PrivilegedExceptionAction<Response>(){

            @Override
            public Response run() throws IOException {
                return NamenodeWebHdfsMethods.this.delete(ugi, delegation, username, doAsUser, path.getAbsolutePath(), op, recursive, snapshotName);
            }
        });
    }

    private Response delete(UserGroupInformation ugi, DelegationParam delegation, UserParam username, DoAsParam doAsUser, String fullpath, DeleteOpParam op, RecursiveParam recursive, SnapshotNameParam snapshotName) throws IOException {
        NameNode namenode = (NameNode)this.context.getAttribute("name.node");
        NamenodeProtocols np = NamenodeWebHdfsMethods.getRPCServer(namenode);
        switch ((DeleteOpParam.Op)op.getValue()) {
            case DELETE: {
                boolean b = np.delete(fullpath, (Boolean)recursive.getValue());
                String js = JsonUtil.toJsonString("boolean", (Object)b);
                return Response.ok((Object)js).type("application/json").build();
            }
            case DELETESNAPSHOT: {
                this.validateOpParams((HttpOpParam<?>)op, new Param[]{snapshotName});
                np.deleteSnapshot(fullpath, (String)snapshotName.getValue());
                return Response.ok().type("application/octet-stream").build();
            }
        }
        throw new UnsupportedOperationException(op + " is not supported");
    }
}

