/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.IllegalECPolicyException;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
public final class ErasureCodingPolicyManager {
    public static Logger LOG = LoggerFactory.getLogger(ErasureCodingPolicyManager.class);
    private static final byte USER_DEFINED_POLICY_START_ID = 64;
    private int maxCellSize = 0x400000;
    private static final byte[] SUITABLE_STORAGE_POLICIES_FOR_EC_STRIPED_MODE = new byte[]{7, 2, 12};
    private Map<String, ErasureCodingPolicy> userPoliciesByName;
    private Map<Byte, ErasureCodingPolicy> userPoliciesByID;
    private Map<String, ErasureCodingPolicy> removedPoliciesByName;
    private Map<String, ErasureCodingPolicy> enabledPoliciesByName;
    private static volatile ErasureCodingPolicyManager instance = null;

    public static ErasureCodingPolicyManager getInstance() {
        if (instance == null) {
            instance = new ErasureCodingPolicyManager();
        }
        return instance;
    }

    private ErasureCodingPolicyManager() {
    }

    public void init(Configuration conf) {
        String[] policyNames = conf.getTrimmedStrings("dfs.namenode.ec.policies.enabled", new String[]{""});
        this.userPoliciesByID = new TreeMap<Byte, ErasureCodingPolicy>();
        this.userPoliciesByName = new TreeMap<String, ErasureCodingPolicy>();
        this.removedPoliciesByName = new TreeMap<String, ErasureCodingPolicy>();
        this.enabledPoliciesByName = new TreeMap<String, ErasureCodingPolicy>();
        for (String policyName : policyNames) {
            if (policyName.trim().isEmpty()) continue;
            ErasureCodingPolicy ecPolicy = SystemErasureCodingPolicies.getByName((String)policyName);
            if (ecPolicy == null && (ecPolicy = this.userPoliciesByName.get(policyName)) == null) {
                String allPolicies = SystemErasureCodingPolicies.getPolicies().stream().map(ErasureCodingPolicy::getName).collect(Collectors.joining(", ")) + ", " + this.userPoliciesByName.values().stream().map(ErasureCodingPolicy::getName).collect(Collectors.joining(", "));
                String msg = String.format("EC policy '%s' specified at %s is not a valid policy. Please choose from list of available policies: [%s]", policyName, "dfs.namenode.ec.policies.enabled", allPolicies);
                throw new IllegalArgumentException(msg);
            }
            this.enabledPoliciesByName.put(ecPolicy.getName(), ecPolicy);
        }
        this.maxCellSize = conf.getInt("dfs.namenode.ec.policies.max.cellsize", 0x400000);
    }

    public ErasureCodingPolicy[] getEnabledPolicies() {
        ErasureCodingPolicy[] results = new ErasureCodingPolicy[this.enabledPoliciesByName.size()];
        return this.enabledPoliciesByName.values().toArray(results);
    }

    public ErasureCodingPolicy getEnabledPolicyByName(String name) {
        return this.enabledPoliciesByName.get(name);
    }

    public static boolean checkStoragePolicySuitableForECStripedMode(byte storagePolicyID) {
        boolean isPolicySuitable = false;
        for (byte suitablePolicy : SUITABLE_STORAGE_POLICIES_FOR_EC_STRIPED_MODE) {
            if (storagePolicyID != suitablePolicy) continue;
            isPolicySuitable = true;
            break;
        }
        return isPolicySuitable;
    }

    public ErasureCodingPolicy[] getPolicies() {
        return (ErasureCodingPolicy[])Stream.concat(SystemErasureCodingPolicies.getPolicies().stream(), this.userPoliciesByName.values().stream()).toArray(ErasureCodingPolicy[]::new);
    }

    public ErasureCodingPolicy getByID(byte id) {
        ErasureCodingPolicy policy = SystemErasureCodingPolicies.getByID((byte)id);
        if (policy == null) {
            return this.userPoliciesByID.get(id);
        }
        return policy;
    }

    public ErasureCodingPolicy getByName(String name) {
        ErasureCodingPolicy policy = SystemErasureCodingPolicies.getByName((String)name);
        if (policy == null) {
            return this.userPoliciesByName.get(name);
        }
        return policy;
    }

    public void clear() {
    }

    public synchronized ErasureCodingPolicy addPolicy(ErasureCodingPolicy policy) throws IllegalECPolicyException {
        if (!CodecUtil.hasCodec((String)policy.getCodecName())) {
            throw new IllegalECPolicyException("Codec name " + policy.getCodecName() + " is not supported");
        }
        if (policy.getCellSize() > this.maxCellSize) {
            throw new IllegalECPolicyException("Cell size " + policy.getCellSize() + " should not exceed maximum " + this.maxCellSize + " byte");
        }
        String assignedNewName = ErasureCodingPolicy.composePolicyName((ECSchema)policy.getSchema(), (int)policy.getCellSize());
        for (ErasureCodingPolicy p : this.getPolicies()) {
            if (p.getName().equals(assignedNewName)) {
                throw new IllegalECPolicyException("The policy name " + assignedNewName + " already exists");
            }
            if (!p.getSchema().equals((Object)policy.getSchema()) || p.getCellSize() != policy.getCellSize()) continue;
            throw new IllegalECPolicyException("A policy with same schema " + policy.getSchema().toString() + " and cell size " + p.getCellSize() + " is already exists");
        }
        policy.setName(assignedNewName);
        policy.setId(this.getNextAvailablePolicyID());
        this.userPoliciesByName.put(policy.getName(), policy);
        this.userPoliciesByID.put(policy.getId(), policy);
        return policy;
    }

    private byte getNextAvailablePolicyID() {
        byte currentId = this.userPoliciesByID.keySet().stream().max(Byte::compareTo).orElse((byte)64);
        return (byte)(currentId + 1);
    }

    public synchronized void removePolicy(String name) {
        if (SystemErasureCodingPolicies.getByName((String)name) != null) {
            throw new IllegalArgumentException("System erasure coding policy " + name + " cannot be removed");
        }
        ErasureCodingPolicy policy = this.userPoliciesByName.get(name);
        if (policy == null) {
            throw new IllegalArgumentException("The policy name " + name + " does not exists");
        }
        this.enabledPoliciesByName.remove(name);
        this.removedPoliciesByName.put(name, policy);
    }

    public List<ErasureCodingPolicy> getRemovedPolicies() {
        return this.removedPoliciesByName.values().stream().collect(Collectors.toList());
    }

    public synchronized void disablePolicy(String name) {
        ErasureCodingPolicy sysEcPolicy = SystemErasureCodingPolicies.getByName((String)name);
        ErasureCodingPolicy userEcPolicy = this.userPoliciesByName.get(name);
        LOG.info("Disable the erasure coding policy " + name);
        if (sysEcPolicy == null && userEcPolicy == null) {
            throw new IllegalArgumentException("The policy name " + name + " does not exists");
        }
        if (sysEcPolicy != null) {
            this.enabledPoliciesByName.remove(name);
            this.removedPoliciesByName.put(name, sysEcPolicy);
        }
        if (userEcPolicy != null) {
            this.enabledPoliciesByName.remove(name);
            this.removedPoliciesByName.put(name, userEcPolicy);
        }
    }

    public synchronized void enablePolicy(String name) {
        ErasureCodingPolicy sysEcPolicy = SystemErasureCodingPolicies.getByName((String)name);
        ErasureCodingPolicy userEcPolicy = this.userPoliciesByName.get(name);
        LOG.info("Enable the erasure coding policy " + name);
        if (sysEcPolicy == null && userEcPolicy == null) {
            throw new IllegalArgumentException("The policy name " + name + " does not exists");
        }
        if (sysEcPolicy != null) {
            this.enabledPoliciesByName.put(name, sysEcPolicy);
            this.removedPoliciesByName.remove(name);
        }
        if (userEcPolicy != null) {
            this.enabledPoliciesByName.put(name, userEcPolicy);
            this.removedPoliciesByName.remove(name);
        }
    }
}

