/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.FSClusterStats;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class BlockPlacementPolicy {
    static final Logger LOG = LoggerFactory.getLogger(BlockPlacementPolicy.class);

    public abstract DatanodeStorageInfo[] chooseTarget(String var1, int var2, Node var3, List<DatanodeStorageInfo> var4, boolean var5, Set<Node> var6, long var7, BlockStoragePolicy var9, EnumSet<AddBlockFlag> var10);

    DatanodeStorageInfo[] chooseTarget(String src, int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, List<DatanodeDescriptor> favoredNodes, BlockStoragePolicy storagePolicy, EnumSet<AddBlockFlag> flags) {
        return this.chooseTarget(src, numOfReplicas, writer, new ArrayList<DatanodeStorageInfo>(numOfReplicas), false, excludedNodes, blocksize, storagePolicy, flags);
    }

    public abstract BlockPlacementStatus verifyBlockPlacement(DatanodeInfo[] var1, int var2);

    public abstract List<DatanodeStorageInfo> chooseReplicasToDelete(Collection<DatanodeStorageInfo> var1, Collection<DatanodeStorageInfo> var2, int var3, List<StorageType> var4, DatanodeDescriptor var5, DatanodeDescriptor var6);

    protected abstract void initialize(Configuration var1, FSClusterStats var2, NetworkTopology var3, Host2NodesMap var4);

    public abstract boolean isMovable(Collection<DatanodeInfo> var1, DatanodeInfo var2, DatanodeInfo var3);

    public void adjustSetsWithChosenReplica(Map<String, List<DatanodeStorageInfo>> rackMap, List<DatanodeStorageInfo> moreThanOne, List<DatanodeStorageInfo> exactlyOne, DatanodeStorageInfo cur) {
        String rack = this.getRack(cur.getDatanodeDescriptor());
        List<DatanodeStorageInfo> storages = rackMap.get(rack);
        storages.remove(cur);
        if (storages.isEmpty()) {
            rackMap.remove(rack);
        }
        if (moreThanOne.remove(cur)) {
            if (storages.size() == 1) {
                DatanodeStorageInfo remaining = storages.get(0);
                moreThanOne.remove(remaining);
                exactlyOne.add(remaining);
            }
        } else {
            exactlyOne.remove(cur);
        }
    }

    protected <T> DatanodeInfo getDatanodeInfo(T datanode) {
        Preconditions.checkArgument((datanode instanceof DatanodeInfo || datanode instanceof DatanodeStorageInfo ? 1 : 0) != 0, (Object)("class " + datanode.getClass().getName() + " not allowed"));
        if (datanode instanceof DatanodeInfo) {
            return (DatanodeInfo)datanode;
        }
        return ((DatanodeStorageInfo)datanode).getDatanodeDescriptor();
    }

    protected String getRack(DatanodeInfo datanode) {
        return datanode.getNetworkLocation();
    }

    public <T> void splitNodesWithRack(Iterable<T> availableSet, Collection<T> candidates, Map<String, List<T>> rackMap, List<T> moreThanOne, List<T> exactlyOne) {
        String rackName;
        for (T s : availableSet) {
            rackName = this.getRack(this.getDatanodeInfo(s));
            List<T> storageList = rackMap.get(rackName);
            if (storageList == null) {
                storageList = new ArrayList<T>();
                rackMap.put(rackName, storageList);
            }
            storageList.add(s);
        }
        for (T candidate : candidates) {
            rackName = this.getRack(this.getDatanodeInfo(candidate));
            if (rackMap.get(rackName).size() == 1) {
                exactlyOne.add(candidate);
                continue;
            }
            moreThanOne.add(candidate);
        }
    }

    @InterfaceAudience.Private
    public static class NotEnoughReplicasException
    extends Exception {
        private static final long serialVersionUID = 1L;

        NotEnoughReplicasException(String msg) {
            super(msg);
        }
    }
}

