/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.erasurecode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class ECCommand
extends Command {
    public static void registerCommands(CommandFactory factory) {
        factory.addClass(SetECPolicyCommand.class, new String[]{"-setPolicy"});
        factory.addClass(GetECPolicyCommand.class, new String[]{"-getPolicy"});
        factory.addClass(UnsetECPolicyCommand.class, new String[]{"-unsetPolicy"});
        factory.addClass(ListPolicies.class, new String[]{"-listPolicies"});
    }

    public String getCommandName() {
        return this.getName();
    }

    protected void run(Path path) throws IOException {
        throw new RuntimeException("Not suppose to get here");
    }

    @Deprecated
    public int runAll() {
        return this.run(this.args);
    }

    protected void processPath(PathData item) throws IOException {
        if (!(item.fs instanceof DistributedFileSystem)) {
            throw new UnsupportedActionException("Erasure commands are only supported for the HDFS paths");
        }
    }

    static class UnsetECPolicyCommand
    extends ECCommand {
        public static final String NAME = "unsetPolicy";
        public static final String USAGE = "<path>";
        public static final String DESCRIPTION = "Unset erasure coding policy from a directory\n";

        UnsetECPolicyCommand() {
        }

        protected void processOptions(LinkedList<String> args) throws IOException {
            if (args.isEmpty()) {
                throw new HadoopIllegalArgumentException("<path> is missing");
            }
            if (args.size() > 1) {
                throw new HadoopIllegalArgumentException("Too many arguments");
            }
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            super.processPath(item);
            DistributedFileSystem dfs = (DistributedFileSystem)item.fs;
            try {
                dfs.unsetErasureCodingPolicy(item.path);
            }
            catch (IOException e) {
                throw new IOException("Unable to unset EC policy from directory " + item.path + ". " + e.getMessage());
            }
        }
    }

    static class ListPolicies
    extends ECCommand {
        public static final String NAME = "listPolicies";
        public static final String USAGE = "";
        public static final String DESCRIPTION = "Get the list of erasure coding policies supported\n";

        ListPolicies() {
        }

        protected void processOptions(LinkedList<String> args) throws IOException {
            if (!args.isEmpty()) {
                throw new HadoopIllegalArgumentException("Too many parameters");
            }
            FileSystem fs = FileSystem.get((Configuration)this.getConf());
            if (!(fs instanceof DistributedFileSystem)) {
                throw new UnsupportedActionException("Erasure commands are only supported for the HDFS");
            }
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            ErasureCodingPolicy[] ecPolicies = dfs.getClient().getErasureCodingPolicies();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < ecPolicies.length) {
                ErasureCodingPolicy ecPolicy = ecPolicies[i];
                sb.append(ecPolicy.getName());
                if (++i >= ecPolicies.length) continue;
                sb.append(", ");
            }
            this.out.println(sb.toString());
        }
    }

    static class GetECPolicyCommand
    extends ECCommand {
        public static final String NAME = "getPolicy";
        public static final String USAGE = "<path>";
        public static final String DESCRIPTION = "Get erasure coding policy information about at specified path\n";

        GetECPolicyCommand() {
        }

        protected void processOptions(LinkedList<String> args) throws IOException {
            if (args.isEmpty()) {
                throw new HadoopIllegalArgumentException("<path> is missing");
            }
            if (args.size() > 1) {
                throw new HadoopIllegalArgumentException("Too many arguments");
            }
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            super.processPath(item);
            DistributedFileSystem dfs = (DistributedFileSystem)item.fs;
            try {
                ErasureCodingPolicy ecPolicy = dfs.getErasureCodingPolicy(item.path);
                if (ecPolicy != null) {
                    this.out.println(ecPolicy.toString());
                } else {
                    this.out.println("Path " + item.path + " is not erasure coded.");
                }
            }
            catch (IOException e) {
                throw new IOException("Unable to get EC policy for the path " + item.path + ". " + e.getMessage());
            }
        }
    }

    static class SetECPolicyCommand
    extends ECCommand {
        public static final String NAME = "setPolicy";
        public static final String USAGE = "[-p <policyName>] <path>";
        public static final String DESCRIPTION = "Set a specified erasure coding policy to a directory\nOptions :\n  -p <policyName> : erasure coding policy name to encode files. If not passed the default policy will be used\n  <path>  : Path to a directory. Under this directory files will be encoded using specified erasure coding policy";
        private String ecPolicyName;
        private ErasureCodingPolicy ecPolicy = null;

        SetECPolicyCommand() {
        }

        protected void processOptions(LinkedList<String> args) throws IOException {
            this.ecPolicyName = StringUtils.popOptionWithArgument((String)"-p", args);
            if (args.isEmpty()) {
                throw new HadoopIllegalArgumentException("<path> is missing");
            }
            if (args.size() > 1) {
                throw new HadoopIllegalArgumentException("Too many arguments");
            }
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            super.processPath(item);
            DistributedFileSystem dfs = (DistributedFileSystem)item.fs;
            try {
                if (this.ecPolicyName != null) {
                    ErasureCodingPolicy[] ecPolicies;
                    for (ErasureCodingPolicy ecPolicy : ecPolicies = dfs.getClient().getErasureCodingPolicies()) {
                        if (!this.ecPolicyName.equals(ecPolicy.getName())) continue;
                        this.ecPolicy = ecPolicy;
                        break;
                    }
                    if (this.ecPolicy == null) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Policy '");
                        sb.append(this.ecPolicyName);
                        sb.append("' does not match any of the supported policies.");
                        sb.append(" Please select any one of ");
                        ArrayList<String> ecPolicyNames = new ArrayList<String>();
                        for (ErasureCodingPolicy ecPolicy : ecPolicies) {
                            ecPolicyNames.add(ecPolicy.getName());
                        }
                        sb.append(ecPolicyNames);
                        throw new HadoopIllegalArgumentException(sb.toString());
                    }
                }
                dfs.setErasureCodingPolicy(item.path, this.ecPolicy);
                this.out.println("EC policy set successfully at " + item.path);
            }
            catch (IOException e) {
                throw new IOException("Unable to set EC policy for the path " + item.path + ". " + e.getMessage());
            }
        }
    }
}

