/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.datanode.web.DatanodeHttpServer;
import org.apache.hadoop.security.http.RestCsrfPreventionFilter;

@InterfaceAudience.Private
final class RestCsrfPreventionFilterHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final Log LOG = DatanodeHttpServer.LOG;
    private final RestCsrfPreventionFilter restCsrfPreventionFilter;

    public RestCsrfPreventionFilterHandler(RestCsrfPreventionFilter restCsrfPreventionFilter) {
        this.restCsrfPreventionFilter = restCsrfPreventionFilter;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        this.restCsrfPreventionFilter.handleHttpInteraction((RestCsrfPreventionFilter.HttpInteraction)new NettyHttpInteraction(ctx, req));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error((Object)("Exception in " + ((Object)((Object)this)).getClass().getSimpleName()), cause);
        RestCsrfPreventionFilterHandler.sendResponseAndClose(ctx, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
    }

    private static void sendResponseAndClose(ChannelHandlerContext ctx, DefaultHttpResponse resp) {
        resp.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ctx.writeAndFlush((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static final class NettyHttpInteraction
    implements RestCsrfPreventionFilter.HttpInteraction {
        private final ChannelHandlerContext ctx;
        private final HttpRequest req;

        public NettyHttpInteraction(ChannelHandlerContext ctx, HttpRequest req) {
            this.ctx = ctx;
            this.req = req;
        }

        public String getHeader(String header) {
            return this.req.headers().get(header);
        }

        public String getMethod() {
            return this.req.method().name();
        }

        public void proceed() {
            ReferenceCountUtil.retain((Object)this.req);
            this.ctx.fireChannelRead((Object)this.req);
        }

        public void sendError(int code, String message) {
            HttpResponseStatus status = new HttpResponseStatus(code, message);
            RestCsrfPreventionFilterHandler.sendResponseAndClose(this.ctx, new DefaultHttpResponse(HttpVersion.HTTP_1_1, status));
        }
    }
}

