/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.web.RestCsrfPreventionFilterHandler;
import org.apache.hadoop.hdfs.server.datanode.web.URLDispatcher;
import org.apache.hadoop.hdfs.server.datanode.web.dtp.DtpHttp2Handler;
import org.apache.hadoop.security.http.RestCsrfPreventionFilter;

@InterfaceAudience.Private
public class PortUnificationServerHandler
extends ByteToMessageDecoder {
    private static final ByteBuf HTTP2_CLIENT_CONNECTION_PREFACE = Http2CodecUtil.connectionPrefaceBuf();
    private static final int MAGIC_HEADER_LENGTH = 3;
    private final InetSocketAddress proxyHost;
    private final Configuration conf;
    private final Configuration confForCreate;
    private final RestCsrfPreventionFilter restCsrfPreventionFilter;

    public PortUnificationServerHandler(InetSocketAddress proxyHost, Configuration conf, Configuration confForCreate, RestCsrfPreventionFilter restCsrfPreventionFilter) {
        this.proxyHost = proxyHost;
        this.conf = conf;
        this.confForCreate = confForCreate;
        this.restCsrfPreventionFilter = restCsrfPreventionFilter;
    }

    private void configureHttp1(ChannelHandlerContext ctx) {
        ctx.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()});
        if (this.restCsrfPreventionFilter != null) {
            ctx.pipeline().addLast(new ChannelHandler[]{new RestCsrfPreventionFilterHandler(this.restCsrfPreventionFilter)});
        }
        ctx.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler(), new URLDispatcher(this.proxyHost, this.conf, this.confForCreate)});
    }

    private void configureHttp2(ChannelHandlerContext ctx) {
        if (this.restCsrfPreventionFilter != null) {
            ctx.pipeline().addLast(new ChannelHandler[]{new RestCsrfPreventionFilterHandler(this.restCsrfPreventionFilter)});
        }
        ctx.pipeline().addLast(new ChannelHandler[]{new DtpHttp2Handler()});
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 3) {
            return;
        }
        if (ByteBufUtil.equals((ByteBuf)in, (int)0, (ByteBuf)HTTP2_CLIENT_CONNECTION_PREFACE, (int)0, (int)3)) {
            this.configureHttp2(ctx);
        } else {
            this.configureHttp1(ctx);
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }
}

