/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsJsonBuilder;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.RollingAverages;

@InterfaceAudience.Private
public class DataNodePeerMetrics {
    static final Log LOG = LogFactory.getLog(DataNodePeerMetrics.class);
    private final RollingAverages sendPacketDownstreamRollingAvgerages;
    private final String name;
    private final boolean peerStatsEnabled;

    public DataNodePeerMetrics(String name, int windowSize, int numWindows, boolean peerStatsEnabled) {
        this.name = name;
        this.peerStatsEnabled = peerStatsEnabled;
        this.sendPacketDownstreamRollingAvgerages = new RollingAverages(windowSize, numWindows);
    }

    public String name() {
        return this.name;
    }

    public static DataNodePeerMetrics create(Configuration conf, String dnName) {
        String name = "DataNodePeerActivity-" + (dnName.isEmpty() ? "UndefinedDataNodeName" + ThreadLocalRandom.current().nextInt() : dnName.replace(':', '-'));
        int windowSize = conf.getInt("dfs.metrics.rolling.average.window.size", 3600);
        int numWindows = conf.getInt("dfs.metrics.rolling.average.window.numbers", 48);
        boolean peerStatsEnabled = conf.getBoolean("dfs.datanode.peer.stats.enabled", false);
        return new DataNodePeerMetrics(name, windowSize, numWindows, peerStatsEnabled);
    }

    public void addSendPacketDownstream(String peerAddr, long elapsedMs) {
        if (this.peerStatsEnabled) {
            this.sendPacketDownstreamRollingAvgerages.add(peerAddr, elapsedMs);
        }
    }

    public String dumpSendPacketDownstreamAvgInfoAsJson() {
        MetricsJsonBuilder builder = new MetricsJsonBuilder(null);
        this.sendPacketDownstreamRollingAvgerages.snapshot((MetricsRecordBuilder)builder, true);
        return builder.toString();
    }

    public void collectThreadLocalStates() {
        this.sendPacketDownstreamRollingAvgerages.collectThreadLocalStates();
    }
}

