/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.net.Node;

abstract class BlockReconstructionWork {
    private final BlockInfo block;
    private final BlockCollection bc;
    private final DatanodeDescriptor[] srcNodes;
    private final List<DatanodeDescriptor> containingNodes;
    private final List<DatanodeStorageInfo> liveReplicaStorages;
    private final int additionalReplRequired;
    private DatanodeStorageInfo[] targets;
    private final int priority;
    private boolean notEnoughRack = false;

    public BlockReconstructionWork(BlockInfo block, BlockCollection bc, DatanodeDescriptor[] srcNodes, List<DatanodeDescriptor> containingNodes, List<DatanodeStorageInfo> liveReplicaStorages, int additionalReplRequired, int priority) {
        this.block = block;
        this.bc = bc;
        this.srcNodes = srcNodes;
        this.containingNodes = containingNodes;
        this.liveReplicaStorages = liveReplicaStorages;
        this.additionalReplRequired = additionalReplRequired;
        this.priority = priority;
        this.targets = null;
    }

    DatanodeStorageInfo[] getTargets() {
        return this.targets;
    }

    void resetTargets() {
        this.targets = null;
    }

    void setTargets(DatanodeStorageInfo[] targets) {
        this.targets = targets;
    }

    List<DatanodeDescriptor> getContainingNodes() {
        return Collections.unmodifiableList(this.containingNodes);
    }

    public int getPriority() {
        return this.priority;
    }

    public BlockInfo getBlock() {
        return this.block;
    }

    public DatanodeDescriptor[] getSrcNodes() {
        return this.srcNodes;
    }

    BlockCollection getBc() {
        return this.bc;
    }

    List<DatanodeStorageInfo> getLiveReplicaStorages() {
        return this.liveReplicaStorages;
    }

    public int getAdditionalReplRequired() {
        return this.additionalReplRequired;
    }

    void setNotEnoughRack() {
        this.notEnoughRack = true;
    }

    boolean hasNotEnoughRack() {
        return this.notEnoughRack;
    }

    abstract void chooseTargets(BlockPlacementPolicy var1, BlockStoragePolicySuite var2, Set<Node> var3);

    abstract void addTaskToDatanode(NumberReplicas var1);
}

