/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DataBlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaAlreadyExistsException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaUnderRecovery;
import org.apache.hadoop.hdfs.server.datanode.ReplicaWaitingToBeRecovered;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaInputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RollingLogs;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetAsyncDiskService;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeList;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RollingLogsImpl;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
class FsDatasetImpl
implements FsDatasetSpi<FsVolumeImpl> {
    static final Log LOG = LogFactory.getLog(FsDatasetImpl.class);
    final DataNode datanode;
    final FsVolumeList volumes;
    final ReplicaMap volumeMap;
    final FsDatasetAsyncDiskService asyncDiskService;
    private final int validVolsRequired;
    private final Object statsLock = new Object();
    private ObjectName mbeanName;

    @Override
    public List<FsVolumeImpl> getVolumes() {
        return this.volumes.volumes;
    }

    @Override
    public synchronized FsVolumeImpl getVolume(ExtendedBlock b) {
        ReplicaInfo r = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
        return r != null ? (FsVolumeImpl)r.getVolume() : null;
    }

    @Override
    public synchronized Block getStoredBlock(String bpid, long blkid) throws IOException {
        File blockfile = this.getFile(bpid, blkid);
        if (blockfile == null) {
            return null;
        }
        File metafile = FsDatasetUtil.findMetaFile(blockfile);
        long gs = FsDatasetUtil.parseGenerationStamp(blockfile, metafile);
        return new Block(blkid, blockfile.length(), gs);
    }

    ReplicaInfo fetchReplicaInfo(String bpid, long blockId) {
        ReplicaInfo r = this.volumeMap.get(bpid, blockId);
        if (r == null) {
            return null;
        }
        switch (r.getState()) {
            case FINALIZED: {
                return new FinalizedReplica((FinalizedReplica)r);
            }
            case RBW: {
                return new ReplicaBeingWritten((ReplicaBeingWritten)r);
            }
            case RWR: {
                return new ReplicaWaitingToBeRecovered((ReplicaWaitingToBeRecovered)r);
            }
            case RUR: {
                return new ReplicaUnderRecovery((ReplicaUnderRecovery)r);
            }
            case TEMPORARY: {
                return new ReplicaInPipeline((ReplicaInPipeline)r);
            }
        }
        return null;
    }

    @Override
    public LengthInputStream getMetaDataInputStream(ExtendedBlock b) throws IOException {
        File meta = FsDatasetUtil.getMetaFile(this.getBlockFile(b), b.getGenerationStamp());
        if (meta == null || !meta.exists()) {
            return null;
        }
        return new LengthInputStream(new FileInputStream(meta), meta.length());
    }

    FsDatasetImpl(DataNode datanode, DataStorage storage, Configuration conf) throws IOException {
        this.datanode = datanode;
        int volFailuresTolerated = conf.getInt("dfs.datanode.failed.volumes.tolerated", 0);
        String[] dataDirs = conf.getTrimmedStrings("dfs.datanode.data.dir");
        int volsConfigured = dataDirs == null ? 0 : dataDirs.length;
        int volsFailed = volsConfigured - storage.getNumStorageDirs();
        this.validVolsRequired = volsConfigured - volFailuresTolerated;
        if (volFailuresTolerated < 0 || volFailuresTolerated >= volsConfigured) {
            throw new DiskChecker.DiskErrorException("Invalid volume failure  config value: " + volFailuresTolerated);
        }
        if (volsFailed > volFailuresTolerated) {
            throw new DiskChecker.DiskErrorException("Too many failed volumes - current valid volumes: " + storage.getNumStorageDirs() + ", volumes configured: " + volsConfigured + ", volumes failed: " + volsFailed + ", volume failures tolerated: " + volFailuresTolerated);
        }
        ArrayList<FsVolumeImpl> volArray = new ArrayList<FsVolumeImpl>(storage.getNumStorageDirs());
        for (int idx = 0; idx < storage.getNumStorageDirs(); ++idx) {
            File dir = storage.getStorageDir(idx).getCurrentDir();
            volArray.add(new FsVolumeImpl(this, storage.getStorageID(), dir, conf));
            LOG.info((Object)("Added volume - " + dir));
        }
        this.volumeMap = new ReplicaMap(this);
        VolumeChoosingPolicy blockChooserImpl = (VolumeChoosingPolicy)ReflectionUtils.newInstance((Class)conf.getClass("dfs.datanode.fsdataset.volume.choosing.policy", RoundRobinVolumeChoosingPolicy.class, VolumeChoosingPolicy.class), (Configuration)conf);
        this.volumes = new FsVolumeList(volArray, volsFailed, blockChooserImpl);
        this.volumes.getVolumeMap(this.volumeMap);
        File[] roots = new File[storage.getNumStorageDirs()];
        for (int idx = 0; idx < storage.getNumStorageDirs(); ++idx) {
            roots[idx] = storage.getStorageDir(idx).getCurrentDir();
        }
        this.asyncDiskService = new FsDatasetAsyncDiskService(datanode, roots);
        this.registerMBean(storage.getStorageID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDfsUsed() throws IOException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.volumes.getDfsUsed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBlockPoolUsed(String bpid) throws IOException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.volumes.getBlockPoolUsed(bpid);
        }
    }

    @Override
    public boolean hasEnoughResource() {
        return this.getVolumes().size() >= this.validVolsRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCapacity() {
        Object object = this.statsLock;
        synchronized (object) {
            return this.volumes.getCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRemaining() throws IOException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.volumes.getRemaining();
        }
    }

    @Override
    public int getNumFailedVolumes() {
        return this.volumes.numberOfFailedVolumes();
    }

    @Override
    public long getLength(ExtendedBlock b) throws IOException {
        return this.getBlockFile(b).length();
    }

    private File getBlockFile(ExtendedBlock b) throws IOException {
        return this.getBlockFile(b.getBlockPoolId(), b.getLocalBlock());
    }

    File getBlockFile(String bpid, Block b) throws IOException {
        File f = this.validateBlockFile(bpid, b);
        if (f == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("b=" + b + ", volumeMap=" + this.volumeMap));
            }
            throw new IOException("Block " + b + " is not valid.");
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getBlockFileNoExistsCheck(ExtendedBlock b) throws IOException {
        File f;
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            f = this.getFile(b.getBlockPoolId(), b.getLocalBlock().getBlockId());
        }
        if (f == null) {
            throw new IOException("Block " + b + " is not valid");
        }
        return f;
    }

    @Override
    public InputStream getBlockInputStream(ExtendedBlock b, long seekOffset) throws IOException {
        RandomAccessFile blockInFile;
        File blockFile = this.getBlockFileNoExistsCheck(b);
        try {
            blockInFile = new RandomAccessFile(blockFile, "r");
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException("Block " + b + " is not valid. " + "Expected block file at " + blockFile + " does not exist.");
        }
        if (seekOffset > 0L) {
            blockInFile.seek(seekOffset);
        }
        return new FileInputStream(blockInFile.getFD());
    }

    ReplicaInfo getReplicaInfo(ExtendedBlock b) throws ReplicaNotFoundException {
        ReplicaInfo info = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
        if (info == null) {
            throw new ReplicaNotFoundException("Cannot append to a non-existent replica " + b);
        }
        return info;
    }

    private ReplicaInfo getReplicaInfo(String bpid, long blkid) throws ReplicaNotFoundException {
        ReplicaInfo info = this.volumeMap.get(bpid, blkid);
        if (info == null) {
            throw new ReplicaNotFoundException("Cannot append to a non-existent replica " + bpid + ":" + blkid);
        }
        return info;
    }

    @Override
    public synchronized ReplicaInputStreams getTmpInputStreams(ExtendedBlock b, long blkOffset, long ckoff) throws IOException {
        ReplicaInfo info = this.getReplicaInfo(b);
        File blockFile = info.getBlockFile();
        RandomAccessFile blockInFile = new RandomAccessFile(blockFile, "r");
        if (blkOffset > 0L) {
            blockInFile.seek(blkOffset);
        }
        File metaFile = info.getMetaFile();
        RandomAccessFile metaInFile = new RandomAccessFile(metaFile, "r");
        if (ckoff > 0L) {
            metaInFile.seek(ckoff);
        }
        return new ReplicaInputStreams(blockInFile.getFD(), metaInFile.getFD());
    }

    static File moveBlockFiles(Block b, File srcfile, File destdir) throws IOException {
        File dstfile = new File(destdir, b.getBlockName());
        File srcmeta = FsDatasetUtil.getMetaFile(srcfile, b.getGenerationStamp());
        File dstmeta = FsDatasetUtil.getMetaFile(dstfile, b.getGenerationStamp());
        try {
            NativeIO.renameTo((File)srcmeta, (File)dstmeta);
        }
        catch (IOException e) {
            throw new IOException("Failed to move meta file for " + b + " from " + srcmeta + " to " + dstmeta, e);
        }
        try {
            NativeIO.renameTo((File)srcfile, (File)dstfile);
        }
        catch (IOException e) {
            throw new IOException("Failed to move block file for " + b + " from " + srcfile + " to " + dstfile.getAbsolutePath(), e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addBlock: Moved " + srcmeta + " to " + dstmeta + " and " + srcfile + " to " + dstfile));
        }
        return dstfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void truncateBlock(File blockFile, File metaFile, long oldlen, long newlen) throws IOException {
        LOG.info((Object)("truncateBlock: blockFile=" + blockFile + ", metaFile=" + metaFile + ", oldlen=" + oldlen + ", newlen=" + newlen));
        if (newlen == oldlen) {
            return;
        }
        if (newlen > oldlen) {
            throw new IOException("Cannot truncate block to from oldlen (=" + oldlen + ") to newlen (=" + newlen + ")");
        }
        DataChecksum dcs = BlockMetadataHeader.readHeader(metaFile).getChecksum();
        int checksumsize = dcs.getChecksumSize();
        int bpc = dcs.getBytesPerChecksum();
        long n = (newlen - 1L) / (long)bpc + 1L;
        long newmetalen = (long)BlockMetadataHeader.getHeaderSize() + n * (long)checksumsize;
        long lastchunkoffset = (n - 1L) * (long)bpc;
        int lastchunksize = (int)(newlen - lastchunkoffset);
        byte[] b = new byte[Math.max(lastchunksize, checksumsize)];
        RandomAccessFile blockRAF = new RandomAccessFile(blockFile, "rw");
        try {
            blockRAF.setLength(newlen);
            blockRAF.seek(lastchunkoffset);
            blockRAF.readFully(b, 0, lastchunksize);
        }
        finally {
            blockRAF.close();
        }
        dcs.update(b, 0, lastchunksize);
        dcs.writeValue(b, 0, false);
        RandomAccessFile metaRAF = new RandomAccessFile(metaFile, "rw");
        try {
            metaRAF.setLength(newmetalen);
            metaRAF.seek(newmetalen - (long)checksumsize);
            metaRAF.write(b, 0, checksumsize);
        }
        finally {
            metaRAF.close();
        }
    }

    @Override
    public synchronized ReplicaInPipeline append(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        if (newGS < b.getGenerationStamp()) {
            throw new IOException("The new generation stamp " + newGS + " should be greater than the replica " + b + "'s generation stamp");
        }
        ReplicaInfo replicaInfo = this.getReplicaInfo(b);
        LOG.info((Object)("Appending to " + replicaInfo));
        if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED) {
            throw new ReplicaNotFoundException("Cannot append to an unfinalized replica " + b);
        }
        if (replicaInfo.getNumBytes() != expectedBlockLen) {
            throw new IOException("Corrupted replica " + replicaInfo + " with a length of " + replicaInfo.getNumBytes() + " expected length is " + expectedBlockLen);
        }
        return this.append(b.getBlockPoolId(), (FinalizedReplica)replicaInfo, newGS, b.getNumBytes());
    }

    private synchronized ReplicaBeingWritten append(String bpid, FinalizedReplica replicaInfo, long newGS, long estimateBlockLen) throws IOException {
        replicaInfo.unlinkBlock(1);
        File blkfile = replicaInfo.getBlockFile();
        FsVolumeImpl v = (FsVolumeImpl)replicaInfo.getVolume();
        if (v.getAvailable() < estimateBlockLen - replicaInfo.getNumBytes()) {
            throw new DiskChecker.DiskOutOfSpaceException("Insufficient space for appending to " + replicaInfo);
        }
        File newBlkFile = new File(v.getRbwDir(bpid), replicaInfo.getBlockName());
        File oldmeta = replicaInfo.getMetaFile();
        ReplicaBeingWritten newReplicaInfo = new ReplicaBeingWritten(replicaInfo.getBlockId(), replicaInfo.getNumBytes(), newGS, v, newBlkFile.getParentFile(), Thread.currentThread());
        File newmeta = newReplicaInfo.getMetaFile();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming " + oldmeta + " to " + newmeta));
        }
        try {
            NativeIO.renameTo((File)oldmeta, (File)newmeta);
        }
        catch (IOException e) {
            throw new IOException("Block " + replicaInfo + " reopen failed. " + " Unable to move meta file  " + oldmeta + " to rbw dir " + newmeta, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming " + blkfile + " to " + newBlkFile + ", file length=" + blkfile.length()));
        }
        try {
            NativeIO.renameTo((File)blkfile, (File)newBlkFile);
        }
        catch (IOException e) {
            try {
                NativeIO.renameTo((File)newmeta, (File)oldmeta);
            }
            catch (IOException ex) {
                LOG.warn((Object)("Cannot move meta file " + newmeta + "back to the finalized directory " + oldmeta), (Throwable)ex);
            }
            throw new IOException("Block " + replicaInfo + " reopen failed. " + " Unable to move block file " + blkfile + " to rbw dir " + newBlkFile, e);
        }
        this.volumeMap.add(bpid, newReplicaInfo);
        return newReplicaInfo;
    }

    private ReplicaInfo recoverCheck(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        ReplicaInfo replicaInfo = this.getReplicaInfo(b.getBlockPoolId(), b.getBlockId());
        if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED && replicaInfo.getState() != HdfsServerConstants.ReplicaState.RBW) {
            throw new ReplicaNotFoundException("Cannot recover append/close to a replica that's not FINALIZED and not RBW " + replicaInfo);
        }
        long replicaGenerationStamp = replicaInfo.getGenerationStamp();
        if (replicaGenerationStamp < b.getGenerationStamp() || replicaGenerationStamp > newGS) {
            throw new ReplicaNotFoundException("Cannot append to a replica with unexpeted generation stamp " + replicaGenerationStamp + ". Expected GS range is [" + b.getGenerationStamp() + ", " + newGS + "].");
        }
        long replicaLen = replicaInfo.getNumBytes();
        if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.RBW) {
            ReplicaBeingWritten rbw = (ReplicaBeingWritten)replicaInfo;
            rbw.stopWriter();
            rbw.setWriter(Thread.currentThread());
            if (replicaLen != rbw.getBytesOnDisk() || replicaLen != rbw.getBytesAcked()) {
                throw new ReplicaAlreadyExistsException("RBW replica " + replicaInfo + "bytesRcvd(" + rbw.getNumBytes() + "), bytesOnDisk(" + rbw.getBytesOnDisk() + "), and bytesAcked(" + rbw.getBytesAcked() + ") are not the same.");
            }
        }
        if (replicaLen != expectedBlockLen) {
            throw new IOException("Corrupted replica " + replicaInfo + " with a length of " + replicaLen + " expected length is " + expectedBlockLen);
        }
        return replicaInfo;
    }

    @Override
    public synchronized ReplicaInPipeline recoverAppend(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        LOG.info((Object)("Recover failed append to " + b));
        ReplicaInfo replicaInfo = this.recoverCheck(b, newGS, expectedBlockLen);
        if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.FINALIZED) {
            return this.append(b.getBlockPoolId(), (FinalizedReplica)replicaInfo, newGS, b.getNumBytes());
        }
        this.bumpReplicaGS(replicaInfo, newGS);
        return (ReplicaBeingWritten)replicaInfo;
    }

    @Override
    public void recoverClose(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        LOG.info((Object)("Recover failed close " + b));
        ReplicaInfo replicaInfo = this.recoverCheck(b, newGS, expectedBlockLen);
        this.bumpReplicaGS(replicaInfo, newGS);
        if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.RBW) {
            this.finalizeReplica(b.getBlockPoolId(), replicaInfo);
        }
    }

    private void bumpReplicaGS(ReplicaInfo replicaInfo, long newGS) throws IOException {
        long oldGS = replicaInfo.getGenerationStamp();
        File oldmeta = replicaInfo.getMetaFile();
        replicaInfo.setGenerationStamp(newGS);
        File newmeta = replicaInfo.getMetaFile();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming " + oldmeta + " to " + newmeta));
        }
        try {
            NativeIO.renameTo((File)oldmeta, (File)newmeta);
        }
        catch (IOException e) {
            replicaInfo.setGenerationStamp(oldGS);
            throw new IOException("Block " + replicaInfo + " reopen failed. " + " Unable to move meta file  " + oldmeta + " to " + newmeta, e);
        }
    }

    @Override
    public synchronized ReplicaInPipeline createRbw(ExtendedBlock b) throws IOException {
        ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockPoolId(), b.getBlockId());
        if (replicaInfo != null) {
            throw new ReplicaAlreadyExistsException("Block " + b + " already exists in state " + (Object)((Object)replicaInfo.getState()) + " and thus cannot be created.");
        }
        FsVolumeImpl v = this.volumes.getNextVolume(b.getNumBytes());
        File f = v.createRbwFile(b.getBlockPoolId(), b.getLocalBlock());
        ReplicaBeingWritten newReplicaInfo = new ReplicaBeingWritten(b.getBlockId(), b.getGenerationStamp(), v, f.getParentFile());
        this.volumeMap.add(b.getBlockPoolId(), newReplicaInfo);
        return newReplicaInfo;
    }

    @Override
    public synchronized ReplicaInPipeline recoverRbw(ExtendedBlock b, long newGS, long minBytesRcvd, long maxBytesRcvd) throws IOException {
        LOG.info((Object)("Recover RBW replica " + b));
        ReplicaInfo replicaInfo = this.getReplicaInfo(b.getBlockPoolId(), b.getBlockId());
        if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.RBW) {
            throw new ReplicaNotFoundException("Cannot recover a non-RBW replica " + replicaInfo);
        }
        ReplicaBeingWritten rbw = (ReplicaBeingWritten)replicaInfo;
        LOG.info((Object)("Recovering " + rbw));
        rbw.stopWriter();
        rbw.setWriter(Thread.currentThread());
        long replicaGenerationStamp = rbw.getGenerationStamp();
        if (replicaGenerationStamp < b.getGenerationStamp() || replicaGenerationStamp > newGS) {
            throw new ReplicaNotFoundException("Cannot append to a replica with unexpeted generation stamp " + b + ". Expected GS range is [" + b.getGenerationStamp() + ", " + newGS + "].");
        }
        if (rbw.getBytesAcked() < minBytesRcvd || rbw.getNumBytes() > maxBytesRcvd) {
            throw new ReplicaNotFoundException("Unmatched length replica " + replicaInfo + ": BytesAcked = " + rbw.getBytesAcked() + " BytesRcvd = " + rbw.getNumBytes() + " are not in the range of [" + minBytesRcvd + ", " + maxBytesRcvd + "].");
        }
        this.bumpReplicaGS(rbw, newGS);
        return rbw;
    }

    @Override
    public synchronized ReplicaInPipeline convertTemporaryToRbw(ExtendedBlock b) throws IOException {
        long blockId = b.getBlockId();
        long expectedGs = b.getGenerationStamp();
        long visible = b.getNumBytes();
        LOG.info((Object)("Convert " + b + " from Temporary to RBW, visible length=" + visible));
        ReplicaInfo r = this.volumeMap.get(b.getBlockPoolId(), blockId);
        if (r == null) {
            throw new ReplicaNotFoundException("Cannot append to a non-existent replica " + b);
        }
        if (r.getState() != HdfsServerConstants.ReplicaState.TEMPORARY) {
            throw new ReplicaAlreadyExistsException("r.getState() != ReplicaState.TEMPORARY, r=" + r);
        }
        ReplicaInPipeline temp = (ReplicaInPipeline)r;
        if (temp.getGenerationStamp() != expectedGs) {
            throw new ReplicaAlreadyExistsException("temp.getGenerationStamp() != expectedGs = " + expectedGs + ", temp=" + temp);
        }
        long numBytes = temp.getNumBytes();
        if (numBytes < visible) {
            throw new IOException(numBytes + " = numBytes < visible = " + visible + ", temp=" + temp);
        }
        FsVolumeImpl v = (FsVolumeImpl)temp.getVolume();
        if (v == null) {
            throw new IOException("r.getVolume() = null, temp=" + temp);
        }
        BlockPoolSlice bpslice = v.getBlockPoolSlice(b.getBlockPoolId());
        File dest = FsDatasetImpl.moveBlockFiles(b.getLocalBlock(), temp.getBlockFile(), bpslice.getRbwDir());
        ReplicaBeingWritten rbw = new ReplicaBeingWritten(blockId, numBytes, expectedGs, v, dest.getParentFile(), Thread.currentThread());
        rbw.setBytesAcked(visible);
        this.volumeMap.add(b.getBlockPoolId(), rbw);
        return rbw;
    }

    @Override
    public synchronized ReplicaInPipeline createTemporary(ExtendedBlock b) throws IOException {
        ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockPoolId(), b.getBlockId());
        if (replicaInfo != null) {
            throw new ReplicaAlreadyExistsException("Block " + b + " already exists in state " + (Object)((Object)replicaInfo.getState()) + " and thus cannot be created.");
        }
        FsVolumeImpl v = this.volumes.getNextVolume(b.getNumBytes());
        File f = v.createTmpFile(b.getBlockPoolId(), b.getLocalBlock());
        ReplicaInPipeline newReplicaInfo = new ReplicaInPipeline(b.getBlockId(), b.getGenerationStamp(), v, f.getParentFile());
        this.volumeMap.add(b.getBlockPoolId(), newReplicaInfo);
        return newReplicaInfo;
    }

    @Override
    public void adjustCrcChannelPosition(ExtendedBlock b, ReplicaOutputStreams streams, int checksumSize) throws IOException {
        FileOutputStream file = (FileOutputStream)streams.getChecksumOut();
        FileChannel channel = file.getChannel();
        long oldPos = channel.position();
        long newPos = oldPos - (long)checksumSize;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Changing meta file offset of block " + b + " from " + oldPos + " to " + newPos));
        }
        channel.position(newPos);
    }

    @Override
    public synchronized void finalizeBlock(ExtendedBlock b) throws IOException {
        if (Thread.interrupted()) {
            throw new IOException("Cannot finalize block from Interrupted Thread");
        }
        ReplicaInfo replicaInfo = this.getReplicaInfo(b);
        if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.FINALIZED) {
            return;
        }
        this.finalizeReplica(b.getBlockPoolId(), replicaInfo);
    }

    private synchronized FinalizedReplica finalizeReplica(String bpid, ReplicaInfo replicaInfo) throws IOException {
        FinalizedReplica newReplicaInfo = null;
        if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.RUR && ((ReplicaUnderRecovery)replicaInfo).getOriginalReplica().getState() == HdfsServerConstants.ReplicaState.FINALIZED) {
            newReplicaInfo = (FinalizedReplica)((ReplicaUnderRecovery)replicaInfo).getOriginalReplica();
        } else {
            FsVolumeImpl v = (FsVolumeImpl)replicaInfo.getVolume();
            File f = replicaInfo.getBlockFile();
            if (v == null) {
                throw new IOException("No volume for temporary file " + f + " for block " + replicaInfo);
            }
            File dest = v.addBlock(bpid, replicaInfo, f);
            newReplicaInfo = new FinalizedReplica(replicaInfo, v, dest.getParentFile());
        }
        this.volumeMap.add(bpid, newReplicaInfo);
        return newReplicaInfo;
    }

    @Override
    public synchronized void unfinalizeBlock(ExtendedBlock b) throws IOException {
        ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
        if (replicaInfo != null && replicaInfo.getState() == HdfsServerConstants.ReplicaState.TEMPORARY) {
            this.volumeMap.remove(b.getBlockPoolId(), b.getLocalBlock());
            if (this.delBlockFromDisk(replicaInfo.getBlockFile(), replicaInfo.getMetaFile(), b.getLocalBlock())) {
                LOG.warn((Object)("Block " + b + " unfinalized and removed. "));
            }
        }
    }

    private boolean delBlockFromDisk(File blockFile, File metaFile, Block b) {
        if (blockFile == null) {
            LOG.warn((Object)("No file exists for block: " + b));
            return true;
        }
        if (!blockFile.delete()) {
            LOG.warn((Object)("Not able to delete the block file: " + blockFile));
            return false;
        }
        if (metaFile != null && !metaFile.delete()) {
            LOG.warn((Object)("Not able to delete the meta block file: " + metaFile));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockListAsLongs getBlockReport(String bpid) {
        int size = this.volumeMap.size(bpid);
        ArrayList<ReplicaInfo> finalized = new ArrayList<ReplicaInfo>(size);
        ArrayList<ReplicaInfo> uc = new ArrayList<ReplicaInfo>();
        if (size == 0) {
            return new BlockListAsLongs(finalized, uc);
        }
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            block9: for (ReplicaInfo b : this.volumeMap.replicas(bpid)) {
                switch (b.getState()) {
                    case FINALIZED: {
                        finalized.add(b);
                        continue block9;
                    }
                    case RBW: 
                    case RWR: {
                        uc.add(b);
                        continue block9;
                    }
                    case RUR: {
                        ReplicaUnderRecovery rur = (ReplicaUnderRecovery)b;
                        uc.add(rur.getOriginalReplica());
                        continue block9;
                    }
                    case TEMPORARY: {
                        continue block9;
                    }
                }
                assert (false) : "Illegal ReplicaInfo state.";
            }
            return new BlockListAsLongs(finalized, uc);
        }
    }

    @Override
    public synchronized List<Block> getFinalizedBlocks(String bpid) {
        ArrayList<Block> finalized = new ArrayList<Block>(this.volumeMap.size(bpid));
        for (ReplicaInfo b : this.volumeMap.replicas(bpid)) {
            if (b.getState() != HdfsServerConstants.ReplicaState.FINALIZED) continue;
            finalized.add(new Block(b));
        }
        return finalized;
    }

    @Override
    public boolean isValidBlock(ExtendedBlock b) {
        return this.isValid(b, HdfsServerConstants.ReplicaState.FINALIZED);
    }

    @Override
    public boolean isValidRbw(ExtendedBlock b) {
        return this.isValid(b, HdfsServerConstants.ReplicaState.RBW);
    }

    private boolean isValid(ExtendedBlock b, HdfsServerConstants.ReplicaState state) {
        ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
        return replicaInfo != null && replicaInfo.getState() == state && replicaInfo.getBlockFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File validateBlockFile(String bpid, Block b) {
        File f;
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            f = this.getFile(bpid, b.getBlockId());
        }
        if (f != null) {
            if (f.exists()) {
                return f;
            }
            this.datanode.checkDiskError();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("b=" + b + ", f=" + f));
        }
        return null;
    }

    static void checkReplicaFiles(ReplicaInfo r) throws IOException {
        File f = r.getBlockFile();
        if (!f.exists()) {
            throw new FileNotFoundException("File " + f + " not found, r=" + r);
        }
        if (r.getBytesOnDisk() != f.length()) {
            throw new IOException("File length mismatched.  The length of " + f + " is " + f.length() + " but r=" + r);
        }
        File metafile = FsDatasetUtil.getMetaFile(f, r.getGenerationStamp());
        if (!metafile.exists()) {
            throw new IOException("Metafile " + metafile + " does not exist, r=" + r);
        }
        if (metafile.length() == 0L) {
            throw new IOException("Metafile " + metafile + " is empty, r=" + r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(String bpid, Block[] invalidBlks) throws IOException {
        boolean error = false;
        for (int i = 0; i < invalidBlks.length; ++i) {
            FsVolumeImpl v;
            File f;
            FsDatasetImpl fsDatasetImpl = this;
            synchronized (fsDatasetImpl) {
                f = this.getFile(bpid, invalidBlks[i].getBlockId());
                ReplicaInfo info = this.volumeMap.get(bpid, invalidBlks[i]);
                if (info == null) {
                    LOG.warn((Object)("Failed to delete replica " + invalidBlks[i] + ": ReplicaInfo not found."));
                    error = true;
                    continue;
                }
                if (info.getGenerationStamp() != invalidBlks[i].getGenerationStamp()) {
                    LOG.warn((Object)("Failed to delete replica " + invalidBlks[i] + ": GenerationStamp not matched, info=" + info));
                    error = true;
                    continue;
                }
                v = (FsVolumeImpl)info.getVolume();
                if (f == null) {
                    LOG.warn((Object)("Failed to delete replica " + invalidBlks[i] + ": File not found, volume=" + v));
                    error = true;
                    continue;
                }
                if (v == null) {
                    LOG.warn((Object)("Failed to delete replica " + invalidBlks[i] + ". No volume for this replica, file=" + f + "."));
                    error = true;
                    continue;
                }
                File parent = f.getParentFile();
                if (parent == null) {
                    LOG.warn((Object)("Failed to delete replica " + invalidBlks[i] + ". Parent not found for file " + f + "."));
                    error = true;
                    continue;
                }
                HdfsServerConstants.ReplicaState replicaState = info.getState();
                if (replicaState == HdfsServerConstants.ReplicaState.FINALIZED || replicaState == HdfsServerConstants.ReplicaState.RUR && ((ReplicaUnderRecovery)info).getOriginalReplica().getState() == HdfsServerConstants.ReplicaState.FINALIZED) {
                    v.clearPath(bpid, parent);
                }
                this.volumeMap.remove(bpid, invalidBlks[i]);
            }
            this.asyncDiskService.deleteAsync(v, f, FsDatasetUtil.getMetaFile(f, invalidBlks[i].getGenerationStamp()), new ExtendedBlock(bpid, invalidBlks[i]));
        }
        if (error) {
            throw new IOException("Error in deleting blocks.");
        }
    }

    @Override
    public synchronized boolean contains(ExtendedBlock block) {
        long blockId = block.getLocalBlock().getBlockId();
        return this.getFile(block.getBlockPoolId(), blockId) != null;
    }

    File getFile(String bpid, long blockId) {
        ReplicaInfo info = this.volumeMap.get(bpid, blockId);
        if (info != null) {
            return info.getBlockFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkDataDir() throws DiskChecker.DiskErrorException {
        long totalBlocks = 0L;
        long removedBlocks = 0L;
        List<FsVolumeImpl> failedVols = this.volumes.checkDirs();
        if (failedVols == null) {
            return;
        }
        long mlsec = Time.now();
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            for (FsVolumeImpl fv : failedVols) {
                for (String bpid : fv.getBlockPoolList()) {
                    Iterator<ReplicaInfo> ib = this.volumeMap.replicas(bpid).iterator();
                    while (ib.hasNext()) {
                        ReplicaInfo b = ib.next();
                        ++totalBlocks;
                        if (b.getVolume() != fv) continue;
                        LOG.warn((Object)("Removing replica " + bpid + ":" + b.getBlockId() + " on failed volume " + fv.getCurrentDir().getAbsolutePath()));
                        ib.remove();
                        ++removedBlocks;
                    }
                }
            }
        }
        mlsec = Time.now() - mlsec;
        LOG.warn((Object)("Removed " + removedBlocks + " out of " + totalBlocks + "(took " + mlsec + " millisecs)"));
        StringBuilder sb = new StringBuilder();
        for (FsVolumeImpl fv : failedVols) {
            sb.append(fv.getCurrentDir().getAbsolutePath() + ";");
        }
        throw new DiskChecker.DiskErrorException("DataNode failed volumes:" + sb);
    }

    public String toString() {
        return "FSDataset{dirpath='" + this.volumes + "'}";
    }

    void registerMBean(String storageId) {
        String storageName = storageId == null || storageId.equals("") ? "UndefinedStorageId" + DFSUtil.getRandom().nextInt() : storageId;
        try {
            StandardMBean bean = new StandardMBean(this, FSDatasetMBean.class);
            this.mbeanName = MBeans.register((String)"DataNode", (String)("FSDatasetState-" + storageName), (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            LOG.warn((Object)"Error registering FSDatasetState MBean", (Throwable)e);
        }
        LOG.info((Object)"Registered FSDatasetState MBean");
    }

    @Override
    public void shutdown() {
        if (this.mbeanName != null) {
            MBeans.unregister((ObjectName)this.mbeanName);
        }
        if (this.asyncDiskService != null) {
            this.asyncDiskService.shutdown();
        }
        if (this.volumes != null) {
            this.volumes.shutdown();
        }
    }

    @Override
    public String getStorageInfo() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkAndUpdate(String bpid, long blockId, File diskFile, File diskMetaFile, FsVolumeSpi vol) {
        Block corruptBlock = null;
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            long diskGS;
            ReplicaInfo memBlockInfo = this.volumeMap.get(bpid, blockId);
            if (memBlockInfo != null && memBlockInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED) {
                return;
            }
            long l = diskGS = diskMetaFile != null && diskMetaFile.exists() ? Block.getGenerationStamp(diskMetaFile.getName()) : 0L;
            if (diskFile == null || !diskFile.exists()) {
                if (memBlockInfo == null) {
                    if (diskMetaFile != null && diskMetaFile.exists() && diskMetaFile.delete()) {
                        LOG.warn((Object)("Deleted a metadata file without a block " + diskMetaFile.getAbsolutePath()));
                    }
                    return;
                }
                if (!memBlockInfo.getBlockFile().exists()) {
                    this.volumeMap.remove(bpid, blockId);
                    DataBlockScanner blockScanner = this.datanode.getBlockScanner();
                    if (blockScanner != null) {
                        blockScanner.deleteBlock(bpid, new Block(blockId));
                    }
                    LOG.warn((Object)("Removed block " + blockId + " from memory with missing block file on the disk"));
                    if (diskMetaFile != null && diskMetaFile.exists() && diskMetaFile.delete()) {
                        LOG.warn((Object)("Deleted a metadata file for the deleted block " + diskMetaFile.getAbsolutePath()));
                    }
                }
                return;
            }
            if (memBlockInfo == null) {
                FinalizedReplica diskBlockInfo = new FinalizedReplica(blockId, diskFile.length(), diskGS, vol, diskFile.getParentFile());
                this.volumeMap.add(bpid, diskBlockInfo);
                DataBlockScanner blockScanner = this.datanode.getBlockScanner();
                if (blockScanner != null) {
                    blockScanner.addBlock(new ExtendedBlock(bpid, diskBlockInfo));
                }
                LOG.warn((Object)("Added missing block to memory " + diskBlockInfo));
                return;
            }
            File memFile = memBlockInfo.getBlockFile();
            if (memFile.exists()) {
                if (memFile.compareTo(diskFile) != 0) {
                    LOG.warn((Object)("Block file " + memFile.getAbsolutePath() + " does not match file found by scan " + diskFile.getAbsolutePath()));
                }
            } else {
                LOG.warn((Object)("Block file in volumeMap " + memFile.getAbsolutePath() + " does not exist. Updating it to the file found during scan " + diskFile.getAbsolutePath()));
                memBlockInfo.setDir(diskFile.getParentFile());
                memFile = diskFile;
                LOG.warn((Object)("Updating generation stamp for block " + blockId + " from " + memBlockInfo.getGenerationStamp() + " to " + diskGS));
                memBlockInfo.setGenerationStamp(diskGS);
            }
            if (memBlockInfo.getGenerationStamp() != diskGS) {
                File memMetaFile = FsDatasetUtil.getMetaFile(diskFile, memBlockInfo.getGenerationStamp());
                if (memMetaFile.exists()) {
                    if (memMetaFile.compareTo(diskMetaFile) != 0) {
                        LOG.warn((Object)("Metadata file in memory " + memMetaFile.getAbsolutePath() + " does not match file found by scan " + (diskMetaFile == null ? null : diskMetaFile.getAbsolutePath())));
                    }
                } else {
                    long gs = diskMetaFile != null && diskMetaFile.exists() && diskMetaFile.getParent().equals(memFile.getParent()) ? diskGS : 0L;
                    LOG.warn((Object)("Updating generation stamp for block " + blockId + " from " + memBlockInfo.getGenerationStamp() + " to " + gs));
                    memBlockInfo.setGenerationStamp(gs);
                }
            }
            if (memBlockInfo.getNumBytes() != memFile.length()) {
                corruptBlock = new Block(memBlockInfo);
                LOG.warn((Object)("Updating size of block " + blockId + " from " + memBlockInfo.getNumBytes() + " to " + memFile.length()));
                memBlockInfo.setNumBytes(memFile.length());
            }
        }
        if (corruptBlock != null) {
            LOG.warn((Object)("Reporting the block " + corruptBlock + " as corrupt due to length mismatch"));
            try {
                this.datanode.reportBadBlocks(new ExtendedBlock(bpid, corruptBlock));
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to repot bad block " + corruptBlock), (Throwable)e);
            }
        }
    }

    @Override
    @Deprecated
    public ReplicaInfo getReplica(String bpid, long blockId) {
        return this.volumeMap.get(bpid, blockId);
    }

    @Override
    public synchronized String getReplicaString(String bpid, long blockId) {
        ReplicaInfo r = this.volumeMap.get(bpid, blockId);
        return r == null ? "null" : ((Object)r).toString();
    }

    @Override
    public synchronized ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        return FsDatasetImpl.initReplicaRecovery(rBlock.getBlock().getBlockPoolId(), this.volumeMap, rBlock.getBlock().getLocalBlock(), rBlock.getNewGenerationStamp());
    }

    static ReplicaRecoveryInfo initReplicaRecovery(String bpid, ReplicaMap map, Block block, long recoveryId) throws IOException {
        ReplicaUnderRecovery rur;
        ReplicaInfo replica = map.get(bpid, block.getBlockId());
        LOG.info((Object)("initReplicaRecovery: " + block + ", recoveryId=" + recoveryId + ", replica=" + replica));
        if (replica == null) {
            return null;
        }
        if (replica instanceof ReplicaInPipeline) {
            ReplicaInPipeline rip = (ReplicaInPipeline)replica;
            rip.stopWriter();
            if (rip.getBytesOnDisk() < rip.getVisibleLength()) {
                throw new IOException("THIS IS NOT SUPPOSED TO HAPPEN: getBytesOnDisk() < getVisibleLength(), rip=" + rip);
            }
            FsDatasetImpl.checkReplicaFiles(rip);
        }
        if (replica.getGenerationStamp() < block.getGenerationStamp()) {
            throw new IOException("replica.getGenerationStamp() < block.getGenerationStamp(), block=" + block + ", replica=" + replica);
        }
        if (replica.getGenerationStamp() >= recoveryId) {
            throw new IOException("THIS IS NOT SUPPOSED TO HAPPEN: replica.getGenerationStamp() >= recoveryId = " + recoveryId + ", block=" + block + ", replica=" + replica);
        }
        if (replica.getState() == HdfsServerConstants.ReplicaState.RUR) {
            rur = (ReplicaUnderRecovery)replica;
            if (rur.getRecoveryID() >= recoveryId) {
                throw new RecoveryInProgressException("rur.getRecoveryID() >= recoveryId = " + recoveryId + ", block=" + block + ", rur=" + rur);
            }
            long oldRecoveryID = rur.getRecoveryID();
            rur.setRecoveryID(recoveryId);
            LOG.info((Object)("initReplicaRecovery: update recovery id for " + block + " from " + oldRecoveryID + " to " + recoveryId));
        } else {
            rur = new ReplicaUnderRecovery(replica, recoveryId);
            map.add(bpid, rur);
            LOG.info((Object)("initReplicaRecovery: changing replica state for " + block + " from " + (Object)((Object)replica.getState()) + " to " + (Object)((Object)rur.getState())));
        }
        return rur.createInfo();
    }

    @Override
    public synchronized String updateReplicaUnderRecovery(ExtendedBlock oldBlock, long recoveryId, long newlength) throws IOException {
        String bpid = oldBlock.getBlockPoolId();
        ReplicaInfo replica = this.volumeMap.get(bpid, oldBlock.getBlockId());
        LOG.info((Object)("updateReplica: " + oldBlock + ", recoveryId=" + recoveryId + ", length=" + newlength + ", replica=" + replica));
        if (replica == null) {
            throw new ReplicaNotFoundException(oldBlock);
        }
        if (replica.getState() != HdfsServerConstants.ReplicaState.RUR) {
            throw new IOException("replica.getState() != " + (Object)((Object)HdfsServerConstants.ReplicaState.RUR) + ", replica=" + replica);
        }
        if (replica.getBytesOnDisk() != oldBlock.getNumBytes()) {
            throw new IOException("THIS IS NOT SUPPOSED TO HAPPEN: replica.getBytesOnDisk() != block.getNumBytes(), block=" + oldBlock + ", replica=" + replica);
        }
        FsDatasetImpl.checkReplicaFiles(replica);
        FinalizedReplica finalized = this.updateReplicaUnderRecovery(oldBlock.getBlockPoolId(), (ReplicaUnderRecovery)replica, recoveryId, newlength);
        assert (finalized.getBlockId() == oldBlock.getBlockId() && finalized.getGenerationStamp() == recoveryId && finalized.getNumBytes() == newlength) : "Replica information mismatched: oldBlock=" + oldBlock + ", recoveryId=" + recoveryId + ", newlength=" + newlength + ", finalized=" + finalized;
        FsDatasetImpl.checkReplicaFiles(finalized);
        return this.getVolume(new ExtendedBlock(bpid, finalized)).getStorageID();
    }

    private FinalizedReplica updateReplicaUnderRecovery(String bpid, ReplicaUnderRecovery rur, long recoveryId, long newlength) throws IOException {
        if (rur.getRecoveryID() != recoveryId) {
            throw new IOException("rur.getRecoveryID() != recoveryId = " + recoveryId + ", rur=" + rur);
        }
        this.bumpReplicaGS(rur, recoveryId);
        File replicafile = rur.getBlockFile();
        if (rur.getNumBytes() < newlength) {
            throw new IOException("rur.getNumBytes() < newlength = " + newlength + ", rur=" + rur);
        }
        if (rur.getNumBytes() > newlength) {
            rur.unlinkBlock(1);
            FsDatasetImpl.truncateBlock(replicafile, rur.getMetaFile(), rur.getNumBytes(), newlength);
            rur.setNumBytes(newlength);
        }
        return this.finalizeReplica(bpid, rur);
    }

    @Override
    public synchronized long getReplicaVisibleLength(ExtendedBlock block) throws IOException {
        ReplicaInfo replica = this.getReplicaInfo(block.getBlockPoolId(), block.getBlockId());
        if (replica.getGenerationStamp() < block.getGenerationStamp()) {
            throw new IOException("replica.getGenerationStamp() < block.getGenerationStamp(), block=" + block + ", replica=" + replica);
        }
        return replica.getVisibleLength();
    }

    @Override
    public synchronized void addBlockPool(String bpid, Configuration conf) throws IOException {
        LOG.info((Object)("Adding block pool " + bpid));
        this.volumes.addBlockPool(bpid, conf);
        this.volumeMap.initBlockPool(bpid);
        this.volumes.getVolumeMap(bpid, this.volumeMap);
    }

    @Override
    public synchronized void shutdownBlockPool(String bpid) {
        LOG.info((Object)("Removing block pool " + bpid));
        this.volumeMap.cleanUpBlockPool(bpid);
        this.volumes.removeBlockPool(bpid);
    }

    @Override
    public String[] getBlockPoolList() {
        return this.volumeMap.getBlockPoolList();
    }

    private Collection<VolumeInfo> getVolumeInfo() {
        ArrayList<VolumeInfo> info = new ArrayList<VolumeInfo>();
        for (FsVolumeImpl volume : this.volumes.volumes) {
            long used = 0L;
            long free = 0L;
            try {
                used = volume.getDfsUsed();
                free = volume.getAvailable();
            }
            catch (IOException e) {
                LOG.warn((Object)e.getMessage());
                used = 0L;
                free = 0L;
            }
            info.add(new VolumeInfo(volume, used, free));
        }
        return info;
    }

    @Override
    public Map<String, Object> getVolumeInfoMap() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        Collection<VolumeInfo> volumes = this.getVolumeInfo();
        for (VolumeInfo v : volumes) {
            HashMap<String, Long> innerInfo = new HashMap<String, Long>();
            innerInfo.put("usedSpace", v.usedSpace);
            innerInfo.put("freeSpace", v.freeSpace);
            innerInfo.put("reservedSpace", v.reservedSpace);
            info.put(v.directory, innerInfo);
        }
        return info;
    }

    @Override
    public synchronized void deleteBlockPool(String bpid, boolean force) throws IOException {
        if (!force) {
            for (FsVolumeImpl volume : this.volumes.volumes) {
                if (volume.isBPDirEmpty(bpid)) continue;
                LOG.warn((Object)(bpid + " has some block files, cannot delete unless forced"));
                throw new IOException("Cannot delete block pool, it contains some block files");
            }
        }
        for (FsVolumeImpl volume : this.volumes.volumes) {
            volume.deleteBPDirectories(bpid, force);
        }
    }

    @Override
    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock block) throws IOException {
        File datafile = this.getBlockFile(block);
        File metafile = FsDatasetUtil.getMetaFile(datafile, block.getGenerationStamp());
        BlockLocalPathInfo info = new BlockLocalPathInfo(block, datafile.getAbsolutePath(), metafile.getAbsolutePath());
        return info;
    }

    @Override
    public HdfsBlocksMetadata getHdfsBlocksMetadata(List<ExtendedBlock> blocks) throws IOException {
        int i;
        ArrayList<byte[]> blocksVolumeIds = new ArrayList<byte[]>(this.volumes.volumes.size());
        ArrayList<Integer> blocksVolumeIndexes = new ArrayList<Integer>(blocks.size());
        for (i = 0; i < this.volumes.volumes.size(); ++i) {
            blocksVolumeIds.add(ByteBuffer.allocate(4).putInt(i).array());
        }
        for (i = 0; i < blocks.size(); ++i) {
            ExtendedBlock block = blocks.get(i);
            FsVolumeSpi blockVolume = this.getReplicaInfo(block).getVolume();
            boolean isValid = false;
            int volumeIndex = 0;
            for (FsVolumeImpl volume : this.volumes.volumes) {
                if (blockVolume == volume) {
                    isValid = true;
                    break;
                }
                ++volumeIndex;
            }
            if (!isValid) {
                volumeIndex = Integer.MAX_VALUE;
            }
            blocksVolumeIndexes.add(volumeIndex);
        }
        return new HdfsBlocksMetadata(blocks.toArray(new ExtendedBlock[0]), blocksVolumeIds, blocksVolumeIndexes);
    }

    @Override
    public RollingLogs createRollingLogs(String bpid, String prefix) throws IOException {
        String dir = null;
        List<FsVolumeImpl> volumes = this.getVolumes();
        for (FsVolumeImpl vol : volumes) {
            String bpDir = vol.getPath(bpid);
            if (!RollingLogsImpl.isFilePresent(bpDir, prefix)) continue;
            dir = bpDir;
            break;
        }
        if (dir == null) {
            dir = volumes.get(0).getPath(bpid);
        }
        return new RollingLogsImpl(dir, prefix);
    }

    private static class VolumeInfo {
        final String directory;
        final long usedSpace;
        final long freeSpace;
        final long reservedSpace;

        VolumeInfo(FsVolumeImpl v, long usedSpace, long freeSpace) {
            this.directory = v.toString();
            this.usedSpace = usedSpace;
            this.freeSpace = freeSpace;
            this.reservedSpace = v.getReserved();
        }
    }
}

