/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class XMLUtils {
    public static void addSaxString(ContentHandler contentHandler, String tag, String val) throws SAXException {
        contentHandler.startElement("", "", tag, new AttributesImpl());
        char[] c = val.toString().toCharArray();
        contentHandler.characters(c, 0, c.length);
        contentHandler.endElement("", "", tag);
    }

    public static class Stanza {
        private TreeMap<String, LinkedList<Stanza>> subtrees = new TreeMap();
        private String value = "";

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean hasChildren(String name) {
            return this.subtrees.containsKey(name);
        }

        public List<Stanza> getChildren(String name) throws InvalidXmlException {
            LinkedList<Stanza> children = this.subtrees.get(name);
            if (children == null) {
                throw new InvalidXmlException("no entry found for " + name);
            }
            return children;
        }

        public String getValue(String name) throws InvalidXmlException {
            if (!this.subtrees.containsKey(name)) {
                throw new InvalidXmlException("no entry found for " + name);
            }
            LinkedList<Stanza> l = this.subtrees.get(name);
            if (l.size() != 1) {
                throw new InvalidXmlException("More than one value found for " + name);
            }
            return l.get(0).getValue();
        }

        public void addChild(String name, Stanza child) {
            LinkedList<Object> l;
            if (this.subtrees.containsKey(name)) {
                l = this.subtrees.get(name);
            } else {
                l = new LinkedList();
                this.subtrees.put(name, l);
            }
            l.add(child);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("{");
            if (!this.value.equals("")) {
                bld.append("\"").append(this.value).append("\"");
            }
            String prefix = "";
            for (Map.Entry<String, LinkedList<Stanza>> entry : this.subtrees.entrySet()) {
                String key = entry.getKey();
                LinkedList<Stanza> ll = entry.getValue();
                for (Stanza child : ll) {
                    bld.append(prefix);
                    bld.append("<").append(key).append(">");
                    bld.append(child.toString());
                    prefix = ", ";
                }
            }
            bld.append("}");
            return bld.toString();
        }
    }

    public static class InvalidXmlException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidXmlException(String s) {
            super(s);
        }
    }
}

