/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditsDoubleBuffer;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class EditLogFileOutputStream
extends EditLogOutputStream {
    private static Log LOG = LogFactory.getLog(EditLogFileOutputStream.class);
    public static final int PREALLOCATION_LENGTH = 0x100000;
    private File file;
    private FileOutputStream fp;
    private FileChannel fc;
    private EditsDoubleBuffer doubleBuf;
    static ByteBuffer fill = ByteBuffer.allocateDirect(0x100000);
    private static boolean shouldSkipFsyncForTests = false;

    public EditLogFileOutputStream(File name, int size) throws IOException {
        this.file = name;
        this.doubleBuf = new EditsDoubleBuffer(size);
        RandomAccessFile rp = new RandomAccessFile(name, "rw");
        this.fp = new FileOutputStream(rp.getFD());
        this.fc = rp.getChannel();
        this.fc.position(this.fc.size());
    }

    @Override
    public void write(FSEditLogOp op) throws IOException {
        this.doubleBuf.writeOp(op);
    }

    @Override
    public void writeRaw(byte[] bytes, int offset, int length) throws IOException {
        this.doubleBuf.writeRaw(bytes, offset, length);
    }

    @Override
    public void create() throws IOException {
        this.fc.truncate(0L);
        this.fc.position(0L);
        EditLogFileOutputStream.writeHeader((DataOutputStream)this.doubleBuf.getCurrentBuf());
        this.setReadyToFlush();
        this.flush();
    }

    @VisibleForTesting
    public static void writeHeader(DataOutputStream out) throws IOException {
        out.writeInt(HdfsConstants.LAYOUT_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.fp == null) {
            throw new IOException("Trying to use aborted output stream");
        }
        try {
            if (this.doubleBuf != null) {
                this.doubleBuf.close();
                this.doubleBuf = null;
            }
            if (this.fc != null && this.fc.isOpen()) {
                this.fc.truncate(this.fc.position());
                this.fc.close();
                this.fc = null;
            }
            if (this.fp != null) {
                this.fp.close();
                this.fp = null;
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)FSNamesystem.LOG, (Closeable[])new Closeable[]{this.fc, this.fp});
            this.doubleBuf = null;
            this.fc = null;
            this.fp = null;
            throw throwable;
        }
        IOUtils.cleanup((Log)FSNamesystem.LOG, (Closeable[])new Closeable[]{this.fc, this.fp});
        this.doubleBuf = null;
        this.fc = null;
        this.fp = null;
        this.fp = null;
    }

    @Override
    public void abort() throws IOException {
        if (this.fp == null) {
            return;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.fp});
        this.fp = null;
    }

    @Override
    public void setReadyToFlush() throws IOException {
        this.doubleBuf.getCurrentBuf().write((int)FSEditLogOpCodes.OP_INVALID.getOpCode());
        this.doubleBuf.setReadyToFlush();
    }

    @Override
    public void flushAndSync() throws IOException {
        if (this.fp == null) {
            throw new IOException("Trying to use aborted output stream");
        }
        if (this.doubleBuf.isFlushed()) {
            LOG.info((Object)"Nothing to flush");
            return;
        }
        this.doubleBuf.flushTo(this.fp);
        if (!shouldSkipFsyncForTests) {
            this.fc.force(false);
        }
        this.fc.position(this.fc.position() - 1L);
        this.preallocate();
    }

    @Override
    public boolean shouldForceSync() {
        return this.doubleBuf.shouldForceSync();
    }

    private void preallocate() throws IOException {
        long position = this.fc.position();
        if (position + 4096L >= this.fc.size()) {
            if (FSNamesystem.LOG.isDebugEnabled()) {
                FSNamesystem.LOG.debug((Object)("Preallocating Edit log, current size " + this.fc.size()));
            }
            fill.position(0);
            IOUtils.writeFully((FileChannel)this.fc, (ByteBuffer)fill, (long)position);
            if (FSNamesystem.LOG.isDebugEnabled()) {
                FSNamesystem.LOG.debug((Object)("Edit log size is now " + this.fc.size() + " written " + fill.capacity() + " bytes " + " at offset " + position));
            }
        }
    }

    File getFile() {
        return this.file;
    }

    public String toString() {
        return "EditLogFileOutputStream(" + this.file + ")";
    }

    public boolean isOpen() {
        return this.fp != null;
    }

    @VisibleForTesting
    public void setFileChannelForTesting(FileChannel fc) {
        this.fc = fc;
    }

    @VisibleForTesting
    public FileChannel getFileChannelForTesting() {
        return this.fc;
    }

    @VisibleForTesting
    public static void setShouldSkipFsyncForTesting(boolean skip) {
        shouldSkipFsyncForTests = skip;
    }

    static {
        fill.position(0);
        for (int i = 0; i < fill.capacity(); ++i) {
            fill.put(FSEditLogOpCodes.OP_INVALID.getOpCode());
        }
    }
}

