/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.JournalProtocolProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.protocol.BalancerBandwidthCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.CheckpointCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.JournalInfo;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;

public class PBHelper {
    private static final DatanodeProtocolProtos.RegisterCommandProto REG_CMD_PROTO = DatanodeProtocolProtos.RegisterCommandProto.newBuilder().build();
    private static final RegisterCommand REG_CMD = new RegisterCommand();

    private PBHelper() {
    }

    public static ByteString getByteString(byte[] bytes) {
        return ByteString.copyFrom((byte[])bytes);
    }

    public static HdfsServerConstants.NamenodeRole convert(HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto role) {
        switch (role) {
            case NAMENODE: {
                return HdfsServerConstants.NamenodeRole.NAMENODE;
            }
            case BACKUP: {
                return HdfsServerConstants.NamenodeRole.BACKUP;
            }
            case CHECKPOINT: {
                return HdfsServerConstants.NamenodeRole.CHECKPOINT;
            }
        }
        return null;
    }

    public static HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto convert(HdfsServerConstants.NamenodeRole role) {
        switch (role) {
            case NAMENODE: {
                return HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.NAMENODE;
            }
            case BACKUP: {
                return HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.BACKUP;
            }
            case CHECKPOINT: {
                return HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.CHECKPOINT;
            }
        }
        return null;
    }

    public static HdfsProtos.StorageInfoProto convert(StorageInfo info) {
        return HdfsProtos.StorageInfoProto.newBuilder().setClusterID(info.getClusterID()).setCTime(info.getCTime()).setLayoutVersion(info.getLayoutVersion()).setNamespceID(info.getNamespaceID()).build();
    }

    public static StorageInfo convert(HdfsProtos.StorageInfoProto info) {
        return new StorageInfo(info.getLayoutVersion(), info.getNamespceID(), info.getClusterID(), info.getCTime());
    }

    public static HdfsProtos.NamenodeRegistrationProto convert(NamenodeRegistration reg) {
        return HdfsProtos.NamenodeRegistrationProto.newBuilder().setHttpAddress(reg.getHttpAddress()).setRole(PBHelper.convert(reg.getRole())).setRpcAddress(reg.getAddress()).setStorageInfo(PBHelper.convert((StorageInfo)reg)).build();
    }

    public static NamenodeRegistration convert(HdfsProtos.NamenodeRegistrationProto reg) {
        return new NamenodeRegistration(reg.getRpcAddress(), reg.getHttpAddress(), PBHelper.convert(reg.getStorageInfo()), PBHelper.convert(reg.getRole()));
    }

    public static DatanodeID convert(HdfsProtos.DatanodeIDProto dn) {
        return new DatanodeID(dn.getIpAddr(), dn.getHostName(), dn.getStorageID(), dn.getXferPort(), dn.getInfoPort(), dn.getIpcPort());
    }

    public static HdfsProtos.DatanodeIDProto convert(DatanodeID dn) {
        return HdfsProtos.DatanodeIDProto.newBuilder().setIpAddr(dn.getIpAddr()).setHostName(dn.getHostName()).setStorageID(dn.getStorageID()).setXferPort(dn.getXferPort()).setInfoPort(dn.getInfoPort()).setIpcPort(dn.getIpcPort()).build();
    }

    public static HdfsProtos.DatanodeIDProto[] convert(DatanodeID[] did) {
        if (did == null) {
            return null;
        }
        int len = did.length;
        HdfsProtos.DatanodeIDProto[] result = new HdfsProtos.DatanodeIDProto[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(did[i]);
        }
        return result;
    }

    public static DatanodeID[] convert(HdfsProtos.DatanodeIDProto[] did) {
        if (did == null) {
            return null;
        }
        int len = did.length;
        DatanodeID[] result = new DatanodeID[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(did[i]);
        }
        return result;
    }

    public static HdfsProtos.BlockProto convert(Block b) {
        return HdfsProtos.BlockProto.newBuilder().setBlockId(b.getBlockId()).setGenStamp(b.getGenerationStamp()).setNumBytes(b.getNumBytes()).build();
    }

    public static Block convert(HdfsProtos.BlockProto b) {
        return new Block(b.getBlockId(), b.getNumBytes(), b.getGenStamp());
    }

    public static HdfsProtos.BlockWithLocationsProto convert(BlocksWithLocations.BlockWithLocations blk) {
        return HdfsProtos.BlockWithLocationsProto.newBuilder().setBlock(PBHelper.convert(blk.getBlock())).addAllStorageIDs(Arrays.asList(blk.getStorageIDs())).build();
    }

    public static BlocksWithLocations.BlockWithLocations convert(HdfsProtos.BlockWithLocationsProto b) {
        return new BlocksWithLocations.BlockWithLocations(PBHelper.convert(b.getBlock()), b.getStorageIDsList().toArray(new String[0]));
    }

    public static HdfsProtos.BlocksWithLocationsProto convert(BlocksWithLocations blks) {
        HdfsProtos.BlocksWithLocationsProto.Builder builder = HdfsProtos.BlocksWithLocationsProto.newBuilder();
        for (BlocksWithLocations.BlockWithLocations b : blks.getBlocks()) {
            builder.addBlocks(PBHelper.convert(b));
        }
        return builder.build();
    }

    public static BlocksWithLocations convert(HdfsProtos.BlocksWithLocationsProto blocks) {
        List<HdfsProtos.BlockWithLocationsProto> b = blocks.getBlocksList();
        BlocksWithLocations.BlockWithLocations[] ret = new BlocksWithLocations.BlockWithLocations[b.size()];
        int i = 0;
        for (HdfsProtos.BlockWithLocationsProto entry : b) {
            ret[i++] = PBHelper.convert(entry);
        }
        return new BlocksWithLocations(ret);
    }

    public static HdfsProtos.BlockKeyProto convert(BlockKey key) {
        byte[] encodedKey = key.getEncodedKey();
        ByteString keyBytes = ByteString.copyFrom((byte[])(encodedKey == null ? new byte[]{} : encodedKey));
        return HdfsProtos.BlockKeyProto.newBuilder().setKeyId(key.getKeyId()).setKeyBytes(keyBytes).setExpiryDate(key.getExpiryDate()).build();
    }

    public static BlockKey convert(HdfsProtos.BlockKeyProto k) {
        return new BlockKey(k.getKeyId(), k.getExpiryDate(), k.getKeyBytes().toByteArray());
    }

    public static HdfsProtos.ExportedBlockKeysProto convert(ExportedBlockKeys keys) {
        HdfsProtos.ExportedBlockKeysProto.Builder builder = HdfsProtos.ExportedBlockKeysProto.newBuilder();
        builder.setIsBlockTokenEnabled(keys.isBlockTokenEnabled()).setKeyUpdateInterval(keys.getKeyUpdateInterval()).setTokenLifeTime(keys.getTokenLifetime()).setCurrentKey(PBHelper.convert(keys.getCurrentKey()));
        for (BlockKey k : keys.getAllKeys()) {
            builder.addAllKeys(PBHelper.convert(k));
        }
        return builder.build();
    }

    public static ExportedBlockKeys convert(HdfsProtos.ExportedBlockKeysProto keys) {
        return new ExportedBlockKeys(keys.getIsBlockTokenEnabled(), keys.getKeyUpdateInterval(), keys.getTokenLifeTime(), PBHelper.convert(keys.getCurrentKey()), PBHelper.convertBlockKeys(keys.getAllKeysList()));
    }

    public static HdfsProtos.CheckpointSignatureProto convert(CheckpointSignature s) {
        return HdfsProtos.CheckpointSignatureProto.newBuilder().setBlockPoolId(s.getBlockpoolID()).setCurSegmentTxId(s.getCurSegmentTxId()).setMostRecentCheckpointTxId(s.getMostRecentCheckpointTxId()).setStorageInfo(PBHelper.convert((StorageInfo)s)).build();
    }

    public static CheckpointSignature convert(HdfsProtos.CheckpointSignatureProto s) {
        return new CheckpointSignature(PBHelper.convert(s.getStorageInfo()), s.getBlockPoolId(), s.getMostRecentCheckpointTxId(), s.getCurSegmentTxId());
    }

    public static HdfsProtos.RemoteEditLogProto convert(RemoteEditLog log) {
        return HdfsProtos.RemoteEditLogProto.newBuilder().setEndTxId(log.getEndTxId()).setStartTxId(log.getStartTxId()).build();
    }

    public static RemoteEditLog convert(HdfsProtos.RemoteEditLogProto l) {
        return new RemoteEditLog(l.getStartTxId(), l.getEndTxId());
    }

    public static HdfsProtos.RemoteEditLogManifestProto convert(RemoteEditLogManifest manifest) {
        HdfsProtos.RemoteEditLogManifestProto.Builder builder = HdfsProtos.RemoteEditLogManifestProto.newBuilder();
        for (RemoteEditLog log : manifest.getLogs()) {
            builder.addLogs(PBHelper.convert(log));
        }
        return builder.build();
    }

    public static RemoteEditLogManifest convert(HdfsProtos.RemoteEditLogManifestProto manifest) {
        ArrayList<RemoteEditLog> logs = new ArrayList<RemoteEditLog>(manifest.getLogsList().size());
        for (HdfsProtos.RemoteEditLogProto l : manifest.getLogsList()) {
            logs.add(PBHelper.convert(l));
        }
        return new RemoteEditLogManifest(logs);
    }

    public static HdfsProtos.CheckpointCommandProto convert(CheckpointCommand cmd) {
        return HdfsProtos.CheckpointCommandProto.newBuilder().setSignature(PBHelper.convert(cmd.getSignature())).setNeedToReturnImage(cmd.needToReturnImage()).build();
    }

    public static HdfsProtos.NamenodeCommandProto convert(NamenodeCommand cmd) {
        if (cmd instanceof CheckpointCommand) {
            return HdfsProtos.NamenodeCommandProto.newBuilder().setAction(cmd.getAction()).setType(HdfsProtos.NamenodeCommandProto.Type.CheckPointCommand).setCheckpointCmd(PBHelper.convert((CheckpointCommand)cmd)).build();
        }
        return HdfsProtos.NamenodeCommandProto.newBuilder().setType(HdfsProtos.NamenodeCommandProto.Type.NamenodeCommand).setAction(cmd.getAction()).build();
    }

    public static BlockKey[] convertBlockKeys(List<HdfsProtos.BlockKeyProto> list) {
        BlockKey[] ret = new BlockKey[list.size()];
        int i = 0;
        for (HdfsProtos.BlockKeyProto k : list) {
            ret[i++] = PBHelper.convert(k);
        }
        return ret;
    }

    public static NamespaceInfo convert(HdfsProtos.NamespaceInfoProto info) {
        HdfsProtos.StorageInfoProto storage = info.getStorageInfo();
        return new NamespaceInfo(storage.getNamespceID(), storage.getClusterID(), info.getBlockPoolID(), storage.getCTime(), info.getBuildVersion(), info.getSoftwareVersion());
    }

    public static NamenodeCommand convert(HdfsProtos.NamenodeCommandProto cmd) {
        if (cmd == null) {
            return null;
        }
        switch (cmd.getType()) {
            case CheckPointCommand: {
                HdfsProtos.CheckpointCommandProto chkPt = cmd.getCheckpointCmd();
                return new CheckpointCommand(PBHelper.convert(chkPt.getSignature()), chkPt.getNeedToReturnImage());
            }
        }
        return new NamenodeCommand(cmd.getAction());
    }

    public static ExtendedBlock convert(HdfsProtos.ExtendedBlockProto eb) {
        if (eb == null) {
            return null;
        }
        return new ExtendedBlock(eb.getPoolId(), eb.getBlockId(), eb.getNumBytes(), eb.getGenerationStamp());
    }

    public static HdfsProtos.ExtendedBlockProto convert(ExtendedBlock b) {
        if (b == null) {
            return null;
        }
        return HdfsProtos.ExtendedBlockProto.newBuilder().setPoolId(b.getBlockPoolId()).setBlockId(b.getBlockId()).setNumBytes(b.getNumBytes()).setGenerationStamp(b.getGenerationStamp()).build();
    }

    public static HdfsProtos.RecoveringBlockProto convert(BlockRecoveryCommand.RecoveringBlock b) {
        if (b == null) {
            return null;
        }
        HdfsProtos.LocatedBlockProto lb = PBHelper.convert((LocatedBlock)b);
        return HdfsProtos.RecoveringBlockProto.newBuilder().setBlock(lb).setNewGenStamp(b.getNewGenerationStamp()).build();
    }

    public static BlockRecoveryCommand.RecoveringBlock convert(HdfsProtos.RecoveringBlockProto b) {
        ExtendedBlock block = PBHelper.convert(b.getBlock().getB());
        DatanodeInfo[] locs = PBHelper.convert(b.getBlock().getLocsList());
        return new BlockRecoveryCommand.RecoveringBlock(block, locs, b.getNewGenStamp());
    }

    public static HdfsProtos.DatanodeInfoProto.AdminState convert(DatanodeInfo.AdminStates inAs) {
        switch (inAs) {
            case NORMAL: {
                return HdfsProtos.DatanodeInfoProto.AdminState.NORMAL;
            }
            case DECOMMISSION_INPROGRESS: {
                return HdfsProtos.DatanodeInfoProto.AdminState.DECOMMISSION_INPROGRESS;
            }
            case DECOMMISSIONED: {
                return HdfsProtos.DatanodeInfoProto.AdminState.DECOMMISSIONED;
            }
        }
        return HdfsProtos.DatanodeInfoProto.AdminState.NORMAL;
    }

    public static DatanodeInfo convert(HdfsProtos.DatanodeInfoProto di) {
        if (di == null) {
            return null;
        }
        return new DatanodeInfo(PBHelper.convert(di.getId()), di.hasLocation() ? di.getLocation() : null, di.getCapacity(), di.getDfsUsed(), di.getRemaining(), di.getBlockPoolUsed(), di.getLastUpdate(), di.getXceiverCount(), PBHelper.convert(di.getAdminState()));
    }

    public static HdfsProtos.DatanodeInfoProto convertDatanodeInfo(DatanodeInfo di) {
        if (di == null) {
            return null;
        }
        HdfsProtos.DatanodeInfoProto.Builder builder = HdfsProtos.DatanodeInfoProto.newBuilder();
        if (di.getNetworkLocation() != null) {
            builder.setLocation(di.getNetworkLocation());
        }
        return builder.setId(PBHelper.convert((DatanodeID)di)).setCapacity(di.getCapacity()).setDfsUsed(di.getDfsUsed()).setRemaining(di.getRemaining()).setBlockPoolUsed(di.getBlockPoolUsed()).setLastUpdate(di.getLastUpdate()).setXceiverCount(di.getXceiverCount()).setAdminState(PBHelper.convert(di.getAdminState())).build();
    }

    public static DatanodeInfo[] convert(HdfsProtos.DatanodeInfoProto[] di) {
        if (di == null) {
            return null;
        }
        DatanodeInfo[] result = new DatanodeInfo[di.length];
        for (int i = 0; i < di.length; ++i) {
            result[i] = PBHelper.convert(di[i]);
        }
        return result;
    }

    public static HdfsProtos.DatanodeInfoProto[] convert(DatanodeInfo[] di) {
        if (di == null) {
            return null;
        }
        HdfsProtos.DatanodeInfoProto[] result = new HdfsProtos.DatanodeInfoProto[di.length];
        for (int i = 0; i < di.length; ++i) {
            result[i] = PBHelper.convertDatanodeInfo(di[i]);
        }
        return result;
    }

    public static DatanodeInfo[] convert(List<HdfsProtos.DatanodeInfoProto> list) {
        DatanodeInfo[] info = new DatanodeInfo[list.size()];
        for (int i = 0; i < info.length; ++i) {
            info[i] = PBHelper.convert(list.get(i));
        }
        return info;
    }

    public static HdfsProtos.DatanodeInfoProto convert(DatanodeInfo info) {
        HdfsProtos.DatanodeInfoProto.Builder builder = HdfsProtos.DatanodeInfoProto.newBuilder();
        builder.setBlockPoolUsed(info.getBlockPoolUsed());
        builder.setAdminState(PBHelper.convert(info.getAdminState()));
        builder.setCapacity(info.getCapacity()).setDfsUsed(info.getDfsUsed()).setId(PBHelper.convert((DatanodeID)info)).setLastUpdate(info.getLastUpdate()).setLocation(info.getNetworkLocation()).setRemaining(info.getRemaining()).setXceiverCount(info.getXceiverCount()).build();
        return builder.build();
    }

    public static DatanodeInfo.AdminStates convert(HdfsProtos.DatanodeInfoProto.AdminState adminState) {
        switch (adminState) {
            case DECOMMISSION_INPROGRESS: {
                return DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS;
            }
            case DECOMMISSIONED: {
                return DatanodeInfo.AdminStates.DECOMMISSIONED;
            }
        }
        return DatanodeInfo.AdminStates.NORMAL;
    }

    public static HdfsProtos.LocatedBlockProto convert(LocatedBlock b) {
        if (b == null) {
            return null;
        }
        HdfsProtos.LocatedBlockProto.Builder builder = HdfsProtos.LocatedBlockProto.newBuilder();
        DatanodeInfo[] locs = b.getLocations();
        for (int i = 0; i < locs.length; ++i) {
            builder.addLocs(i, PBHelper.convert(locs[i]));
        }
        return builder.setB(PBHelper.convert(b.getBlock())).setBlockToken(PBHelper.convert(b.getBlockToken())).setCorrupt(b.isCorrupt()).setOffset(b.getStartOffset()).build();
    }

    public static LocatedBlock convert(HdfsProtos.LocatedBlockProto proto) {
        if (proto == null) {
            return null;
        }
        List<HdfsProtos.DatanodeInfoProto> locs = proto.getLocsList();
        DatanodeInfo[] targets = new DatanodeInfo[locs.size()];
        for (int i = 0; i < locs.size(); ++i) {
            targets[i] = PBHelper.convert(locs.get(i));
        }
        LocatedBlock lb = new LocatedBlock(PBHelper.convert(proto.getB()), targets, proto.getOffset(), proto.getCorrupt());
        lb.setBlockToken(PBHelper.convert(proto.getBlockToken()));
        return lb;
    }

    public static HdfsProtos.BlockTokenIdentifierProto convert(Token<?> tok) {
        return HdfsProtos.BlockTokenIdentifierProto.newBuilder().setIdentifier(ByteString.copyFrom((byte[])tok.getIdentifier())).setPassword(ByteString.copyFrom((byte[])tok.getPassword())).setKind(tok.getKind().toString()).setService(tok.getService().toString()).build();
    }

    public static Token<BlockTokenIdentifier> convert(HdfsProtos.BlockTokenIdentifierProto blockToken) {
        return new Token(blockToken.getIdentifier().toByteArray(), blockToken.getPassword().toByteArray(), new Text(blockToken.getKind()), new Text(blockToken.getService()));
    }

    public static Token<DelegationTokenIdentifier> convertDelegationToken(HdfsProtos.BlockTokenIdentifierProto blockToken) {
        return new Token(blockToken.getIdentifier().toByteArray(), blockToken.getPassword().toByteArray(), new Text(blockToken.getKind()), new Text(blockToken.getService()));
    }

    public static HdfsServerConstants.ReplicaState convert(HdfsProtos.ReplicaStateProto state) {
        switch (state) {
            case RBW: {
                return HdfsServerConstants.ReplicaState.RBW;
            }
            case RUR: {
                return HdfsServerConstants.ReplicaState.RUR;
            }
            case RWR: {
                return HdfsServerConstants.ReplicaState.RWR;
            }
            case TEMPORARY: {
                return HdfsServerConstants.ReplicaState.TEMPORARY;
            }
        }
        return HdfsServerConstants.ReplicaState.FINALIZED;
    }

    public static HdfsProtos.ReplicaStateProto convert(HdfsServerConstants.ReplicaState state) {
        switch (state) {
            case RBW: {
                return HdfsProtos.ReplicaStateProto.RBW;
            }
            case RUR: {
                return HdfsProtos.ReplicaStateProto.RUR;
            }
            case RWR: {
                return HdfsProtos.ReplicaStateProto.RWR;
            }
            case TEMPORARY: {
                return HdfsProtos.ReplicaStateProto.TEMPORARY;
            }
        }
        return HdfsProtos.ReplicaStateProto.FINALIZED;
    }

    public static DatanodeProtocolProtos.DatanodeRegistrationProto convert(DatanodeRegistration registration) {
        DatanodeProtocolProtos.DatanodeRegistrationProto.Builder builder = DatanodeProtocolProtos.DatanodeRegistrationProto.newBuilder();
        return builder.setDatanodeID(PBHelper.convert((DatanodeID)registration)).setStorageInfo(PBHelper.convert(registration.getStorageInfo())).setKeys(PBHelper.convert(registration.getExportedKeys())).setSoftwareVersion(registration.getSoftwareVersion()).build();
    }

    public static DatanodeRegistration convert(DatanodeProtocolProtos.DatanodeRegistrationProto proto) {
        return new DatanodeRegistration(PBHelper.convert(proto.getDatanodeID()), PBHelper.convert(proto.getStorageInfo()), PBHelper.convert(proto.getKeys()), proto.getSoftwareVersion());
    }

    public static DatanodeCommand convert(DatanodeProtocolProtos.DatanodeCommandProto proto) {
        switch (proto.getCmdType()) {
            case BalancerBandwidthCommand: {
                return PBHelper.convert(proto.getBalancerCmd());
            }
            case BlockCommand: {
                return PBHelper.convert(proto.getBlkCmd());
            }
            case BlockRecoveryCommand: {
                return PBHelper.convert(proto.getRecoveryCmd());
            }
            case FinalizeCommand: {
                return PBHelper.convert(proto.getFinalizeCmd());
            }
            case KeyUpdateCommand: {
                return PBHelper.convert(proto.getKeyUpdateCmd());
            }
            case RegisterCommand: {
                return REG_CMD;
            }
        }
        return null;
    }

    public static DatanodeProtocolProtos.BalancerBandwidthCommandProto convert(BalancerBandwidthCommand bbCmd) {
        return DatanodeProtocolProtos.BalancerBandwidthCommandProto.newBuilder().setBandwidth(bbCmd.getBalancerBandwidthValue()).build();
    }

    public static DatanodeProtocolProtos.KeyUpdateCommandProto convert(KeyUpdateCommand cmd) {
        return DatanodeProtocolProtos.KeyUpdateCommandProto.newBuilder().setKeys(PBHelper.convert(cmd.getExportedKeys())).build();
    }

    public static DatanodeProtocolProtos.BlockRecoveryCommandProto convert(BlockRecoveryCommand cmd) {
        DatanodeProtocolProtos.BlockRecoveryCommandProto.Builder builder = DatanodeProtocolProtos.BlockRecoveryCommandProto.newBuilder();
        for (BlockRecoveryCommand.RecoveringBlock b : cmd.getRecoveringBlocks()) {
            builder.addBlocks(PBHelper.convert(b));
        }
        return builder.build();
    }

    public static DatanodeProtocolProtos.FinalizeCommandProto convert(FinalizeCommand cmd) {
        return DatanodeProtocolProtos.FinalizeCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId()).build();
    }

    public static DatanodeProtocolProtos.BlockCommandProto convert(BlockCommand cmd) {
        DatanodeProtocolProtos.BlockCommandProto.Builder builder = DatanodeProtocolProtos.BlockCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId());
        switch (cmd.getAction()) {
            case 1: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.TRANSFER);
                break;
            }
            case 2: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.INVALIDATE);
                break;
            }
            case 3: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.SHUTDOWN);
            }
        }
        Block[] blocks = cmd.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            builder.addBlocks(PBHelper.convert(blocks[i]));
        }
        builder.addAllTargets(PBHelper.convert(cmd.getTargets()));
        return builder.build();
    }

    private static List<HdfsProtos.DatanodeInfosProto> convert(DatanodeInfo[][] targets) {
        HdfsProtos.DatanodeInfosProto[] ret = new HdfsProtos.DatanodeInfosProto[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            ret[i] = HdfsProtos.DatanodeInfosProto.newBuilder().addAllDatanodes(Arrays.asList(PBHelper.convert(targets[i]))).build();
        }
        return Arrays.asList(ret);
    }

    public static DatanodeProtocolProtos.DatanodeCommandProto convert(DatanodeCommand datanodeCommand) {
        DatanodeProtocolProtos.DatanodeCommandProto.Builder builder = DatanodeProtocolProtos.DatanodeCommandProto.newBuilder();
        if (datanodeCommand == null) {
            return builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.NullDatanodeCommand).build();
        }
        switch (datanodeCommand.getAction()) {
            case 8: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BalancerBandwidthCommand).setBalancerCmd(PBHelper.convert((BalancerBandwidthCommand)datanodeCommand));
                break;
            }
            case 7: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.KeyUpdateCommand).setKeyUpdateCmd(PBHelper.convert((KeyUpdateCommand)datanodeCommand));
                break;
            }
            case 6: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockRecoveryCommand).setRecoveryCmd(PBHelper.convert((BlockRecoveryCommand)datanodeCommand));
                break;
            }
            case 5: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.FinalizeCommand).setFinalizeCmd(PBHelper.convert((FinalizeCommand)datanodeCommand));
                break;
            }
            case 4: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.RegisterCommand).setRegisterCmd(REG_CMD_PROTO);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockCommand).setBlkCmd(PBHelper.convert((BlockCommand)datanodeCommand));
                break;
            }
            default: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.NullDatanodeCommand);
            }
        }
        return builder.build();
    }

    public static KeyUpdateCommand convert(DatanodeProtocolProtos.KeyUpdateCommandProto keyUpdateCmd) {
        return new KeyUpdateCommand(PBHelper.convert(keyUpdateCmd.getKeys()));
    }

    public static FinalizeCommand convert(DatanodeProtocolProtos.FinalizeCommandProto finalizeCmd) {
        return new FinalizeCommand(finalizeCmd.getBlockPoolId());
    }

    public static BlockRecoveryCommand convert(DatanodeProtocolProtos.BlockRecoveryCommandProto recoveryCmd) {
        List<HdfsProtos.RecoveringBlockProto> list = recoveryCmd.getBlocksList();
        ArrayList<BlockRecoveryCommand.RecoveringBlock> recoveringBlocks = new ArrayList<BlockRecoveryCommand.RecoveringBlock>(list.size());
        for (HdfsProtos.RecoveringBlockProto rbp : list) {
            recoveringBlocks.add(PBHelper.convert(rbp));
        }
        return new BlockRecoveryCommand(recoveringBlocks);
    }

    public static BlockCommand convert(DatanodeProtocolProtos.BlockCommandProto blkCmd) {
        List<HdfsProtos.BlockProto> blockProtoList = blkCmd.getBlocksList();
        Block[] blocks = new Block[blockProtoList.size()];
        for (int i = 0; i < blockProtoList.size(); ++i) {
            blocks[i] = PBHelper.convert(blockProtoList.get(i));
        }
        List<HdfsProtos.DatanodeInfosProto> targetList = blkCmd.getTargetsList();
        DatanodeInfo[][] targets = new DatanodeInfo[targetList.size()][];
        for (int i = 0; i < targetList.size(); ++i) {
            targets[i] = PBHelper.convert(targetList.get(i));
        }
        int action = 0;
        switch (blkCmd.getAction()) {
            case TRANSFER: {
                action = 1;
                break;
            }
            case INVALIDATE: {
                action = 2;
                break;
            }
            case SHUTDOWN: {
                action = 3;
            }
        }
        return new BlockCommand(action, blkCmd.getBlockPoolId(), blocks, targets);
    }

    public static DatanodeInfo[] convert(HdfsProtos.DatanodeInfosProto datanodeInfosProto) {
        List<HdfsProtos.DatanodeInfoProto> proto = datanodeInfosProto.getDatanodesList();
        DatanodeInfo[] infos = new DatanodeInfo[proto.size()];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = PBHelper.convert(proto.get(i));
        }
        return infos;
    }

    public static BalancerBandwidthCommand convert(DatanodeProtocolProtos.BalancerBandwidthCommandProto balancerCmd) {
        return new BalancerBandwidthCommand(balancerCmd.getBandwidth());
    }

    public static DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto convert(ReceivedDeletedBlockInfo receivedDeletedBlockInfo) {
        DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus status;
        DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.Builder builder = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.newBuilder();
        switch (receivedDeletedBlockInfo.getStatus()) {
            case RECEIVING_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.RECEIVING;
                break;
            }
            case RECEIVED_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.RECEIVED;
                break;
            }
            case DELETED_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.DELETED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad status: " + (Object)((Object)receivedDeletedBlockInfo.getStatus()));
            }
        }
        builder.setStatus(status);
        if (receivedDeletedBlockInfo.getDelHints() != null) {
            builder.setDeleteHint(receivedDeletedBlockInfo.getDelHints());
        }
        return builder.setBlock(PBHelper.convert(receivedDeletedBlockInfo.getBlock())).build();
    }

    public static ReceivedDeletedBlockInfo convert(DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto proto) {
        ReceivedDeletedBlockInfo.BlockStatus status = null;
        switch (proto.getStatus()) {
            case RECEIVING: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK;
                break;
            }
            case RECEIVED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK;
                break;
            }
            case DELETED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK;
            }
        }
        return new ReceivedDeletedBlockInfo(PBHelper.convert(proto.getBlock()), status, proto.hasDeleteHint() ? proto.getDeleteHint() : null);
    }

    public static HdfsProtos.NamespaceInfoProto convert(NamespaceInfo info) {
        return HdfsProtos.NamespaceInfoProto.newBuilder().setBlockPoolID(info.getBlockPoolID()).setBuildVersion(info.getBuildVersion()).setUnused(0).setStorageInfo(PBHelper.convert((StorageInfo)info)).setSoftwareVersion(info.getSoftwareVersion()).build();
    }

    public static HdfsProtos.LocatedBlockProto[] convertLocatedBlock(LocatedBlock[] lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.length;
        HdfsProtos.LocatedBlockProto[] result = new HdfsProtos.LocatedBlockProto[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(lb[i]);
        }
        return result;
    }

    public static LocatedBlock[] convertLocatedBlock(HdfsProtos.LocatedBlockProto[] lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.length;
        LocatedBlock[] result = new LocatedBlock[len];
        for (int i = 0; i < len; ++i) {
            result[i] = new LocatedBlock(PBHelper.convert(lb[i].getB()), PBHelper.convert(lb[i].getLocsList()), lb[i].getOffset(), lb[i].getCorrupt());
        }
        return result;
    }

    public static List<LocatedBlock> convertLocatedBlock(List<HdfsProtos.LocatedBlockProto> lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.size();
        ArrayList<LocatedBlock> result = new ArrayList<LocatedBlock>(len);
        for (int i = 0; i < len; ++i) {
            result.add(PBHelper.convert(lb.get(i)));
        }
        return result;
    }

    public static List<HdfsProtos.LocatedBlockProto> convertLocatedBlock2(List<LocatedBlock> lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.size();
        ArrayList<HdfsProtos.LocatedBlockProto> result = new ArrayList<HdfsProtos.LocatedBlockProto>(len);
        for (int i = 0; i < len; ++i) {
            result.add(PBHelper.convert(lb.get(i)));
        }
        return result;
    }

    public static LocatedBlocks convert(HdfsProtos.LocatedBlocksProto lb) {
        return new LocatedBlocks(lb.getFileLength(), lb.getUnderConstruction(), PBHelper.convertLocatedBlock(lb.getBlocksList()), lb.hasLastBlock() ? PBHelper.convert(lb.getLastBlock()) : null, lb.getIsLastBlockComplete());
    }

    public static HdfsProtos.LocatedBlocksProto convert(LocatedBlocks lb) {
        if (lb == null) {
            return null;
        }
        HdfsProtos.LocatedBlocksProto.Builder builder = HdfsProtos.LocatedBlocksProto.newBuilder();
        if (lb.getLastLocatedBlock() != null) {
            builder.setLastBlock(PBHelper.convert(lb.getLastLocatedBlock()));
        }
        return builder.setFileLength(lb.getFileLength()).setUnderConstruction(lb.isUnderConstruction()).addAllBlocks(PBHelper.convertLocatedBlock2(lb.getLocatedBlocks())).setIsLastBlockComplete(lb.isLastBlockComplete()).build();
    }

    public static DataEncryptionKey convert(HdfsProtos.DataEncryptionKeyProto bet) {
        String encryptionAlgorithm = bet.getEncryptionAlgorithm();
        return new DataEncryptionKey(bet.getKeyId(), bet.getBlockPoolId(), bet.getNonce().toByteArray(), bet.getEncryptionKey().toByteArray(), bet.getExpiryDate(), encryptionAlgorithm.isEmpty() ? null : encryptionAlgorithm);
    }

    public static HdfsProtos.DataEncryptionKeyProto convert(DataEncryptionKey bet) {
        HdfsProtos.DataEncryptionKeyProto.Builder b = HdfsProtos.DataEncryptionKeyProto.newBuilder().setKeyId(bet.keyId).setBlockPoolId(bet.blockPoolId).setNonce(ByteString.copyFrom((byte[])bet.nonce)).setEncryptionKey(ByteString.copyFrom((byte[])bet.encryptionKey)).setExpiryDate(bet.expiryDate);
        if (bet.encryptionAlgorithm != null) {
            b.setEncryptionAlgorithm(bet.encryptionAlgorithm);
        }
        return b.build();
    }

    public static FsServerDefaults convert(HdfsProtos.FsServerDefaultsProto fs) {
        if (fs == null) {
            return null;
        }
        return new FsServerDefaults(fs.getBlockSize(), fs.getBytesPerChecksum(), fs.getWritePacketSize(), (short)fs.getReplication(), fs.getFileBufferSize(), fs.getEncryptDataTransfer(), fs.getTrashInterval(), DataChecksum.Type.valueOf((String)fs.getChecksumType().name()));
    }

    public static HdfsProtos.FsServerDefaultsProto convert(FsServerDefaults fs) {
        if (fs == null) {
            return null;
        }
        return HdfsProtos.FsServerDefaultsProto.newBuilder().setBlockSize(fs.getBlockSize()).setBytesPerChecksum(fs.getBytesPerChecksum()).setWritePacketSize(fs.getWritePacketSize()).setReplication(fs.getReplication()).setFileBufferSize(fs.getFileBufferSize()).setEncryptDataTransfer(fs.getEncryptDataTransfer()).setTrashInterval(fs.getTrashInterval()).setChecksumType(HdfsProtos.ChecksumTypeProto.valueOf(fs.getChecksumType().name())).build();
    }

    public static HdfsProtos.FsPermissionProto convert(FsPermission p) {
        if (p == null) {
            return null;
        }
        return HdfsProtos.FsPermissionProto.newBuilder().setPerm(p.toShort()).build();
    }

    public static FsPermission convert(HdfsProtos.FsPermissionProto p) {
        if (p == null) {
            return null;
        }
        return new FsPermission((short)p.getPerm());
    }

    public static int convertCreateFlag(EnumSetWritable<CreateFlag> flag) {
        int value = 0;
        if (flag.contains((Object)CreateFlag.APPEND)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.APPEND.getNumber();
        }
        if (flag.contains((Object)CreateFlag.CREATE)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.CREATE.getNumber();
        }
        if (flag.contains((Object)CreateFlag.OVERWRITE)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.OVERWRITE.getNumber();
        }
        return value;
    }

    public static EnumSetWritable<CreateFlag> convert(int flag) {
        EnumSet<CreateFlag> result = EnumSet.noneOf(CreateFlag.class);
        if ((flag & 4) == 4) {
            result.add(CreateFlag.APPEND);
        }
        if ((flag & 1) == 1) {
            result.add(CreateFlag.CREATE);
        }
        if ((flag & 2) == 2) {
            result.add(CreateFlag.OVERWRITE);
        }
        return new EnumSetWritable(result);
    }

    public static HdfsFileStatus convert(HdfsProtos.HdfsFileStatusProto fs) {
        if (fs == null) {
            return null;
        }
        return new HdfsLocatedFileStatus(fs.getLength(), fs.getFileType().equals((Object)HdfsProtos.HdfsFileStatusProto.FileType.IS_DIR), fs.getBlockReplication(), fs.getBlocksize(), fs.getModificationTime(), fs.getAccessTime(), PBHelper.convert(fs.getPermission()), fs.getOwner(), fs.getGroup(), fs.getFileType().equals((Object)HdfsProtos.HdfsFileStatusProto.FileType.IS_SYMLINK) ? fs.getSymlink().toByteArray() : null, fs.getPath().toByteArray(), fs.hasLocations() ? PBHelper.convert(fs.getLocations()) : null);
    }

    public static HdfsProtos.HdfsFileStatusProto convert(HdfsFileStatus fs) {
        LocatedBlocks locations;
        if (fs == null) {
            return null;
        }
        HdfsProtos.HdfsFileStatusProto.FileType fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_FILE;
        if (fs.isDir()) {
            fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_DIR;
        } else if (fs.isSymlink()) {
            fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_SYMLINK;
        }
        HdfsProtos.HdfsFileStatusProto.Builder builder = HdfsProtos.HdfsFileStatusProto.newBuilder().setLength(fs.getLen()).setFileType(fType).setBlockReplication(fs.getReplication()).setBlocksize(fs.getBlockSize()).setModificationTime(fs.getModificationTime()).setAccessTime(fs.getAccessTime()).setPermission(PBHelper.convert(fs.getPermission())).setOwner(fs.getOwner()).setGroup(fs.getGroup()).setPath(ByteString.copyFrom((byte[])fs.getLocalNameInBytes()));
        if (fs.isSymlink()) {
            builder.setSymlink(ByteString.copyFrom((byte[])fs.getSymlinkInBytes()));
        }
        if (fs instanceof HdfsLocatedFileStatus && (locations = ((HdfsLocatedFileStatus)fs).getBlockLocations()) != null) {
            builder.setLocations(PBHelper.convert(locations));
        }
        return builder.build();
    }

    public static HdfsProtos.HdfsFileStatusProto[] convert(HdfsFileStatus[] fs) {
        if (fs == null) {
            return null;
        }
        int len = fs.length;
        HdfsProtos.HdfsFileStatusProto[] result = new HdfsProtos.HdfsFileStatusProto[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(fs[i]);
        }
        return result;
    }

    public static HdfsFileStatus[] convert(HdfsProtos.HdfsFileStatusProto[] fs) {
        if (fs == null) {
            return null;
        }
        int len = fs.length;
        HdfsFileStatus[] result = new HdfsFileStatus[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(fs[i]);
        }
        return result;
    }

    public static DirectoryListing convert(HdfsProtos.DirectoryListingProto dl) {
        if (dl == null) {
            return null;
        }
        List<HdfsProtos.HdfsFileStatusProto> partList = dl.getPartialListingList();
        return new DirectoryListing(partList.isEmpty() ? new HdfsLocatedFileStatus[]{} : PBHelper.convert(partList.toArray(new HdfsProtos.HdfsFileStatusProto[partList.size()])), dl.getRemainingEntries());
    }

    public static HdfsProtos.DirectoryListingProto convert(DirectoryListing d) {
        if (d == null) {
            return null;
        }
        return HdfsProtos.DirectoryListingProto.newBuilder().addAllPartialListing(Arrays.asList(PBHelper.convert(d.getPartialListing()))).setRemainingEntries(d.getRemainingEntries()).build();
    }

    public static long[] convert(ClientNamenodeProtocolProtos.GetFsStatsResponseProto res) {
        long[] result = new long[]{res.getCapacity(), res.getUsed(), res.getRemaining(), res.getUnderReplicated(), res.getCorruptBlocks(), res.getMissingBlocks()};
        return result;
    }

    public static ClientNamenodeProtocolProtos.GetFsStatsResponseProto convert(long[] fsStats) {
        ClientNamenodeProtocolProtos.GetFsStatsResponseProto.Builder result = ClientNamenodeProtocolProtos.GetFsStatsResponseProto.newBuilder();
        if (fsStats.length >= 1) {
            result.setCapacity(fsStats[0]);
        }
        if (fsStats.length >= 2) {
            result.setUsed(fsStats[1]);
        }
        if (fsStats.length >= 3) {
            result.setRemaining(fsStats[2]);
        }
        if (fsStats.length >= 4) {
            result.setUnderReplicated(fsStats[3]);
        }
        if (fsStats.length >= 5) {
            result.setCorruptBlocks(fsStats[4]);
        }
        if (fsStats.length >= 6) {
            result.setMissingBlocks(fsStats[5]);
        }
        return result.build();
    }

    public static ClientNamenodeProtocolProtos.DatanodeReportTypeProto convert(HdfsConstants.DatanodeReportType t) {
        switch (t) {
            case ALL: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.ALL;
            }
            case LIVE: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.LIVE;
            }
            case DEAD: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.DEAD;
            }
        }
        throw new IllegalArgumentException("Unexpected data type report:" + (Object)((Object)t));
    }

    public static HdfsConstants.DatanodeReportType convert(ClientNamenodeProtocolProtos.DatanodeReportTypeProto t) {
        switch (t) {
            case ALL: {
                return HdfsConstants.DatanodeReportType.ALL;
            }
            case LIVE: {
                return HdfsConstants.DatanodeReportType.LIVE;
            }
            case DEAD: {
                return HdfsConstants.DatanodeReportType.DEAD;
            }
        }
        throw new IllegalArgumentException("Unexpected data type report:" + (Object)((Object)t));
    }

    public static ClientNamenodeProtocolProtos.SafeModeActionProto convert(HdfsConstants.SafeModeAction a) {
        switch (a) {
            case SAFEMODE_LEAVE: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_LEAVE;
            }
            case SAFEMODE_ENTER: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_ENTER;
            }
            case SAFEMODE_GET: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_GET;
            }
        }
        throw new IllegalArgumentException("Unexpected SafeModeAction :" + (Object)((Object)a));
    }

    public static HdfsConstants.SafeModeAction convert(ClientNamenodeProtocolProtos.SafeModeActionProto a) {
        switch (a) {
            case SAFEMODE_LEAVE: {
                return HdfsConstants.SafeModeAction.SAFEMODE_LEAVE;
            }
            case SAFEMODE_ENTER: {
                return HdfsConstants.SafeModeAction.SAFEMODE_ENTER;
            }
            case SAFEMODE_GET: {
                return HdfsConstants.SafeModeAction.SAFEMODE_GET;
            }
        }
        throw new IllegalArgumentException("Unexpected SafeModeAction :" + (Object)((Object)a));
    }

    public static CorruptFileBlocks convert(HdfsProtos.CorruptFileBlocksProto c) {
        if (c == null) {
            return null;
        }
        List<String> fileList = c.getFilesList();
        return new CorruptFileBlocks(fileList.toArray(new String[fileList.size()]), c.getCookie());
    }

    public static HdfsProtos.CorruptFileBlocksProto convert(CorruptFileBlocks c) {
        if (c == null) {
            return null;
        }
        return HdfsProtos.CorruptFileBlocksProto.newBuilder().addAllFiles(Arrays.asList(c.getFiles())).setCookie(c.getCookie()).build();
    }

    public static ContentSummary convert(HdfsProtos.ContentSummaryProto cs) {
        if (cs == null) {
            return null;
        }
        return new ContentSummary(cs.getLength(), cs.getFileCount(), cs.getDirectoryCount(), cs.getQuota(), cs.getSpaceConsumed(), cs.getSpaceQuota());
    }

    public static HdfsProtos.ContentSummaryProto convert(ContentSummary cs) {
        if (cs == null) {
            return null;
        }
        return HdfsProtos.ContentSummaryProto.newBuilder().setLength(cs.getLength()).setFileCount(cs.getFileCount()).setDirectoryCount(cs.getDirectoryCount()).setQuota(cs.getQuota()).setSpaceConsumed(cs.getSpaceConsumed()).setSpaceQuota(cs.getSpaceQuota()).build();
    }

    public static NNHAStatusHeartbeat convert(DatanodeProtocolProtos.NNHAStatusHeartbeatProto s) {
        if (s == null) {
            return null;
        }
        switch (s.getState()) {
            case ACTIVE: {
                return new NNHAStatusHeartbeat(NNHAStatusHeartbeat.State.ACTIVE, s.getTxid());
            }
            case STANDBY: {
                return new NNHAStatusHeartbeat(NNHAStatusHeartbeat.State.STANDBY, s.getTxid());
            }
        }
        throw new IllegalArgumentException("Unexpected NNHAStatusHeartbeat.State:" + (Object)((Object)s.getState()));
    }

    public static DatanodeProtocolProtos.NNHAStatusHeartbeatProto convert(NNHAStatusHeartbeat hb) {
        if (hb == null) {
            return null;
        }
        DatanodeProtocolProtos.NNHAStatusHeartbeatProto.Builder builder = DatanodeProtocolProtos.NNHAStatusHeartbeatProto.newBuilder();
        switch (hb.getState()) {
            case ACTIVE: {
                builder.setState(DatanodeProtocolProtos.NNHAStatusHeartbeatProto.State.ACTIVE);
                break;
            }
            case STANDBY: {
                builder.setState(DatanodeProtocolProtos.NNHAStatusHeartbeatProto.State.STANDBY);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected NNHAStatusHeartbeat.State:" + (Object)((Object)hb.getState()));
            }
        }
        builder.setTxid(hb.getTxId());
        return builder.build();
    }

    public static DatanodeProtocolProtos.DatanodeStorageProto convert(DatanodeStorage s) {
        return DatanodeProtocolProtos.DatanodeStorageProto.newBuilder().setState(PBHelper.convert(s.getState())).setStorageID(s.getStorageID()).build();
    }

    private static DatanodeProtocolProtos.DatanodeStorageProto.StorageState convert(DatanodeStorage.State state) {
        switch (state) {
            case READ_ONLY: {
                return DatanodeProtocolProtos.DatanodeStorageProto.StorageState.READ_ONLY;
            }
        }
        return DatanodeProtocolProtos.DatanodeStorageProto.StorageState.NORMAL;
    }

    public static DatanodeStorage convert(DatanodeProtocolProtos.DatanodeStorageProto s) {
        return new DatanodeStorage(s.getStorageID(), PBHelper.convert(s.getState()));
    }

    private static DatanodeStorage.State convert(DatanodeProtocolProtos.DatanodeStorageProto.StorageState state) {
        switch (state) {
            case READ_ONLY: {
                return DatanodeStorage.State.READ_ONLY;
            }
        }
        return DatanodeStorage.State.NORMAL;
    }

    public static DatanodeProtocolProtos.StorageReportProto convert(StorageReport r) {
        return DatanodeProtocolProtos.StorageReportProto.newBuilder().setBlockPoolUsed(r.getBlockPoolUsed()).setCapacity(r.getCapacity()).setDfsUsed(r.getDfsUsed()).setRemaining(r.getRemaining()).setStorageID(r.getStorageID()).build();
    }

    public static JournalInfo convert(JournalProtocolProtos.JournalInfoProto info) {
        int lv = info.hasLayoutVersion() ? info.getLayoutVersion() : 0;
        int nsID = info.hasNamespaceID() ? info.getNamespaceID() : 0;
        return new JournalInfo(lv, info.getClusterID(), nsID);
    }

    public static JournalProtocolProtos.JournalInfoProto convert(JournalInfo j) {
        return JournalProtocolProtos.JournalInfoProto.newBuilder().setClusterID(j.getClusterId()).setLayoutVersion(j.getLayoutVersion()).setNamespaceID(j.getNamespaceId()).build();
    }
}

