/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.util.ByteBufferOutputStream;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class PacketHeader {
    private static final int PROTO_SIZE = DataTransferProtos.PacketHeaderProto.newBuilder().setOffsetInBlock(0L).setSeqno(0L).setLastPacketInBlock(false).setDataLen(0).build().getSerializedSize();
    public static final int PKT_HEADER_LEN = 6 + PROTO_SIZE;
    private int packetLen;
    private DataTransferProtos.PacketHeaderProto proto;

    public PacketHeader() {
    }

    public PacketHeader(int packetLen, long offsetInBlock, long seqno, boolean lastPacketInBlock, int dataLen) {
        this.packetLen = packetLen;
        this.proto = DataTransferProtos.PacketHeaderProto.newBuilder().setOffsetInBlock(offsetInBlock).setSeqno(seqno).setLastPacketInBlock(lastPacketInBlock).setDataLen(dataLen).build();
    }

    public int getDataLen() {
        return this.proto.getDataLen();
    }

    public boolean isLastPacketInBlock() {
        return this.proto.getLastPacketInBlock();
    }

    public long getSeqno() {
        return this.proto.getSeqno();
    }

    public long getOffsetInBlock() {
        return this.proto.getOffsetInBlock();
    }

    public int getPacketLen() {
        return this.packetLen;
    }

    public String toString() {
        return "PacketHeader with packetLen=" + this.packetLen + "Header data: " + this.proto.toString();
    }

    public void readFields(ByteBuffer buf) throws IOException {
        this.packetLen = buf.getInt();
        short protoLen = buf.getShort();
        byte[] data = new byte[protoLen];
        buf.get(data);
        this.proto = DataTransferProtos.PacketHeaderProto.parseFrom(data);
    }

    public void readFields(DataInputStream in) throws IOException {
        this.packetLen = in.readInt();
        short protoLen = in.readShort();
        byte[] data = new byte[protoLen];
        in.readFully(data);
        this.proto = DataTransferProtos.PacketHeaderProto.parseFrom(data);
    }

    public void putInBuffer(ByteBuffer buf) {
        assert (this.proto.getSerializedSize() == PROTO_SIZE) : "Expected " + PROTO_SIZE + " got: " + this.proto.getSerializedSize();
        try {
            buf.putInt(this.packetLen);
            buf.putShort((short)this.proto.getSerializedSize());
            this.proto.writeTo(new ByteBufferOutputStream(buf));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        assert (this.proto.getSerializedSize() == PROTO_SIZE) : "Expected " + PROTO_SIZE + " got: " + this.proto.getSerializedSize();
        out.writeInt(this.packetLen);
        out.writeShort(this.proto.getSerializedSize());
        this.proto.writeTo(out);
    }

    public boolean sanityCheck(long lastSeqNo) {
        if (this.proto.getDataLen() <= 0 && !this.proto.getLastPacketInBlock()) {
            return false;
        }
        if (this.proto.getLastPacketInBlock() && this.proto.getDataLen() != 0) {
            return false;
        }
        return this.proto.getSeqno() == lastSeqNo + 1L;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PacketHeader)) {
            return false;
        }
        PacketHeader other = (PacketHeader)o;
        return this.proto.equals(other.proto);
    }

    public int hashCode() {
        return (int)this.proto.getSeqno();
    }
}

