/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public final class CombinedHostsFileWriter {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private CombinedHostsFileWriter() {
    }

    public static void writeFile(String hostsFile, Set<DatanodeAdminProperties> allDNs) throws IOException {
        StringBuilder configs = new StringBuilder();
        try (OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(hostsFile), "UTF-8");){
            for (DatanodeAdminProperties datanodeAdminProperties : allDNs) {
                configs.append(MAPPER.writeValueAsString((Object)datanodeAdminProperties));
            }
            output.write(configs.toString());
        }
    }
}

