/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.erasurecode.ECSchema;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ErasureCodingPolicy {
    private final String name;
    private final ECSchema schema;
    private final int cellSize;
    private final byte id;

    public ErasureCodingPolicy(String name, ECSchema schema, int cellSize, byte id) {
        this.name = name;
        this.schema = schema;
        this.cellSize = cellSize;
        this.id = id;
    }

    public ErasureCodingPolicy(ECSchema schema, int cellSize, byte id) {
        this(ErasureCodingPolicy.composePolicyName(schema, cellSize), schema, cellSize, id);
    }

    private static String composePolicyName(ECSchema schema, int cellSize) {
        assert (cellSize % 1024 == 0);
        return schema.getCodecName().toUpperCase() + "-" + schema.getNumDataUnits() + "-" + schema.getNumParityUnits() + "-" + cellSize / 1024 + "k";
    }

    public String getName() {
        return this.name;
    }

    public ECSchema getSchema() {
        return this.schema;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public int getNumDataUnits() {
        return this.schema.getNumDataUnits();
    }

    public int getNumParityUnits() {
        return this.schema.getNumParityUnits();
    }

    public String getCodecName() {
        return this.schema.getCodecName();
    }

    public byte getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErasureCodingPolicy that = (ErasureCodingPolicy)o;
        return that.getName().equals(this.name) && that.getCellSize() == this.cellSize && that.getSchema().equals((Object)this.schema);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.schema.hashCode();
        result = 31 * result + this.cellSize;
        return result;
    }

    public String toString() {
        return "ErasureCodingPolicy=[Name=" + this.name + ", Schema=[" + this.schema.toString() + "], CellSize=" + this.cellSize + " ]";
    }
}

