/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.server.SCMStarterInterface;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.common.StorageInfo;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ozone scm", hidden=true, description={"Start or initialize the scm server."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class StorageContainerManagerStarter
extends GenericCli {
    private OzoneConfiguration conf;
    private SCMStarterInterface receiver;
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainerManagerStarter.class);

    public static void main(String[] args) throws Exception {
        TracingUtil.initTracing((String)"StorageContainerManager");
        new StorageContainerManagerStarter(new SCMStarterHelper()).run(args);
    }

    public StorageContainerManagerStarter(SCMStarterInterface receiverObj) {
        this.receiver = receiverObj;
    }

    public Void call() throws Exception {
        this.commonInit();
        this.startScm();
        return null;
    }

    @CommandLine.Command(name="--genclusterid", customSynopsis={"ozone scm [global options] --genclusterid [options]"}, hidden=false, description={"Generate a new Cluster ID"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
    public void generateClusterId() {
        this.commonInit();
        System.out.println("Generating new cluster id:");
        System.out.println(this.receiver.generateClusterId());
    }

    @CommandLine.Command(name="--init", customSynopsis={"ozone scm [global options] --init [options]"}, hidden=false, description={"Initialize the SCM if not already initialized"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
    public void initScm(@CommandLine.Option(names={"--clusterid"}, description={"Optional: The cluster id to use when formatting SCM"}, paramLabel="id") String clusterId) throws Exception {
        this.commonInit();
        boolean result = this.receiver.init(this.conf, clusterId);
        if (!result) {
            throw new IOException("scm init failed");
        }
    }

    private void startScm() throws Exception {
        this.receiver.start(this.conf);
    }

    private void commonInit() {
        this.conf = this.createOzoneConfiguration();
        String[] originalArgs = this.getCmd().getParseResult().originalArgs().toArray(new String[0]);
        StringUtils.startupShutdownMessage(StorageContainerManager.class, (String[])originalArgs, (Logger)LOG);
    }

    static class SCMStarterHelper
    implements SCMStarterInterface {
        SCMStarterHelper() {
        }

        @Override
        public void start(OzoneConfiguration conf) throws Exception {
            StorageContainerManager stm = StorageContainerManager.createSCM(conf);
            stm.start();
            stm.join();
        }

        @Override
        public boolean init(OzoneConfiguration conf, String clusterId) throws IOException {
            return StorageContainerManager.scmInit(conf, clusterId);
        }

        @Override
        public String generateClusterId() {
            return StorageInfo.newClusterID();
        }
    }
}

