/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.RatisPipelineUtils;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineReportHandler.class);
    private final PipelineManager pipelineManager;
    private final Configuration conf;
    private final SCMSafeModeManager scmSafeModeManager;
    private final boolean pipelineAvailabilityCheck;

    public PipelineReportHandler(SCMSafeModeManager scmSafeModeManager, PipelineManager pipelineManager, Configuration conf) {
        Preconditions.checkNotNull((Object)pipelineManager);
        Objects.requireNonNull(scmSafeModeManager);
        this.scmSafeModeManager = scmSafeModeManager;
        this.pipelineManager = pipelineManager;
        this.conf = conf;
        this.pipelineAvailabilityCheck = conf.getBoolean("hdds.scm.safemode.pipeline-availability.check", false);
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode pipelineReportFromDatanode, EventPublisher publisher) {
        Preconditions.checkNotNull((Object)pipelineReportFromDatanode);
        DatanodeDetails dn = pipelineReportFromDatanode.getDatanodeDetails();
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReport = (StorageContainerDatanodeProtocolProtos.PipelineReportsProto)pipelineReportFromDatanode.getReport();
        Preconditions.checkNotNull((Object)dn, (Object)"Pipeline Report is missing DatanodeDetails.");
        LOGGER.trace("Processing pipeline report for dn: {}", (Object)dn);
        for (StorageContainerDatanodeProtocolProtos.PipelineReport report : pipelineReport.getPipelineReportList()) {
            try {
                this.processPipelineReport(report, dn);
            }
            catch (IOException e) {
                LOGGER.error("Could not process pipeline report={} from dn={} {}", new Object[]{report, dn, e});
            }
        }
        if (this.pipelineAvailabilityCheck && this.scmSafeModeManager.getInSafeMode()) {
            publisher.fireEvent(SCMEvents.PROCESSED_PIPELINE_REPORT, (Object)pipelineReportFromDatanode);
        }
    }

    private void processPipelineReport(StorageContainerDatanodeProtocolProtos.PipelineReport report, DatanodeDetails dn) throws IOException {
        Pipeline pipeline;
        PipelineID pipelineID = PipelineID.getFromProtobuf((HddsProtos.PipelineID)report.getPipelineID());
        try {
            pipeline = this.pipelineManager.getPipeline(pipelineID);
        }
        catch (PipelineNotFoundException e) {
            RatisPipelineUtils.destroyPipeline(dn, pipelineID, this.conf, this.pipelineManager.getGrpcTlsConfig());
            return;
        }
        if (pipeline.getPipelineState() == Pipeline.PipelineState.ALLOCATED) {
            LOGGER.info("Pipeline {} reported by {}", (Object)pipeline.getId(), (Object)dn);
            pipeline.reportDatanode(dn);
            if (pipeline.isHealthy()) {
                this.pipelineManager.openPipeline(pipelineID);
            }
        } else {
            pipeline.reportDatanode(dn);
        }
    }
}

