/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node.states;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.node.states.Node2ObjectsMap;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;

public class Node2PipelineMap
extends Node2ObjectsMap<PipelineID> {
    public Set<PipelineID> getPipelines(UUID datanode) {
        return this.getObjects(datanode);
    }

    public synchronized void addPipeline(Pipeline pipeline) {
        for (DatanodeDetails details : pipeline.getNodes()) {
            UUID dnId = details.getUuid();
            this.dn2ObjectMap.computeIfAbsent(dnId, k -> ConcurrentHashMap.newKeySet()).add(pipeline.getId());
        }
    }

    public synchronized void removePipeline(Pipeline pipeline) {
        for (DatanodeDetails details : pipeline.getNodes()) {
            UUID dnId = details.getUuid();
            this.dn2ObjectMap.computeIfPresent(dnId, (k, v) -> {
                v.remove(pipeline.getId());
                return v;
            });
        }
    }
}

