/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ObjectName;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationActivityStatusMXBean;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.utils.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationActivityStatus
implements ReplicationActivityStatusMXBean,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationActivityStatus.class);
    private Scheduler scheduler;
    private AtomicBoolean replicationEnabled = new AtomicBoolean();
    private ObjectName jmxObjectName;

    public ReplicationActivityStatus(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public boolean isReplicationEnabled() {
        return this.replicationEnabled.get();
    }

    @Override
    @VisibleForTesting
    public void setReplicationEnabled(boolean enabled) {
        this.replicationEnabled.set(enabled);
    }

    @VisibleForTesting
    public void enableReplication() {
        this.replicationEnabled.set(true);
    }

    public void start() {
        try {
            this.jmxObjectName = MBeans.register((String)"StorageContainerManager", (String)"ReplicationActivityStatus", (Object)this);
        }
        catch (Exception ex) {
            LOG.error("JMX bean for ReplicationActivityStatus can't be registered", (Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.jmxObjectName != null) {
            MBeans.unregister((ObjectName)this.jmxObjectName);
        }
    }

    public void fireReplicationStart(boolean safeModeStatus, long waitTime) {
        if (!safeModeStatus) {
            this.scheduler.schedule(() -> {
                this.setReplicationEnabled(true);
                LOG.info("Replication Timer sleep for {} ms completed. Enable Replication", (Object)waitTime);
            }, waitTime, TimeUnit.MILLISECONDS);
        }
    }
}

