/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.metrics;

import org.apache.hadoop.hdds.scm.container.placement.metrics.ContainerStat;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(about="Storage Container Manager Metrics", context="dfs")
public class SCMMetrics {
    public static final String SOURCE_NAME = SCMMetrics.class.getSimpleName();
    @Metric
    private MutableGaugeLong lastContainerReportSize;
    @Metric
    private MutableGaugeLong lastContainerReportUsed;
    @Metric
    private MutableGaugeLong lastContainerReportKeyCount;
    @Metric
    private MutableGaugeLong lastContainerReportReadBytes;
    @Metric
    private MutableGaugeLong lastContainerReportWriteBytes;
    @Metric
    private MutableGaugeLong lastContainerReportReadCount;
    @Metric
    private MutableGaugeLong lastContainerReportWriteCount;
    @Metric
    private MutableCounterLong containerReportSize;
    @Metric
    private MutableCounterLong containerReportUsed;
    @Metric
    private MutableCounterLong containerReportKeyCount;
    @Metric
    private MutableCounterLong containerReportReadBytes;
    @Metric
    private MutableCounterLong containerReportWriteBytes;
    @Metric
    private MutableCounterLong containerReportReadCount;
    @Metric
    private MutableCounterLong containerReportWriteCount;

    public static SCMMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (SCMMetrics)ms.register(SOURCE_NAME, "Storage Container Manager Metrics", (Object)new SCMMetrics());
    }

    public void setLastContainerReportSize(long size) {
        this.lastContainerReportSize.set(size);
    }

    public void setLastContainerReportUsed(long used) {
        this.lastContainerReportUsed.set(used);
    }

    public void setLastContainerReportKeyCount(long keyCount) {
        this.lastContainerReportKeyCount.set(keyCount);
    }

    public void setLastContainerReportReadBytes(long readBytes) {
        this.lastContainerReportReadBytes.set(readBytes);
    }

    public void setLastContainerReportWriteBytes(long writeBytes) {
        this.lastContainerReportWriteBytes.set(writeBytes);
    }

    public void setLastContainerReportReadCount(long readCount) {
        this.lastContainerReportReadCount.set(readCount);
    }

    public void setLastContainerReportWriteCount(long writeCount) {
        this.lastContainerReportWriteCount.set(writeCount);
    }

    public void incrContainerReportSize(long size) {
        this.containerReportSize.incr(size);
    }

    public void incrContainerReportUsed(long used) {
        this.containerReportUsed.incr(used);
    }

    public void incrContainerReportKeyCount(long keyCount) {
        this.containerReportKeyCount.incr(keyCount);
    }

    public void incrContainerReportReadBytes(long readBytes) {
        this.containerReportReadBytes.incr(readBytes);
    }

    public void incrContainerReportWriteBytes(long writeBytes) {
        this.containerReportWriteBytes.incr(writeBytes);
    }

    public void incrContainerReportReadCount(long readCount) {
        this.containerReportReadCount.incr(readCount);
    }

    public void incrContainerReportWriteCount(long writeCount) {
        this.containerReportWriteCount.incr(writeCount);
    }

    public void setLastContainerStat(ContainerStat newStat) {
        this.lastContainerReportSize.set(newStat.getSize().get().longValue());
        this.lastContainerReportUsed.set(newStat.getUsed().get().longValue());
        this.lastContainerReportKeyCount.set(newStat.getKeyCount().get().longValue());
        this.lastContainerReportReadBytes.set(newStat.getReadBytes().get().longValue());
        this.lastContainerReportWriteBytes.set(newStat.getWriteBytes().get().longValue());
        this.lastContainerReportReadCount.set(newStat.getReadCount().get().longValue());
        this.lastContainerReportWriteCount.set(newStat.getWriteCount().get().longValue());
    }

    public void incrContainerStat(ContainerStat deltaStat) {
        this.containerReportSize.incr(deltaStat.getSize().get().longValue());
        this.containerReportUsed.incr(deltaStat.getUsed().get().longValue());
        this.containerReportKeyCount.incr(deltaStat.getKeyCount().get().longValue());
        this.containerReportReadBytes.incr(deltaStat.getReadBytes().get().longValue());
        this.containerReportWriteBytes.incr(deltaStat.getWriteBytes().get().longValue());
        this.containerReportReadCount.incr(deltaStat.getReadCount().get().longValue());
        this.containerReportWriteCount.incr(deltaStat.getWriteCount().get().longValue());
    }

    public void decrContainerStat(ContainerStat deltaStat) {
        this.containerReportSize.incr(-1L * deltaStat.getSize().get());
        this.containerReportUsed.incr(-1L * deltaStat.getUsed().get());
        this.containerReportKeyCount.incr(-1L * deltaStat.getKeyCount().get());
        this.containerReportReadBytes.incr(-1L * deltaStat.getReadBytes().get());
        this.containerReportWriteBytes.incr(-1L * deltaStat.getWriteBytes().get());
        this.containerReportReadCount.incr(-1L * deltaStat.getReadCount().get());
        this.containerReportWriteCount.incr(-1L * deltaStat.getWriteCount().get());
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

