/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
@Metrics(about="SCM PipelineManager Metrics", context="ozone")
public final class SCMPipelineMetrics {
    private static final String SOURCE_NAME = SCMPipelineMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numPipelineCreated;
    @Metric
    private MutableCounterLong numPipelineCreationFailed;
    @Metric
    private MutableCounterLong numPipelineDestroyed;
    @Metric
    private MutableCounterLong numPipelineDestroyFailed;
    @Metric
    private MutableCounterLong numPipelineReportProcessed;
    @Metric
    private MutableCounterLong numPipelineReportProcessingFailed;

    private SCMPipelineMetrics() {
    }

    public static SCMPipelineMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (SCMPipelineMetrics)ms.register(SOURCE_NAME, "SCM PipelineManager Metrics", (Object)new SCMPipelineMetrics());
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    void incNumPipelineCreated() {
        this.numPipelineCreated.incr();
    }

    void incNumPipelineCreationFailed() {
        this.numPipelineCreationFailed.incr();
    }

    void incNumPipelineDestroyed() {
        this.numPipelineDestroyed.incr();
    }

    void incNumPipelineDestroyFailed() {
        this.numPipelineDestroyFailed.incr();
    }

    void incNumPipelineReportProcessed() {
        this.numPipelineReportProcessed.incr();
    }

    void incNumPipelineReportProcessingFailed() {
        this.numPipelineReportProcessingFailed.incr();
    }
}

