/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.ratis.RatisHelper;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedBiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RatisPipelineUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RatisPipelineUtils.class);

    private RatisPipelineUtils() {
    }

    public static void createPipeline(Pipeline pipeline, Configuration ozoneConf) throws IOException {
        RaftGroup group = RatisHelper.newRaftGroup((Pipeline)pipeline);
        LOG.debug("creating pipeline:{} with {}", (Object)pipeline.getId(), (Object)group);
        RatisPipelineUtils.callRatisRpc(pipeline.getNodes(), ozoneConf, (CheckedBiConsumer<RaftClient, RaftPeer, IOException>)((CheckedBiConsumer)(raftClient, peer) -> {
            RaftClientReply reply = raftClient.groupAdd(group, peer.getId());
            if (reply == null || !reply.isSuccess()) {
                String msg = "Pipeline initialization failed for pipeline:" + pipeline.getId() + " node:" + peer.getId();
                LOG.error(msg);
                throw new IOException(msg);
            }
        }));
    }

    static void destroyPipeline(Pipeline pipeline, Configuration ozoneConf) {
        RaftGroup group = RatisHelper.newRaftGroup((Pipeline)pipeline);
        LOG.debug("destroying pipeline:{} with {}", (Object)pipeline.getId(), (Object)group);
        for (DatanodeDetails dn : pipeline.getNodes()) {
            try {
                RatisPipelineUtils.destroyPipeline(dn, pipeline.getId(), ozoneConf);
            }
            catch (IOException e) {
                LOG.warn("Pipeline destroy failed for pipeline={} dn={}", (Object)pipeline.getId(), (Object)dn);
            }
        }
    }

    static void destroyPipeline(DatanodeDetails dn, PipelineID pipelineID, Configuration ozoneConf) throws IOException {
        String rpcType = ozoneConf.get("dfs.container.ratis.rpc.type", "GRPC");
        RetryPolicy retryPolicy = RatisHelper.createRetryPolicy((Configuration)ozoneConf);
        RaftPeer p = RatisHelper.toRaftPeer((DatanodeDetails)dn);
        int maxOutstandingRequests = HddsClientUtils.getMaxOutstandingRequests((Configuration)ozoneConf);
        GrpcTlsConfig tlsConfig = RatisHelper.createTlsClientConfig((SecurityConfig)new SecurityConfig(ozoneConf));
        TimeDuration requestTimeout = RatisHelper.getClientRequestTimeout((Configuration)ozoneConf);
        RaftClient client = RatisHelper.newRaftClient((RpcType)SupportedRpcType.valueOfIgnoreCase((String)rpcType), (RaftPeer)p, (RetryPolicy)retryPolicy, (int)maxOutstandingRequests, (GrpcTlsConfig)tlsConfig, (TimeDuration)requestTimeout);
        client.groupRemove(RaftGroupId.valueOf((UUID)pipelineID.getId()), true, p.getId());
    }

    private static void callRatisRpc(List<DatanodeDetails> datanodes, Configuration ozoneConf, CheckedBiConsumer<RaftClient, RaftPeer, IOException> rpc) throws IOException {
        if (datanodes.isEmpty()) {
            return;
        }
        String rpcType = ozoneConf.get("dfs.container.ratis.rpc.type", "GRPC");
        RetryPolicy retryPolicy = RatisHelper.createRetryPolicy((Configuration)ozoneConf);
        List exceptions = Collections.synchronizedList(new ArrayList());
        int maxOutstandingRequests = HddsClientUtils.getMaxOutstandingRequests((Configuration)ozoneConf);
        GrpcTlsConfig tlsConfig = RatisHelper.createTlsClientConfig((SecurityConfig)new SecurityConfig(ozoneConf));
        TimeDuration requestTimeout = RatisHelper.getClientRequestTimeout((Configuration)ozoneConf);
        datanodes.parallelStream().forEach(d -> {
            RaftPeer p = RatisHelper.toRaftPeer((DatanodeDetails)d);
            try (RaftClient client = RatisHelper.newRaftClient((RpcType)SupportedRpcType.valueOfIgnoreCase((String)rpcType), (RaftPeer)p, (RetryPolicy)retryPolicy, (int)maxOutstandingRequests, (GrpcTlsConfig)tlsConfig, (TimeDuration)requestTimeout);){
                rpc.accept((Object)client, (Object)p);
            }
            catch (IOException ioe) {
                String errMsg = "Failed invoke Ratis rpc " + rpc + " for " + d.getUuid();
                LOG.error(errMsg, (Throwable)ioe);
                exceptions.add(new IOException(errMsg, ioe));
            }
        });
        if (!exceptions.isEmpty()) {
            throw MultipleIOException.createIOException(exceptions);
        }
    }
}

