/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
@Metrics(about="SCM NodeManager Metrics", context="ozone")
public final class SCMNodeMetrics {
    private static final String SOURCE_NAME = SCMNodeMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numHBProcessed;
    @Metric
    private MutableCounterLong numHBProcessingFailed;
    @Metric
    private MutableCounterLong numNodeReportProcessed;
    @Metric
    private MutableCounterLong numNodeReportProcessingFailed;

    private SCMNodeMetrics() {
    }

    public static SCMNodeMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (SCMNodeMetrics)ms.register(SOURCE_NAME, "SCM NodeManager Metrics", (Object)new SCMNodeMetrics());
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    void incNumHBProcessed() {
        this.numHBProcessed.incr();
    }

    void incNumHBProcessingFailed() {
        this.numHBProcessingFailed.incr();
    }

    void incNumNodeReportProcessed() {
        this.numNodeReportProcessed.incr();
    }

    void incNumNodeReportProcessingFailed() {
        this.numNodeReportProcessingFailed.incr();
    }
}

