/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.NodeReportFromDatanode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeReportHandler.class);
    private final NodeManager nodeManager;

    public NodeReportHandler(NodeManager nodeManager) {
        Preconditions.checkNotNull((Object)nodeManager);
        this.nodeManager = nodeManager;
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.NodeReportFromDatanode nodeReportFromDatanode, EventPublisher publisher) {
        Preconditions.checkNotNull((Object)nodeReportFromDatanode);
        DatanodeDetails dn = nodeReportFromDatanode.getDatanodeDetails();
        Preconditions.checkNotNull((Object)dn, (Object)"NodeReport is missing DatanodeDetails.");
        LOGGER.trace("Processing node report for dn: {}", (Object)dn);
        this.nodeManager.processNodeReport(dn, (StorageContainerDatanodeProtocolProtos.NodeReportProto)nodeReportFromDatanode.getReport());
    }
}

