/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.util.Set;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerException;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationRequest;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadNodeHandler
implements EventHandler<DatanodeDetails> {
    private final ContainerManager containerManager;
    private final NodeManager nodeManager;
    private static final Logger LOG = LoggerFactory.getLogger(DeadNodeHandler.class);

    public DeadNodeHandler(NodeManager nodeManager, ContainerManager containerManager) {
        this.containerManager = containerManager;
        this.nodeManager = nodeManager;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher publisher) {
        Set<ContainerID> ids = null;
        try {
            ids = this.nodeManager.getContainers(datanodeDetails);
        }
        catch (NodeNotFoundException e) {
            LOG.error("DeadNode event for a unregistered node: {}!", (Object)datanodeDetails);
        }
        if (ids == null) {
            LOG.info("There's no containers in dead datanode {}, no replica will be removed from the in-memory state.", (Object)datanodeDetails.getUuid());
            return;
        }
        LOG.info("Datanode {}  is dead. Removing replications from the in-memory state.", (Object)datanodeDetails.getUuid());
        for (ContainerID id : ids) {
            try {
                ContainerInfo container = this.containerManager.getContainer(id);
                if (container.isOpen()) continue;
                Set<ContainerReplica> replicas = this.containerManager.getContainerReplicas(id);
                replicas.stream().filter(r -> r.getDatanodeDetails().equals((Object)datanodeDetails)).findFirst().ifPresent(replica -> {
                    try {
                        this.containerManager.removeContainerReplica(id, (ContainerReplica)replica);
                        ContainerInfo containerInfo = this.containerManager.getContainer(id);
                        this.replicateIfNeeded(containerInfo, publisher);
                    }
                    catch (ContainerException ex) {
                        LOG.warn("Exception while removing container replica #{} for container #{}.", new Object[]{replica, container, ex});
                    }
                });
            }
            catch (ContainerNotFoundException cnfe) {
                LOG.warn("Container Not found!", (Throwable)cnfe);
            }
        }
    }

    private void replicateIfNeeded(ContainerInfo container, EventPublisher publisher) throws ContainerNotFoundException {
        int expectedReplicas;
        int existingReplicas;
        if ((container.getState() == HddsProtos.LifeCycleState.CLOSED || container.getState() == HddsProtos.LifeCycleState.QUASI_CLOSED) && (existingReplicas = this.containerManager.getContainerReplicas(container.containerID()).size()) != (expectedReplicas = container.getReplicationFactor().getNumber())) {
            LOG.debug("Replicate Request fired for container {}, exisiting replica count {}, expected replica count {}", new Object[]{container.getContainerID(), existingReplicas, expectedReplicas});
            publisher.fireEvent(SCMEvents.REPLICATE_CONTAINER, (Object)new ReplicationRequest(container.getContainerID(), existingReplicas, expectedReplicas));
        }
    }

    public static Logger getLogger() {
        return LOG;
    }
}

