/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.metadata;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.utils.db.Codec;

public class X509CertificateCodec
implements Codec<X509Certificate> {
    public byte[] toPersistedFormat(X509Certificate object) throws IOException {
        try {
            return CertificateCodec.getPEMEncodedString((X509Certificate)object).getBytes(Charset.forName("UTF-8"));
        }
        catch (SCMSecurityException exp) {
            throw new IOException(exp);
        }
    }

    public X509Certificate fromPersistedFormat(byte[] rawData) throws IOException {
        try {
            String s = new String(rawData, Charset.forName("UTF-8"));
            return CertificateCodec.getX509Certificate((String)s);
        }
        catch (CertificateException exp) {
            throw new IOException(exp);
        }
    }
}

