/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicy;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SCMCommonPolicy
implements ContainerPlacementPolicy {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(SCMCommonPolicy.class);
    private final NodeManager nodeManager;
    private final Random rand;
    private final Configuration conf;

    public SCMCommonPolicy(NodeManager nodeManager, Configuration conf) {
        this.nodeManager = nodeManager;
        this.rand = new Random();
        this.conf = conf;
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public Random getRand() {
        return this.rand;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public List<DatanodeDetails> chooseDatanodes(List<DatanodeDetails> excludedNodes, int nodesRequired, long sizeRequired) throws SCMException {
        List<DatanodeDetails> healthyNodes = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY);
        healthyNodes.removeAll(excludedNodes);
        if (healthyNodes.size() == 0) {
            String msg = "No healthy node found to allocate container.";
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_HEALTHY_NODES);
        }
        if (healthyNodes.size() < nodesRequired) {
            String msg = String.format("Not enough healthy nodes to allocate container. %d  datanodes required. Found %d", nodesRequired, healthyNodes.size());
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        List<DatanodeDetails> healthyList = healthyNodes.stream().filter(d -> this.hasEnoughSpace((DatanodeDetails)d, sizeRequired)).collect(Collectors.toList());
        if (healthyList.size() < nodesRequired) {
            String msg = String.format("Unable to find enough nodes that meet the space requirement of %d bytes in healthy node set. Nodes required: %d Found: %d", sizeRequired, nodesRequired, healthyList.size());
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_NODES_WITH_SPACE);
        }
        return healthyList;
    }

    private boolean hasEnoughSpace(DatanodeDetails datanodeDetails, long sizeRequired) {
        SCMNodeMetric nodeMetric = this.nodeManager.getNodeStat(datanodeDetails);
        return nodeMetric != null && nodeMetric.get() != null && nodeMetric.get().getRemaining().hasResources(sizeRequired);
    }

    public List<DatanodeDetails> getResultSet(int nodesRequired, List<DatanodeDetails> healthyNodes) throws SCMException {
        ArrayList<DatanodeDetails> results = new ArrayList<DatanodeDetails>();
        for (int x = 0; x < nodesRequired; ++x) {
            DatanodeDetails nodeId = this.chooseNode(healthyNodes);
            if (nodeId == null) continue;
            results.add(nodeId);
        }
        if (results.size() < nodesRequired) {
            LOG.error("Unable to find the required number of healthy nodes that meet the criteria. Required nodes: {}, Found nodes: {}", (Object)nodesRequired, (Object)results.size());
            throw new SCMException("Unable to find required number of nodes.", SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        return results;
    }

    public abstract DatanodeDetails chooseNode(List<DatanodeDetails> var1);
}

