/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ReportHandlerHelper;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalContainerReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalContainerReportHandler.class);
    private final PipelineManager pipelineManager;
    private final ContainerManager containerManager;

    public IncrementalContainerReportHandler(PipelineManager pipelineManager, ContainerManager containerManager) {
        Preconditions.checkNotNull((Object)pipelineManager);
        Preconditions.checkNotNull((Object)containerManager);
        this.pipelineManager = pipelineManager;
        this.containerManager = containerManager;
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode containerReportFromDatanode, EventPublisher publisher) {
        for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto : ((StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto)containerReportFromDatanode.getReport()).getReportList()) {
            try {
                DatanodeDetails datanodeDetails = containerReportFromDatanode.getDatanodeDetails();
                ContainerID containerID = ContainerID.valueof((long)replicaProto.getContainerID());
                ReportHandlerHelper.processContainerReplica(this.containerManager, containerID, replicaProto, datanodeDetails, publisher, LOG);
            }
            catch (ContainerNotFoundException e) {
                LOG.warn("Container {} not found!", (Object)replicaProto.getContainerID());
            }
            catch (IOException e) {
                LOG.error("Exception while processing ICR for container {}", (Object)replicaProto.getContainerID());
            }
        }
    }
}

