/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.chillmode;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.chillmode.ChillModeExitRule;
import org.apache.hadoop.hdds.scm.chillmode.SCMChillModeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneReplicaPipelineChillModeRule
implements ChillModeExitRule<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode>,
EventHandler<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(OneReplicaPipelineChillModeRule.class);
    private int thresholdCount;
    private Set<PipelineID> reportedPipelineIDSet = new HashSet<PipelineID>();
    private final PipelineManager pipelineManager;
    private final SCMChillModeManager chillModeManager;

    public OneReplicaPipelineChillModeRule(PipelineManager pipelineManager, SCMChillModeManager chillModeManager, Configuration configuration) {
        this.chillModeManager = chillModeManager;
        this.pipelineManager = pipelineManager;
        double percent = configuration.getDouble("hdds.scm.chillmode.atleast.one.node.reported.pipeline.pct", 0.9);
        int totalPipelineCount = pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE).size();
        this.thresholdCount = (int)Math.ceil(percent * (double)totalPipelineCount);
        LOG.info(" Total pipeline count is {}, pipeline's with atleast one datanode reported threshold count is {}", (Object)totalPipelineCount, (Object)this.thresholdCount);
    }

    @Override
    public boolean validate() {
        return this.reportedPipelineIDSet.size() >= this.thresholdCount;
    }

    @Override
    public void process(SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode pipelineReportFromDatanode) {
        Preconditions.checkNotNull((Object)pipelineReportFromDatanode);
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReport = (StorageContainerDatanodeProtocolProtos.PipelineReportsProto)pipelineReportFromDatanode.getReport();
        for (StorageContainerDatanodeProtocolProtos.PipelineReport report : pipelineReport.getPipelineReportList()) {
            Pipeline pipeline;
            PipelineID pipelineID = PipelineID.getFromProtobuf((HddsProtos.PipelineID)report.getPipelineID());
            try {
                pipeline = this.pipelineManager.getPipeline(pipelineID);
            }
            catch (PipelineNotFoundException e) {
                continue;
            }
            if (pipeline.getFactor() != HddsProtos.ReplicationFactor.THREE || this.reportedPipelineIDSet.contains(pipelineID)) continue;
            this.reportedPipelineIDSet.add(pipelineID);
        }
    }

    @Override
    public void cleanup() {
        this.reportedPipelineIDSet.clear();
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode pipelineReportFromDatanode, EventPublisher publisher) {
        if (this.validate()) {
            this.chillModeManager.validateChillModeExitRules(publisher);
            return;
        }
        this.process(pipelineReportFromDatanode);
        if (this.chillModeManager.getInChillMode()) {
            SCMChillModeManager.getLogger().info("SCM in chill mode. Pipelines with atleast one datanode reported count is {}, required atleast one datanode reported per pipeline count is {}", (Object)this.reportedPipelineIDSet.size(), (Object)this.thresholdCount);
        }
        if (this.validate()) {
            this.chillModeManager.validateChillModeExitRules(publisher);
        }
    }
}

