/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.chillmode;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.scm.chillmode.ChillModeExitRule;
import org.apache.hadoop.hdds.scm.chillmode.SCMChillModeManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeProtocolServer;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;

public class DataNodeChillModeRule
implements ChillModeExitRule<SCMDatanodeProtocolServer.NodeRegistrationContainerReport>,
EventHandler<SCMDatanodeProtocolServer.NodeRegistrationContainerReport> {
    private int requiredDns;
    private int registeredDns = 0;
    private HashSet<UUID> registeredDnSet;
    private final SCMChillModeManager chillModeManager;

    public DataNodeChillModeRule(Configuration conf, SCMChillModeManager manager) {
        this.requiredDns = conf.getInt("hdds.scm.chillmode.min.datanode", 1);
        this.registeredDnSet = new HashSet(this.requiredDns * 2);
        this.chillModeManager = manager;
    }

    @Override
    public boolean validate() {
        return this.registeredDns >= this.requiredDns;
    }

    @VisibleForTesting
    public double getRegisteredDataNodes() {
        return this.registeredDns;
    }

    @Override
    public void process(SCMDatanodeProtocolServer.NodeRegistrationContainerReport reportsProto) {
        this.registeredDnSet.add(reportsProto.getDatanodeDetails().getUuid());
        this.registeredDns = this.registeredDnSet.size();
    }

    public void onMessage(SCMDatanodeProtocolServer.NodeRegistrationContainerReport nodeRegistrationContainerReport, EventPublisher publisher) {
        if (this.chillModeManager.getInChillMode()) {
            if (this.validate()) {
                return;
            }
            this.process(nodeRegistrationContainerReport);
            if (this.chillModeManager.getInChillMode()) {
                SCMChillModeManager.getLogger().info("SCM in chill mode. {} DataNodes registered, {} required.", (Object)this.registeredDns, (Object)this.requiredDns);
            }
            if (this.validate()) {
                this.chillModeManager.validateChillModeExitRules(publisher);
            }
        }
    }

    @Override
    public void cleanup() {
        this.registeredDnSet.clear();
    }
}

