/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.chillmode;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.chillmode.ChillModeExitRule;
import org.apache.hadoop.hdds.scm.chillmode.SCMChillModeManager;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeProtocolServer;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;

public class ContainerChillModeRule
implements ChillModeExitRule<SCMDatanodeProtocolServer.NodeRegistrationContainerReport>,
EventHandler<SCMDatanodeProtocolServer.NodeRegistrationContainerReport> {
    private double chillModeCutoff;
    private Map<Long, ContainerInfo> containerMap;
    private double maxContainer;
    private AtomicLong containerWithMinReplicas = new AtomicLong(0L);
    private final SCMChillModeManager chillModeManager;

    public ContainerChillModeRule(Configuration conf, List<ContainerInfo> containers, SCMChillModeManager manager) {
        this.chillModeCutoff = conf.getDouble("hdds.scm.chillmode.threshold.pct", 0.99);
        this.chillModeManager = manager;
        this.containerMap = new ConcurrentHashMap<Long, ContainerInfo>();
        if (containers != null) {
            containers.forEach(c -> {
                if (c != null && c.getState() != null && !c.getState().equals((Object)HddsProtos.LifeCycleState.OPEN)) {
                    this.containerMap.put(c.getContainerID(), (ContainerInfo)c);
                }
            });
            this.maxContainer = this.containerMap.size();
        }
    }

    @Override
    public boolean validate() {
        return this.getCurrentContainerThreshold() >= this.chillModeCutoff;
    }

    @VisibleForTesting
    public double getCurrentContainerThreshold() {
        if (this.maxContainer == 0.0) {
            return 1.0;
        }
        return this.containerWithMinReplicas.doubleValue() / this.maxContainer;
    }

    @Override
    public void process(SCMDatanodeProtocolServer.NodeRegistrationContainerReport reportsProto) {
        ((StorageContainerDatanodeProtocolProtos.ContainerReportsProto)reportsProto.getReport()).getReportsList().forEach(c -> {
            if (this.containerMap.containsKey(c.getContainerID()) && this.containerMap.remove(c.getContainerID()) != null) {
                this.containerWithMinReplicas.getAndAdd(1L);
            }
        });
    }

    public void onMessage(SCMDatanodeProtocolServer.NodeRegistrationContainerReport nodeRegistrationContainerReport, EventPublisher publisher) {
        if (this.chillModeManager.getInChillMode()) {
            if (this.validate()) {
                return;
            }
            this.process(nodeRegistrationContainerReport);
            if (this.chillModeManager.getInChillMode()) {
                SCMChillModeManager.getLogger().info("SCM in chill mode. {} % containers have at least one reported replica.", (Object)((double)this.containerWithMinReplicas.get() / this.maxContainer * 100.0));
            }
            if (this.validate()) {
                this.chillModeManager.validateChillModeExitRules(publisher);
            }
        }
    }

    @Override
    public void cleanup() {
        this.containerMap.clear();
    }
}

