/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.chillmode;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.chillmode.ChillModeRestrictedOps;
import org.apache.hadoop.hdds.scm.chillmode.Precheck;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;

public class ChillModePrecheck
implements Precheck<HddsProtos.ScmOps> {
    private AtomicBoolean inChillMode;
    public static final String PRECHECK_TYPE = "ChillModePrecheck";

    public ChillModePrecheck(Configuration conf) {
        boolean chillModeEnabled = conf.getBoolean("hdds.scm.chillmode.enabled", true);
        this.inChillMode = chillModeEnabled ? new AtomicBoolean(true) : new AtomicBoolean(false);
    }

    @Override
    public boolean check(HddsProtos.ScmOps op) throws SCMException {
        if (this.inChillMode.get() && ChillModeRestrictedOps.isRestrictedInChillMode(op)) {
            throw new SCMException("ChillModePrecheck failed for " + op, SCMException.ResultCodes.CHILL_MODE_EXCEPTION);
        }
        return this.inChillMode.get();
    }

    @Override
    public String type() {
        return PRECHECK_TYPE;
    }

    public boolean isInChillMode() {
        return this.inChillMode.get();
    }

    public void setInChillMode(boolean inChillMode) {
        this.inChillMode.set(inChillMode);
    }
}

