/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.block.DatanodeDeletedBlockTransactions;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.block.PendingDeleteStatusList;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlocksCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.BackgroundService;
import org.apache.hadoop.utils.BackgroundTask;
import org.apache.hadoop.utils.BackgroundTaskQueue;
import org.apache.hadoop.utils.BackgroundTaskResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMBlockDeletingService
extends BackgroundService {
    public static final Logger LOG = LoggerFactory.getLogger(SCMBlockDeletingService.class);
    private static final int BLOCK_DELETING_SERVICE_CORE_POOL_SIZE = 2;
    private final DeletedBlockLog deletedBlockLog;
    private final ContainerManager containerManager;
    private final NodeManager nodeManager;
    private final EventPublisher eventPublisher;
    private int blockDeleteLimitSize;

    public SCMBlockDeletingService(DeletedBlockLog deletedBlockLog, ContainerManager containerManager, NodeManager nodeManager, EventPublisher eventPublisher, long interval, long serviceTimeout, Configuration conf) {
        super("SCMBlockDeletingService", interval, TimeUnit.MILLISECONDS, 2, serviceTimeout);
        this.deletedBlockLog = deletedBlockLog;
        this.containerManager = containerManager;
        this.nodeManager = nodeManager;
        this.eventPublisher = eventPublisher;
        int containerLimit = conf.getInt("ozone.block.deleting.container.limit.per.interval", 10);
        Preconditions.checkArgument((containerLimit > 0 ? 1 : 0) != 0, (Object)"Container limit size should be positive.");
        this.blockDeleteLimitSize = containerLimit * 2;
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new DeletedBlockTransactionScanner());
        return queue;
    }

    public void handlePendingDeletes(PendingDeleteStatusList deletionStatusList) {
        DatanodeDetails dnDetails = deletionStatusList.getDatanodeDetails();
        for (PendingDeleteStatusList.PendingDeleteStatus deletionStatus : deletionStatusList.getPendingDeleteStatuses()) {
            LOG.info("Block deletion txnID mismatch in datanode {} for containerID {}. Datanode delete txnID: {}, SCM txnID: {}", new Object[]{dnDetails.getUuid(), deletionStatus.getContainerId(), deletionStatus.getDnDeleteTransactionId(), deletionStatus.getScmDeleteTransactionId()});
        }
    }

    @VisibleForTesting
    public void setBlockDeleteTXNum(int numTXs) {
        this.blockDeleteLimitSize = numTXs;
    }

    private class DeletedBlockTransactionScanner
    implements BackgroundTask<BackgroundTaskResult.EmptyTaskResult> {
        private DeletedBlockTransactionScanner() {
        }

        public int getPriority() {
            return 1;
        }

        public BackgroundTaskResult.EmptyTaskResult call() throws Exception {
            int dnTxCount = 0;
            long startTime = Time.monotonicNow();
            LOG.debug("Running DeletedBlockTransactionScanner");
            DatanodeDeletedBlockTransactions transactions = null;
            List<DatanodeDetails> datanodes = SCMBlockDeletingService.this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY);
            Map<Long, Long> transactionMap = null;
            if (datanodes != null) {
                transactions = new DatanodeDeletedBlockTransactions(SCMBlockDeletingService.this.containerManager, SCMBlockDeletingService.this.blockDeleteLimitSize, datanodes.size());
                try {
                    transactionMap = SCMBlockDeletingService.this.deletedBlockLog.getTransactions(transactions);
                }
                catch (IOException e) {
                    LOG.error("Failed to get block deletion transactions from delTX log", (Throwable)e);
                }
                LOG.debug("Scanned deleted blocks log and got {} delTX to process.", (Object)transactions.getTXNum());
            }
            if (transactions != null && !transactions.isEmpty()) {
                for (UUID dnId : transactions.getDatanodeIDs()) {
                    List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> dnTXs = transactions.getDatanodeTransactions(dnId);
                    if (dnTXs == null || dnTXs.isEmpty()) continue;
                    dnTxCount += dnTXs.size();
                    SCMBlockDeletingService.this.eventPublisher.fireEvent(SCMEvents.RETRIABLE_DATANODE_COMMAND, (Object)new CommandForDatanode(dnId, (SCMCommand)new DeleteBlocksCommand(dnTXs)));
                    LOG.debug("Added delete block command for datanode {} in the queue, number of delete block transactions: {}, TxID list: {}", new Object[]{dnId, dnTXs.size(), String.join((CharSequence)",", transactions.getTransactionIDList(dnId))});
                }
                SCMBlockDeletingService.this.containerManager.updateDeleteTransactionId(transactionMap);
            }
            if (dnTxCount > 0) {
                LOG.info("Totally added {} delete blocks command for {} datanodes, task elapsed time: {}ms", new Object[]{dnTxCount, transactions.getDatanodeIDs().size(), Time.monotonicNow() - startTime});
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

