/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.block.BlockManager;
import org.apache.hadoop.hdds.scm.block.BlockmanagerMXBean;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogImpl;
import org.apache.hadoop.hdds.scm.block.SCMBlockDeletingService;
import org.apache.hadoop.hdds.scm.chillmode.ChillModePrecheck;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockManagerImpl
implements EventHandler<Boolean>,
BlockManager,
BlockmanagerMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(BlockManagerImpl.class);
    private final PipelineManager pipelineManager;
    private final ContainerManager containerManager;
    private final long containerSize;
    private final DeletedBlockLog deletedBlockLog;
    private final SCMBlockDeletingService blockDeletingService;
    private ObjectName mxBean;
    private ChillModePrecheck chillModePrecheck;

    public BlockManagerImpl(Configuration conf, StorageContainerManager scm) {
        Objects.requireNonNull(scm, "SCM cannot be null");
        this.pipelineManager = scm.getPipelineManager();
        this.containerManager = scm.getContainerManager();
        this.containerSize = (long)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        this.mxBean = MBeans.register((String)"BlockManager", (String)"BlockManagerImpl", (Object)this);
        this.deletedBlockLog = new DeletedBlockLogImpl(conf, scm.getContainerManager(), scm.getScmMetadataStore());
        long svcInterval = conf.getTimeDuration("ozone.block.deleting.service.interval", "60s", TimeUnit.MILLISECONDS);
        long serviceTimeout = conf.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
        this.blockDeletingService = new SCMBlockDeletingService(this.deletedBlockLog, this.containerManager, scm.getScmNodeManager(), scm.getEventQueue(), svcInterval, serviceTimeout, conf);
        this.chillModePrecheck = new ChillModePrecheck(conf);
    }

    @Override
    public void start() throws IOException {
        this.blockDeletingService.start();
    }

    @Override
    public void stop() throws IOException {
        this.blockDeletingService.shutdown();
        this.close();
    }

    @Override
    public AllocatedBlock allocateBlock(long size, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner, ExcludeList excludeList) throws IOException {
        block5: {
            Pipeline pipeline;
            ContainerInfo containerInfo;
            LOG.trace("Size;{} , type : {}, factor : {} ", new Object[]{size, type, factor});
            ScmUtils.preCheck(HddsProtos.ScmOps.allocateBlock, this.chillModePrecheck);
            if (size < 0L || size > this.containerSize) {
                LOG.warn("Invalid block size requested : {}", (Object)size);
                throw new SCMException("Unsupported block size: " + size, SCMException.ResultCodes.INVALID_BLOCK_SIZE);
            }
            do {
                List<Pipeline> availablePipelines;
                if ((availablePipelines = this.pipelineManager.getPipelines(type, factor, Pipeline.PipelineState.OPEN, excludeList.getDatanodes(), excludeList.getPipelineIds())).size() == 0) {
                    try {
                        pipeline = this.pipelineManager.createPipeline(type, factor);
                        continue;
                    }
                    catch (IOException e) {
                        break block5;
                    }
                }
                pipeline = availablePipelines.get((int)(Math.random() * (double)availablePipelines.size()));
            } while ((containerInfo = this.containerManager.getMatchingContainer(size, owner, pipeline, excludeList.getContainerIds())) == null);
            return this.newBlock(containerInfo);
        }
        LOG.error("Unable to allocate a block for the size: {}, type: {}, factor: {}", new Object[]{size, type, factor});
        return null;
    }

    private AllocatedBlock newBlock(ContainerInfo containerInfo) {
        try {
            Pipeline pipeline = this.pipelineManager.getPipeline(containerInfo.getPipelineID());
            long localID = UniqueId.next();
            long containerID = containerInfo.getContainerID();
            AllocatedBlock.Builder abb = new AllocatedBlock.Builder().setContainerBlockID(new ContainerBlockID(containerID, localID)).setPipeline(pipeline);
            LOG.trace("New block allocated : {} Container ID: {}", (Object)localID, (Object)containerID);
            return abb.build();
        }
        catch (PipelineNotFoundException ex) {
            LOG.error("Pipeline Machine count is zero.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void deleteBlocks(List<BlockID> blockIDs) throws IOException {
        ScmUtils.preCheck(HddsProtos.ScmOps.deleteBlock, this.chillModePrecheck);
        LOG.info("Deleting blocks {}", (Object)StringUtils.join((CharSequence)",", blockIDs));
        HashMap<Long, List<Long>> containerBlocks = new HashMap<Long, List<Long>>();
        for (BlockID block : blockIDs) {
            long containerID = block.getContainerID();
            if (containerBlocks.containsKey(containerID)) {
                ((List)containerBlocks.get(containerID)).add(block.getLocalID());
                continue;
            }
            ArrayList<Long> item = new ArrayList<Long>();
            item.add(block.getLocalID());
            containerBlocks.put(containerID, item);
        }
        try {
            this.deletedBlockLog.addTransactions(containerBlocks);
        }
        catch (IOException e) {
            throw new IOException("Skip writing the deleted blocks info to the delLog because addTransaction fails. Batch skipped: " + StringUtils.join((CharSequence)",", blockIDs), e);
        }
    }

    @Override
    public DeletedBlockLog getDeletedBlockLog() {
        return this.deletedBlockLog;
    }

    @Override
    public void close() throws IOException {
        if (this.deletedBlockLog != null) {
            this.deletedBlockLog.close();
        }
        this.blockDeletingService.shutdown();
        if (this.mxBean != null) {
            MBeans.unregister((ObjectName)this.mxBean);
            this.mxBean = null;
        }
    }

    @Override
    public int getOpenContainersNo() {
        return 0;
    }

    @Override
    public SCMBlockDeletingService getSCMBlockDeletingService() {
        return this.blockDeletingService;
    }

    public void onMessage(Boolean inChillMode, EventPublisher publisher) {
        this.chillModePrecheck.setInChillMode(inChillMode);
    }

    public boolean isScmInChillMode() {
        return this.chillModePrecheck.isInChillMode();
    }

    public static Logger getLogger() {
        return LOG;
    }

    public static final class UniqueId {
        private static volatile short offset = 0;

        private UniqueId() {
        }

        public static synchronized long next() {
            long utcTime = HddsUtils.getUtcTime();
            if ((utcTime & 0xFFFF000000000000L) == 0L) {
                short s = offset;
                offset = (short)(s + 1);
                return utcTime << 16 | (long)(s & 0xFFFF);
            }
            throw new RuntimeException("Got invalid UTC time, cannot generate unique Id. UTC Time: " + utcTime);
        }
    }
}

