/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.utils.db.ByteArrayKeyValue;
import org.apache.hadoop.hdds.utils.db.RDBTable;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBStoreIterator
implements TableIterator<byte[], ByteArrayKeyValue> {
    private static final Logger LOG = LoggerFactory.getLogger(RDBStoreIterator.class);
    private RocksIterator rocksDBIterator;
    private RDBTable rocksDBTable;
    private ByteArrayKeyValue currentEntry;

    public RDBStoreIterator(RocksIterator iterator) {
        this.rocksDBIterator = iterator;
        this.seekToFirst();
    }

    public RDBStoreIterator(RocksIterator iterator, RDBTable table) {
        this(iterator);
        this.rocksDBTable = table;
    }

    @Override
    public void forEachRemaining(Consumer<? super ByteArrayKeyValue> action) {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    private void setCurrentEntry() {
        this.currentEntry = this.rocksDBIterator.isValid() ? ByteArrayKeyValue.create(this.rocksDBIterator.key(), this.rocksDBIterator.value()) : null;
    }

    @Override
    public boolean hasNext() {
        return this.rocksDBIterator.isValid();
    }

    @Override
    public ByteArrayKeyValue next() {
        this.setCurrentEntry();
        if (this.currentEntry != null) {
            this.rocksDBIterator.next();
            return this.currentEntry;
        }
        throw new NoSuchElementException("RocksDB Store has no more elements");
    }

    @Override
    public void seekToFirst() {
        this.rocksDBIterator.seekToFirst();
        this.setCurrentEntry();
    }

    @Override
    public void seekToLast() {
        this.rocksDBIterator.seekToLast();
        this.setCurrentEntry();
    }

    @Override
    public ByteArrayKeyValue seek(byte[] key) {
        this.rocksDBIterator.seek(key);
        this.setCurrentEntry();
        return this.currentEntry;
    }

    @Override
    public byte[] key() {
        if (this.rocksDBIterator.isValid()) {
            return this.rocksDBIterator.key();
        }
        return null;
    }

    @Override
    public ByteArrayKeyValue value() {
        if (this.rocksDBIterator.isValid()) {
            return ByteArrayKeyValue.create(this.rocksDBIterator.key(), this.rocksDBIterator.value());
        }
        return null;
    }

    @Override
    public void removeFromDB() throws IOException {
        if (this.rocksDBTable == null) {
            throw new UnsupportedOperationException("remove");
        }
        if (this.currentEntry != null) {
            this.rocksDBTable.delete(this.currentEntry.getKey());
        } else {
            LOG.info("Unable to delete currentEntry as it does not exist.");
        }
    }

    @Override
    public void close() throws IOException {
        this.rocksDBIterator.close();
    }
}

