/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.crl;

import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.util.Comparator;
import java.util.Objects;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CRLCodec;
import org.jetbrains.annotations.NotNull;

public class CRLInfo
implements Comparator<CRLInfo>,
Comparable<CRLInfo> {
    private X509CRL x509CRL;
    private long creationTimestamp;

    private CRLInfo(X509CRL x509CRL, long creationTimestamp) {
        this.x509CRL = x509CRL;
        this.creationTimestamp = creationTimestamp;
    }

    public CRLInfo() {
    }

    public static CRLInfo fromProtobuf(HddsProtos.CRLInfoProto info) throws IOException, CRLException, CertificateException {
        Builder builder = new Builder();
        return builder.setX509CRL(CRLCodec.getX509CRL(info.getX509CRL())).setCreationTimestamp(info.getCreationTimestamp()).build();
    }

    public HddsProtos.CRLInfoProto getProtobuf() throws SCMSecurityException {
        HddsProtos.CRLInfoProto.Builder builder = HddsProtos.CRLInfoProto.newBuilder();
        return builder.setX509CRL(CRLCodec.getPEMEncodedString(this.getX509CRL())).setCreationTimestamp(this.getCreationTimestamp()).build();
    }

    public X509CRL getX509CRL() {
        return this.x509CRL;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public int compareTo(@NotNull CRLInfo o) {
        return this.compare(this, o);
    }

    @Override
    public int compare(CRLInfo o1, CRLInfo o2) {
        return Long.compare(o1.getCreationTimestamp(), o2.getCreationTimestamp());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CRLInfo that = (CRLInfo)o;
        return this.getX509CRL().equals(that.x509CRL) && this.creationTimestamp == that.creationTimestamp;
    }

    public int hashCode() {
        return Objects.hash(this.getX509CRL(), this.getCreationTimestamp());
    }

    public String toString() {
        return "CRLInfo{x509CRL=" + this.x509CRL.toString() + ", creationTimestamp=" + this.creationTimestamp + '}';
    }

    public static class Builder {
        private X509CRL x509CRL;
        private long creationTimestamp;

        public Builder setX509CRL(X509CRL x509CRL) {
            this.x509CRL = x509CRL;
            return this;
        }

        public Builder setCreationTimestamp(long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public CRLInfo build() {
            return new CRLInfo(this.x509CRL, this.creationTimestamp);
        }
    }
}

