/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="hdds.ratis.raft.grpc")
public class DatanodeRatisGrpcConfig {
    @Config(key="message.size.max", defaultValue="32MB", type=ConfigType.INT, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Maximum message size allowed to be received by Grpc Channel (Server).")
    private int maximumMessageSize = 0x2000000;
    @Config(key="flow.control.window", defaultValue="5MB", type=ConfigType.INT, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="This parameter tells how much data grpc client can send to grpc server with out receiving any ack(WINDOW_UPDATE) packet from server. This parameter should be set in accordance with chunk size. Example: If Chunk size is 4MB, considering some header size in to consideration, this can be set 5MB or greater. Tune this parameter accordingly, as when it is set with a value lesser than chunk size it degrades the ozone client performance.")
    private int flowControlWindow = 0x500000;

    public int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
    }

    public int getFlowControlWindow() {
        return this.flowControlWindow;
    }

    public void setFlowControlWindow(int flowControlWindow) {
        this.flowControlWindow = flowControlWindow;
    }
}

