/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.rocksdb.HistogramData;
import org.rocksdb.HistogramType;
import org.rocksdb.Statistics;
import org.rocksdb.TickerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBStoreMBean
implements DynamicMBean,
MetricsSource {
    private Statistics statistics;
    private Set<String> histogramAttributes = new HashSet<String>();
    private String contextName;
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBStoreMBean.class);
    public static final String ROCKSDB_CONTEXT_PREFIX = "Rocksdb_";

    public RocksDBStoreMBean(Statistics statistics, String dbName) {
        this.contextName = ROCKSDB_CONTEXT_PREFIX + dbName;
        this.statistics = statistics;
        this.histogramAttributes.add("Average");
        this.histogramAttributes.add("Median");
        this.histogramAttributes.add("Percentile95");
        this.histogramAttributes.add("Percentile99");
        this.histogramAttributes.add("StandardDeviation");
    }

    public static RocksDBStoreMBean create(Statistics statistics, String contextName) {
        RocksDBStoreMBean rocksDBStoreMBean = new RocksDBStoreMBean(statistics, contextName);
        MetricsSystem ms = DefaultMetricsSystem.instance();
        MetricsSource metricsSource = ms.getSource(rocksDBStoreMBean.contextName);
        if (metricsSource != null) {
            return (RocksDBStoreMBean)metricsSource;
        }
        return (RocksDBStoreMBean)ms.register(rocksDBStoreMBean.contextName, "RocksDB Metrics", (Object)rocksDBStoreMBean);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        for (String histogramAttribute : this.histogramAttributes) {
            if (!attribute.endsWith("_" + histogramAttribute.toUpperCase())) continue;
            String keyName = attribute.substring(0, attribute.length() - histogramAttribute.length() - 1);
            try {
                HistogramData histogram = this.statistics.getHistogramData(HistogramType.valueOf((String)keyName));
                try {
                    Method method = HistogramData.class.getMethod("get" + histogramAttribute, new Class[0]);
                    return method.invoke((Object)histogram, new Object[0]);
                }
                catch (Exception e) {
                    throw new ReflectionException(e, "Can't read attribute " + attribute);
                }
            }
            catch (IllegalArgumentException exception) {
                throw new AttributeNotFoundException("No such attribute in RocksDB stats: " + attribute);
            }
        }
        try {
            return this.statistics.getTickerCount(TickerType.valueOf((String)attribute));
        }
        catch (IllegalArgumentException ex) {
            throw new AttributeNotFoundException("No such attribute in RocksDB stats: " + attribute);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList();
        for (String attributeName : attributes) {
            try {
                Object value = this.getAttribute(attributeName);
                result.add(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        for (TickerType tickerType : TickerType.values()) {
            attributes.add(new MBeanAttributeInfo(tickerType.name(), "long", "RocksDBStat: " + tickerType.name(), true, false, false));
        }
        for (TickerType tickerType : HistogramType.values()) {
            for (String histogramAttribute : this.histogramAttributes) {
                attributes.add(new MBeanAttributeInfo(tickerType.name() + "_" + histogramAttribute.toUpperCase(), "long", "RocksDBStat: " + tickerType.name(), true, false, false));
            }
        }
        return new MBeanInfo("", "RocksDBStat", attributes.toArray(new MBeanAttributeInfo[0]), null, null, null);
    }

    public void getMetrics(MetricsCollector metricsCollector, boolean b) {
        MetricsRecordBuilder rb = metricsCollector.addRecord(this.contextName);
        this.getHistogramData(rb);
        this.getTickerTypeData(rb);
    }

    private void getHistogramData(MetricsRecordBuilder rb) {
        for (HistogramType histogramType : HistogramType.values()) {
            HistogramData histogram = this.statistics.getHistogramData(HistogramType.valueOf((String)histogramType.name()));
            for (String histogramAttribute : this.histogramAttributes) {
                try {
                    Method method = HistogramData.class.getMethod("get" + histogramAttribute, new Class[0]);
                    double metricValue = (Double)method.invoke((Object)histogram, new Object[0]);
                    rb.addGauge(Interns.info((String)(histogramType.name() + "_" + histogramAttribute.toUpperCase()), (String)"RocksDBStat"), metricValue);
                }
                catch (Exception e) {
                    LOG.error("Error reading histogram data {} ", (Throwable)e);
                }
            }
        }
    }

    private void getTickerTypeData(MetricsRecordBuilder rb) {
        for (TickerType tickerType : TickerType.values()) {
            rb.addCounter(Interns.info((String)tickerType.name(), (String)"RocksDBStat"), this.statistics.getTickerCount(tickerType));
        }
    }
}

