/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lease;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.ozone.lease.LeaseExpiredException;
import org.apache.hadoop.util.Time;

public class Lease<T> {
    private final T resource;
    private final long creationTime;
    private volatile long leaseTimeout;
    private boolean expired;
    private List<Callable<Void>> callbacks;

    public Lease(T resource, long timeout) {
        this.resource = resource;
        this.leaseTimeout = timeout;
        this.callbacks = Collections.synchronizedList(new ArrayList());
        this.creationTime = Time.monotonicNow();
        this.expired = false;
    }

    public boolean hasExpired() {
        return this.expired;
    }

    public void registerCallBack(Callable<Void> callback) throws LeaseExpiredException {
        if (this.hasExpired()) {
            throw new LeaseExpiredException("Resource: " + this.resource);
        }
        this.callbacks.add(callback);
    }

    public long getElapsedTime() throws LeaseExpiredException {
        if (this.hasExpired()) {
            throw new LeaseExpiredException("Resource: " + this.resource);
        }
        return Time.monotonicNow() - this.creationTime;
    }

    public long getRemainingTime() throws LeaseExpiredException {
        if (this.hasExpired()) {
            throw new LeaseExpiredException("Resource: " + this.resource);
        }
        return this.leaseTimeout - this.getElapsedTime();
    }

    public long getLeaseLifeTime() throws LeaseExpiredException {
        if (this.hasExpired()) {
            throw new LeaseExpiredException("Resource: " + this.resource);
        }
        return this.leaseTimeout;
    }

    public void renew(long timeout) throws LeaseExpiredException {
        if (this.hasExpired()) {
            throw new LeaseExpiredException("Resource: " + this.resource);
        }
        this.leaseTimeout += timeout;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Lease) {
            return this.resource.equals(((Lease)obj).resource);
        }
        return false;
    }

    public String toString() {
        return "Lease<" + this.resource.toString() + ">";
    }

    List<Callable<Void>> getCallbacks() {
        return this.callbacks;
    }

    void invalidate() {
        this.callbacks = null;
        this.expired = true;
    }
}

