/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class OzoneChecksumException
extends IOException {
    public OzoneChecksumException(int index) {
        super(String.format("Checksum mismatch at index %d", index));
    }

    public OzoneChecksumException(ContainerProtos.ChecksumType unrecognizedChecksumType) {
        super(String.format("Unrecognized ChecksumType: %s", new Object[]{unrecognizedChecksumType}));
    }

    public OzoneChecksumException(String algorithm, NoSuchAlgorithmException ex) {
        super(String.format("NoSuchAlgorithmException thrown while computing SHA-256 checksum using algorithm %s", algorithm), ex);
    }

    public OzoneChecksumException(String message) {
        super(message);
    }
}

