/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.audit;

import java.util.Map;
import org.apache.logging.log4j.message.Message;

public class AuditMessage
implements Message {
    private String message;
    private Throwable throwable;
    private static final String MSG_PATTERN = "user=%s | ip=%s | op=%s %s | ret=%s";

    public String getFormattedMessage() {
        return this.message;
    }

    public String getFormat() {
        return null;
    }

    public Object[] getParameters() {
        return new Object[0];
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    private void appendMessage(String customMessage) {
        this.message = this.message + customMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public static class Builder {
        private Throwable throwable;
        private String user;
        private String ip;
        private String op;
        private Map<String, String> params;
        private String ret;

        public Builder setUser(String usr) {
            this.user = usr;
            return this;
        }

        public Builder atIp(String ipAddr) {
            this.ip = ipAddr;
            return this;
        }

        public Builder forOperation(String operation) {
            this.op = operation;
            return this;
        }

        public Builder withParams(Map<String, String> args) {
            this.params = args;
            return this;
        }

        public Builder withResult(String result) {
            this.ret = result;
            return this;
        }

        public Builder withException(Throwable ex) {
            this.throwable = ex;
            return this;
        }

        public AuditMessage build() {
            AuditMessage auditMessage = new AuditMessage();
            auditMessage.message = String.format(AuditMessage.MSG_PATTERN, this.user, this.ip, this.op, this.params, this.ret);
            auditMessage.throwable = this.throwable;
            return auditMessage;
        }
    }
}

