/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class OzoneSecurityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneSecurityUtil.class);
    private static final Set<String> INVALID_IPS = new HashSet<String>(Arrays.asList("0.0.0.0", "127.0.0.1"));

    private OzoneSecurityUtil() {
    }

    public static boolean isSecurityEnabled(Configuration conf) {
        return conf.getBoolean("ozone.security.enabled", false);
    }

    public static boolean checkIfFileExist(Path path, String fileName) {
        return Files.exists(path, new LinkOption[0]) && Files.exists(Paths.get(path.toString(), fileName), new LinkOption[0]);
    }

    public static List<InetAddress> getValidInetsForCurrentHost() throws IOException {
        ArrayList<InetAddress> hostIps = new ArrayList<InetAddress>();
        InetAddressValidator ipValidator = InetAddressValidator.getInstance();
        Enumeration<NetworkInterface> enumNI = NetworkInterface.getNetworkInterfaces();
        if (enumNI != null) {
            while (enumNI.hasMoreElements()) {
                NetworkInterface ifc = enumNI.nextElement();
                if (!ifc.isUp()) continue;
                Enumeration<InetAddress> enumAdds = ifc.getInetAddresses();
                while (enumAdds.hasMoreElements()) {
                    InetAddress addr = enumAdds.nextElement();
                    if (ipValidator.isValid(addr.getHostAddress()) && !INVALID_IPS.contains(addr.getHostAddress())) {
                        LOG.info("Adding ip:{},host:{}", (Object)addr.getHostAddress(), (Object)addr.getHostName());
                        hostIps.add(addr);
                        continue;
                    }
                    LOG.info("ip:{},host:{} not returned.", (Object)addr.getHostAddress(), (Object)addr.getHostName());
                }
            }
            return hostIps;
        }
        throw new IOException("Unable to get network interfaces.");
    }
}

