/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OzoneBlockTokenSelector
implements TokenSelector<OzoneBlockTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneBlockTokenSelector.class);

    public Token<OzoneBlockTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (!OzoneBlockTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !token.getService().equals((Object)service)) continue;
            LOG.trace("Getting token for service:{}", (Object)service);
            return token;
        }
        return null;
    }

    public static Token<OzoneBlockTokenIdentifier> selectBlockToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (!OzoneBlockTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !token.getService().equals((Object)service)) continue;
            LOG.trace("Getting token for service:{}", (Object)service);
            return token;
        }
        return null;
    }
}

