/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.token.BlockTokenException;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.hdds.security.token.TokenVerifier;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockTokenVerifier
implements TokenVerifier {
    private final CertificateClient caClient;
    private final SecurityConfig conf;
    private static boolean testStub = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockTokenVerifier.class);

    public BlockTokenVerifier(SecurityConfig conf, CertificateClient caClient) {
        this.conf = conf;
        this.caClient = caClient;
    }

    private boolean isExpired(long expiryDate) {
        return Time.now() > expiryDate;
    }

    @Override
    public UserGroupInformation verify(String user, String tokenStr) throws SCMSecurityException {
        if (this.conf.isBlockTokenEnabled()) {
            if (Strings.isNullOrEmpty((String)tokenStr)) {
                throw new BlockTokenException("Fail to find any token (empty or null.)");
            }
            Token token = new Token();
            OzoneBlockTokenIdentifier tokenId = new OzoneBlockTokenIdentifier();
            try {
                token.decodeFromUrlString(tokenStr);
                LOGGER.debug("Verifying token:{} for user:{} ", (Object)token, (Object)user);
                ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
                DataInputStream in = new DataInputStream(buf);
                tokenId.readFields(in);
            }
            catch (IOException ex) {
                throw new BlockTokenException("Failed to decode token : " + tokenStr);
            }
            if (this.caClient == null) {
                throw new SCMSecurityException("Certificate client not available to validate token");
            }
            X509Certificate singerCert = this.caClient.getCertificate(tokenId.getOmCertSerialId());
            if (singerCert == null) {
                throw new BlockTokenException("Can't find signer certificate (OmCertSerialId: " + tokenId.getOmCertSerialId() + ") of the block token for user: " + tokenId.getUser());
            }
            boolean validToken = this.caClient.verifySignature(tokenId.getBytes(), token.getPassword(), singerCert);
            if (!validToken) {
                throw new BlockTokenException("Invalid block token for user: " + tokenId.getUser());
            }
            if (this.isExpired(tokenId.getExpiryDate())) {
                UserGroupInformation tokenUser = tokenId.getUser();
                tokenUser.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.TOKEN);
                throw new BlockTokenException("Expired block token for user: " + tokenUser);
            }
            UserGroupInformation ugi = tokenId.getUser();
            ugi.addToken(token);
            ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.TOKEN);
            return ugi;
        }
        return UserGroupInformation.createRemoteUser((String)user);
    }

    public static boolean isTestStub() {
        return testStub;
    }

    public static void setTestStub(boolean isTestStub) {
        testStub = isTestStub;
    }
}

