/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocolPB;

import com.google.common.base.Preconditions;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;

@InterfaceAudience.Private
public final class StorageContainerLocationProtocolClientSideTranslatorPB
implements StorageContainerLocationProtocol,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final StorageContainerLocationProtocolPB rpcProxy;

    public StorageContainerLocationProtocolClientSideTranslatorPB(StorageContainerLocationProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public ContainerWithPipeline allocateContainer(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        StorageContainerLocationProtocolProtos.ContainerResponseProto response;
        StorageContainerLocationProtocolProtos.ContainerRequestProto request = StorageContainerLocationProtocolProtos.ContainerRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setReplicationFactor(factor).setReplicationType(type).setOwner(owner).build();
        try {
            response = this.rpcProxy.allocateContainer(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (response.getErrorCode() != StorageContainerLocationProtocolProtos.ContainerResponseProto.Error.success) {
            throw new IOException(response.hasErrorMessage() ? response.getErrorMessage() : "Allocate container failed.");
        }
        return ContainerWithPipeline.fromProtobuf(response.getContainerWithPipeline());
    }

    @Override
    public ContainerInfo getContainer(long containerID) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.GetContainerRequestProto request = StorageContainerLocationProtocolProtos.GetContainerRequestProto.newBuilder().setContainerID(containerID).setTraceID(TracingUtil.exportCurrentSpan()).build();
        try {
            StorageContainerLocationProtocolProtos.GetContainerResponseProto response = this.rpcProxy.getContainer(NULL_RPC_CONTROLLER, request);
            return ContainerInfo.fromProtobuf(response.getContainerInfo());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public ContainerWithPipeline getContainerWithPipeline(long containerID) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto request = StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setContainerID(containerID).build();
        try {
            StorageContainerLocationProtocolProtos.GetContainerWithPipelineResponseProto response = this.rpcProxy.getContainerWithPipeline(NULL_RPC_CONTROLLER, request);
            return ContainerWithPipeline.fromProtobuf(response.getContainerWithPipeline());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public List<ContainerInfo> listContainer(long startContainerID, int count) throws IOException {
        Preconditions.checkState((startContainerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative.");
        Preconditions.checkState((count > 0 ? 1 : 0) != 0, (Object)"Container count must be greater than 0.");
        StorageContainerLocationProtocolProtos.SCMListContainerRequestProto.Builder builder = StorageContainerLocationProtocolProtos.SCMListContainerRequestProto.newBuilder();
        builder.setStartContainerID(startContainerID);
        builder.setCount(count);
        builder.setTraceID(TracingUtil.exportCurrentSpan());
        StorageContainerLocationProtocolProtos.SCMListContainerRequestProto request = builder.build();
        try {
            StorageContainerLocationProtocolProtos.SCMListContainerResponseProto response = this.rpcProxy.listContainer(NULL_RPC_CONTROLLER, request);
            ArrayList<ContainerInfo> containerList = new ArrayList<ContainerInfo>();
            for (HddsProtos.ContainerInfoProto containerInfoProto : response.getContainersList()) {
                containerList.add(ContainerInfo.fromProtobuf(containerInfoProto));
            }
            return containerList;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void deleteContainer(long containerID) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto request = StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setContainerID(containerID).build();
        try {
            this.rpcProxy.deleteContainer(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public List<HddsProtos.Node> queryNode(HddsProtos.NodeState nodeStatuses, HddsProtos.QueryScope queryScope, String poolName) throws IOException {
        Preconditions.checkNotNull((Object)((Object)nodeStatuses));
        StorageContainerLocationProtocolProtos.NodeQueryRequestProto request = StorageContainerLocationProtocolProtos.NodeQueryRequestProto.newBuilder().setState(nodeStatuses).setTraceID(TracingUtil.exportCurrentSpan()).setScope(queryScope).setPoolName(poolName).build();
        try {
            StorageContainerLocationProtocolProtos.NodeQueryResponseProto response = this.rpcProxy.queryNode(NULL_RPC_CONTROLLER, request);
            return response.getDatanodesList();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void notifyObjectStageChange(StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Type type, long id, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Op op, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Stage stage) throws IOException {
        Preconditions.checkState((id >= 0L ? 1 : 0) != 0, (Object)"Object id cannot be negative.");
        StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto request = StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setType(type).setId(id).setOp(op).setStage(stage).build();
        try {
            this.rpcProxy.notifyObjectStageChange(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        StorageContainerLocationProtocolProtos.PipelineRequestProto request = StorageContainerLocationProtocolProtos.PipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setNodePool(nodePool).setReplicationFactor(factor).setReplicationType(replicationType).build();
        try {
            StorageContainerLocationProtocolProtos.PipelineResponseProto response = this.rpcProxy.allocatePipeline(NULL_RPC_CONTROLLER, request);
            if (response.getErrorCode() == StorageContainerLocationProtocolProtos.PipelineResponseProto.Error.success) {
                Preconditions.checkState((boolean)response.hasPipeline(), (Object)"With success, must come a pipeline");
                return Pipeline.getFromProtobuf(response.getPipeline());
            }
            String errorMessage = String.format("create replication pipeline failed. code : %s Message: %s", new Object[]{response.getErrorCode(), response.hasErrorMessage() ? response.getErrorMessage() : ""});
            throw new IOException(errorMessage);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public List<Pipeline> listPipelines() throws IOException {
        try {
            StorageContainerLocationProtocolProtos.ListPipelineRequestProto request = StorageContainerLocationProtocolProtos.ListPipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).build();
            StorageContainerLocationProtocolProtos.ListPipelineResponseProto response = this.rpcProxy.listPipelines(NULL_RPC_CONTROLLER, request);
            ArrayList<Pipeline> list = new ArrayList<Pipeline>();
            for (HddsProtos.Pipeline pipeline : response.getPipelinesList()) {
                Pipeline fromProtobuf = Pipeline.getFromProtobuf(pipeline);
                list.add(fromProtobuf);
            }
            return list;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void closePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        try {
            StorageContainerLocationProtocolProtos.ClosePipelineRequestProto request = StorageContainerLocationProtocolProtos.ClosePipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setPipelineID(pipelineID).build();
            this.rpcProxy.closePipeline(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public ScmInfo getScmInfo() throws IOException {
        HddsProtos.GetScmInfoRequestProto request = HddsProtos.GetScmInfoRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).build();
        try {
            HddsProtos.GetScmInfoResponseProto resp = this.rpcProxy.getScmInfo(NULL_RPC_CONTROLLER, request);
            ScmInfo.Builder builder = new ScmInfo.Builder().setClusterId(resp.getClusterId()).setScmId(resp.getScmId());
            return builder.build();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public boolean inSafeMode() throws IOException {
        StorageContainerLocationProtocolProtos.InSafeModeRequestProto request = StorageContainerLocationProtocolProtos.InSafeModeRequestProto.getDefaultInstance();
        try {
            StorageContainerLocationProtocolProtos.InSafeModeResponseProto resp = this.rpcProxy.inSafeMode(NULL_RPC_CONTROLLER, request);
            return resp.getInSafeMode();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public boolean forceExitSafeMode() throws IOException {
        StorageContainerLocationProtocolProtos.ForceExitSafeModeRequestProto request = StorageContainerLocationProtocolProtos.ForceExitSafeModeRequestProto.getDefaultInstance();
        try {
            StorageContainerLocationProtocolProtos.ForceExitSafeModeResponseProto resp = this.rpcProxy.forceExitSafeMode(NULL_RPC_CONTROLLER, request);
            return resp.getExitedSafeMode();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void startReplicationManager() throws IOException {
        try {
            StorageContainerLocationProtocolProtos.StartReplicationManagerRequestProto request = StorageContainerLocationProtocolProtos.StartReplicationManagerRequestProto.getDefaultInstance();
            this.rpcProxy.startReplicationManager(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void stopReplicationManager() throws IOException {
        try {
            StorageContainerLocationProtocolProtos.StopReplicationManagerRequestProto request = StorageContainerLocationProtocolProtos.StopReplicationManagerRequestProto.getDefaultInstance();
            this.rpcProxy.stopReplicationManager(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public boolean getReplicationManagerStatus() throws IOException {
        try {
            StorageContainerLocationProtocolProtos.ReplicationManagerStatusRequestProto request = StorageContainerLocationProtocolProtos.ReplicationManagerStatusRequestProto.getDefaultInstance();
            StorageContainerLocationProtocolProtos.ReplicationManagerStatusResponseProto response = this.rpcProxy.getReplicationManagerStatus(NULL_RPC_CONTROLLER, request);
            return response.getIsRunning();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }
}

