/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.common.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;

public class ExcludeList {
    private final List<DatanodeDetails> datanodes = new ArrayList<DatanodeDetails>();
    private final List<ContainerID> containerIds = new ArrayList<ContainerID>();
    private final List<PipelineID> pipelineIds = new ArrayList<PipelineID>();

    public List<ContainerID> getContainerIds() {
        return this.containerIds;
    }

    public List<DatanodeDetails> getDatanodes() {
        return this.datanodes;
    }

    public void addDatanodes(Collection<DatanodeDetails> dns) {
        this.datanodes.addAll(dns);
    }

    public void addDatanode(DatanodeDetails dn) {
        this.datanodes.add(dn);
    }

    public void addConatinerId(ContainerID containerId) {
        this.containerIds.add(containerId);
    }

    public void addPipeline(PipelineID pipelineId) {
        this.pipelineIds.add(pipelineId);
    }

    public List<PipelineID> getPipelineIds() {
        return this.pipelineIds;
    }

    public HddsProtos.ExcludeListProto getProtoBuf() {
        HddsProtos.ExcludeListProto.Builder builder = HddsProtos.ExcludeListProto.newBuilder();
        this.containerIds.forEach(id -> builder.addContainerIds(id.getId()));
        this.datanodes.forEach(dn -> builder.addDatanodes(dn.getUuidString()));
        this.pipelineIds.forEach(pipelineID -> builder.addPipelineIds(pipelineID.getProtobuf()));
        return builder.build();
    }

    public static ExcludeList getFromProtoBuf(HddsProtos.ExcludeListProto excludeListProto) {
        ExcludeList excludeList = new ExcludeList();
        excludeListProto.getContainerIdsList().forEach(id -> excludeList.addConatinerId(ContainerID.valueof(id)));
        DatanodeDetails.Builder builder = DatanodeDetails.newBuilder();
        excludeListProto.getDatanodesList().forEach(dn -> {
            builder.setUuid((String)dn);
            excludeList.addDatanode(builder.build());
        });
        excludeListProto.getPipelineIdsList().forEach(pipelineID -> excludeList.addPipeline(PipelineID.getFromProtobuf(pipelineID)));
        return excludeList;
    }

    public void clear() {
        this.datanodes.clear();
        this.containerIds.clear();
        this.pipelineIds.clear();
    }
}

