/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;

public final class ByteStringHelper {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    private static volatile boolean isUnsafeByteOperationsEnabled;

    private ByteStringHelper() {
    }

    public static void init(boolean isUnsafeByteOperation) {
        boolean set = INITIALIZED.compareAndSet(false, true);
        if (set) {
            isUnsafeByteOperationsEnabled = isUnsafeByteOperation;
        } else {
            Preconditions.checkState((isUnsafeByteOperationsEnabled == isUnsafeByteOperation ? 1 : 0) != 0);
        }
    }

    private static ByteString copyFrom(ByteBuffer buffer) {
        ByteString bytes = ByteString.copyFrom((ByteBuffer)buffer);
        buffer.flip();
        return bytes;
    }

    public static ByteString getByteString(ByteBuffer buffer) {
        return isUnsafeByteOperationsEnabled ? UnsafeByteOperations.unsafeWrap((ByteBuffer)buffer) : ByteStringHelper.copyFrom(buffer);
    }

    public static ByteString getByteString(byte[] bytes) {
        return isUnsafeByteOperationsEnabled ? UnsafeByteOperations.unsafeWrap((byte[])bytes) : ByteString.copyFrom((byte[])bytes);
    }
}

